/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MToolkitThreadBlockedHandler;

public class MFileDialogPeer
extends MDialogPeer
implements FileDialogPeer {
    private FilenameFilter filter;
    private String[] NativeFilteredFiles;

    native void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    public MFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
        FileDialog fileDialog2 = fileDialog;
        String string = fileDialog2.getDirectory();
        String string2 = fileDialog2.getFile();
        FilenameFilter filenameFilter = fileDialog2.getFilenameFilter();
        this.insets = new Insets(0, 0, 0, 0);
        this.setDirectory(string);
        if (string2 != null) {
            this.setFile(string2);
        }
        this.setFilenameFilter(filenameFilter);
    }

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pShow();

    native void pHide();

    native void setFileEntry(String var1, String var2, String[] var3);

    native void insertReplaceFileDialogText(String var1);

    public native void setFont(Font var1);

    String getFilteredFile(String string) {
        String string2;
        if (string == null) {
            string = ((FileDialog)this.target).getFile();
        }
        if ((string2 = ((FileDialog)this.target).getDirectory()) == null) {
            string2 = "./";
        }
        if (string == null) {
            string = "";
        }
        if (this.filter != null && !this.filter.accept(new File(string2), string)) {
            string = "";
        }
        return string;
    }

    public void handleSelected(final String string) {
        final FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                String string2;
                int n = string.lastIndexOf(File.separatorChar);
                if (n == -1) {
                    string2 = "." + File.separator;
                    fileDialog.setFile(string);
                } else {
                    string2 = string.substring(0, n + 1);
                    fileDialog.setFile(string.substring(n + 1));
                }
                fileDialog.setDirectory(string2);
                fileDialog.hide();
            }
        });
    }

    public void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.setFile(null);
                fileDialog.hide();
            }
        });
    }

    public void handleQuit() {
        final FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.hide();
            }
        });
    }

    public void setDirectory(String string) {
        String string2 = ((FileDialog)this.target).getFile();
        this.setFileEntry(string != null ? string : "./", string2 != null ? string2 : "", null);
    }

    public void setFile(String string) {
        String string2 = ((FileDialog)this.target).getDirectory();
        if (string2 == null) {
            string2 = "./";
        }
        this.setFileEntry(string2 != null ? string2 : "./", this.getFilteredFile(null), null);
    }

    public void doFilter(FilenameFilter filenameFilter, String string) {
        String string2 = string == null ? ((FileDialog)this.target).getDirectory() : string;
        String string3 = this.getFilteredFile(null);
        final File file = new File(string2 != null ? string2 : ".");
        final DirectoryFilter directoryFilter = new DirectoryFilter(filenameFilter);
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.list(directoryFilter);
            }
        });
        String[] stringArray2 = this.NativeFilteredFiles;
        if (stringArray != null) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray2 != null) {
                block0: for (n = 0; n < stringArray.length; ++n) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!stringArray[n].equals(stringArray2[i])) continue;
                        arrayList.add(stringArray[n]);
                        continue block0;
                    }
                }
            }
            stringArray = new String[arrayList.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)arrayList.get(n);
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        this.setFileEntry(string2 != null ? string2 : ".", string3 != null ? string3 : "", stringArray);
    }

    private boolean proceedFiltering(final String string, String[] stringArray, boolean bl) {
        this.NativeFilteredFiles = stringArray;
        if (!bl || this.filter == null) {
            try {
                this.doFilter(this.filter, string);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        final ToolkitThreadBlockedHandler toolkitThreadBlockedHandler = MToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        blArray[0] = false;
        blArray2[0] = false;
        toolkitThreadBlockedHandler.lock();
        MToolkit.executeOnEventHandlerThread((FileDialog)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                toolkitThreadBlockedHandler.lock();
                try {
                    MFileDialogPeer.this.doFilter(MFileDialogPeer.this.filter, string);
                    blArray2[0] = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    blArray2[0] = false;
                }
                finally {
                    blArray[0] = true;
                    toolkitThreadBlockedHandler.exit();
                    toolkitThreadBlockedHandler.unlock();
                }
            }
        });
        while (!blArray[0]) {
            toolkitThreadBlockedHandler.enter();
        }
        toolkitThreadBlockedHandler.unlock();
        return blArray2[0];
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        FileDialog fileDialog = (FileDialog)this.target;
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        this.setFile(string2);
        this.doFilter(filenameFilter, null);
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertReplaceFileDialogText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void show() {
        this.setVisible(true);
        this.setFilenameFilter(this.filter);
    }

    public void restack() {
    }

    public boolean isRestackSupported() {
        return false;
    }

    class DirectoryFilter
    implements FilenameFilter {
        FilenameFilter userFilter;

        DirectoryFilter(FilenameFilter filenameFilter) {
            this.userFilter = filenameFilter;
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                return false;
            }
            if (this.userFilter != null) {
                return this.userFilter.accept(file, string);
            }
            return true;
        }
    }
}

