/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.HashSet;
import sun.awt.X11GraphicsConfig;
import sun.java2d.opengl.GLXGraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    private static DisplayMode displayMode;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int n) {
        this.screen = n;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    public native long getDisplay();

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ":0." + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n = 1;
            int n2 = this.getNumConfigs(this.screen);
            graphicsConfigurationArray = new GraphicsConfiguration[n2];
            graphicsConfigurationArray[0] = this.defaultConfig == null ? this.getDefaultConfiguration() : this.defaultConfig;
            boolean bl = GLXGraphicsConfig.isGLXAvailable();
            boolean bl2 = X11GraphicsDevice.isDBESupported();
            if (bl2 && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (n < n2) {
                int n3 = this.getConfigVisualId(n, this.screen);
                int n4 = this.getConfigDepth(n, this.screen);
                if (bl) {
                    graphicsConfigurationArray[n] = GLXGraphicsConfig.getConfig(this, n3);
                }
                if (graphicsConfigurationArray[n] == null) {
                    boolean bl3 = bl2 && this.doubleBufferVisuals.contains(new Integer(n3));
                    graphicsConfigurationArray[n] = X11GraphicsConfig.getConfig(this, n3, n4, this.getConfigColormap(n, this.screen), bl3);
                }
                ++n;
            }
            this.configs = graphicsConfigurationArray;
        }
        return (GraphicsConfiguration[])graphicsConfigurationArray.clone();
    }

    public native int getNumConfigs(int var1);

    public native int getConfigVisualId(int var1, int var2);

    public native int getConfigDepth(int var1, int var2);

    public native int getConfigColormap(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(int n) {
        this.doubleBufferVisuals.add(new Integer(n));
    }

    private native void getDoubleBufferVisuals(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n = this.getConfigVisualId(0, this.screen);
            int n2 = this.getConfigDepth(0, this.screen);
            if (GLXGraphicsConfig.isGLXAvailable()) {
                this.defaultConfig = GLXGraphicsConfig.getConfig(this, n);
                if (GLXGraphicsConfig.isGLXVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                boolean bl = false;
                if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                    this.doubleBufferVisuals = new HashSet();
                    this.getDoubleBufferVisuals(this.screen);
                    bl = this.doubleBufferVisuals.contains(new Integer(n));
                }
                this.defaultConfig = X11GraphicsConfig.getConfig(this, n, n2, this.getConfigColormap(0, this.screen), bl);
            }
        }
        return this.defaultConfig;
    }

    public DisplayMode getDisplayMode() {
        if (displayMode == null) {
            GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            displayMode = new DisplayMode(rectangle.width, rectangle.height, -1, 0);
        }
        return displayMode;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

