/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.peer.PopupMenuPeer;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuPeer;

public class XPopupMenuPeer
extends XMenuPeer
implements PopupMenuPeer {
    static XPopupMenuPeer showingPopupMenu;
    private boolean dragDetected = false;
    private boolean pressDetected = false;

    public XPopupMenuPeer(PopupMenu popupMenu) {
        super(popupMenu, true);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.setBackground(((Component)this.getParent()).getBackground());
    }

    public void show(Event event) {
        if (this.getParent() instanceof Component) {
            this.create();
            Point point = ((Component)event.target).getLocationOnScreen();
            event.x += point.x;
            event.y += point.y;
            if (this.getShowingPopupMenu() != null) {
                this.getShowingPopupMenu().popdown(null, false);
            }
        } else {
            throw new IllegalArgumentException("illegal popup menu container class");
        }
        this.popup(event.x, event.y);
        this.setShowingPopupMenu(this);
        this.grabInput();
        this.dragDetected = false;
        this.pressDetected = false;
    }

    void popdown(MouseEvent mouseEvent, boolean bl) {
        this.setPosted(false);
        XPopupMenuPeer.ungrabInput();
        super.popdown(mouseEvent, bl);
        if (this.getShowingPopupMenu() == this) {
            this.setShowingPopupMenu(null);
        }
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.pressDetected = true;
                if (!(XAwtState.getGrabWindow() != this || this.contains(mouseEvent.getX(), mouseEvent.getY(), 0) || this.getMenu() != null && this.getMenu().cascadeContains(this, mouseEvent.getPoint(), 0))) {
                    this.popdown(mouseEvent, false);
                }
                super.handleJavaMouseEvent(mouseEvent);
                break;
            }
            case 502: {
                if (!this.isCreated()) break;
                if (this.lastMenuContains(this, mouseEvent.getPoint(), 0)) {
                    if (!this.pressDetected && !this.dragDetected) break;
                    this.popdown(mouseEvent, true);
                    break;
                }
                this.doPosting(this, mouseEvent.getPoint(), 0);
                break;
            }
            case 506: {
                this.dragDetected = true;
                super.handleJavaMouseEvent(mouseEvent);
            }
        }
    }

    public void dispose() {
        if (this.getShowingPopupMenu() == this) {
            this.setShowingPopupMenu(null);
        }
        super.dispose();
    }

    XPopupMenuPeer getShowingPopupMenu() {
        return showingPopupMenu;
    }

    void setShowingPopupMenu(XPopupMenuPeer xPopupMenuPeer) {
        showingPopupMenu = xPopupMenuPeer;
    }
}

