/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XMWMModality;
import sun.awt.X11.XModalityProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XNETProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol,
XModalityProtocol {
    static final Logger log = Logger.getLogger("sun.awt.X11.XNETProtocol");
    XModalityProtocol modalDelegate = new XMWMModality();
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    XAtom XA_NET_SUPPORTING_WM_CHECK = XAtom.get("_NET_SUPPORTING_WM_CHECK");
    XAtom XA_NET_SUPPORTED = XAtom.get("_NET_SUPPORTED");
    XAtom XA_NET_WM_NAME = XAtom.get("_NET_WM_NAME");
    XAtom XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
    XAtom XA_NET_WM_STATE_MAXIMIZED_HORZ = XAtom.get("_NET_WM_STATE_MAXIMIZED_HORZ");
    XAtom XA_NET_WM_STATE_MAXIMIZED_VERT = XAtom.get("_NET_WM_STATE_MAXIMIZED_VERT");
    XAtom XA_NET_WM_STATE_SHADED = XAtom.get("_NET_WM_STATE_SHADED");
    XAtom XA_NET_WM_STATE_ABOVE = XAtom.get("_NET_WM_STATE_ABOVE");
    XAtom XA_NET_WM_STATE_MODAL = XAtom.get("_NET_WM_STATE_MODAL");
    XAtom XA_NET_WM_STATE_FULLSCREEN = XAtom.get("_NET_WM_STATE_FULLSCREEN");
    XAtom XA_NET_WM_STATE_BELOW = XAtom.get("_NET_WM_STATE_BELOW");
    XAtom XA_NET_WM_WINDOW_TYPE = XAtom.get("_NET_WM_WINDOW_TYPE");
    XAtom XA_NET_WM_WINDOW_TYPE_DIALOG = XAtom.get("_NET_WM_WINDOW_TYPE_DIALOG");
    static final int _NET_WM_STATE_REMOVE = 0;
    static final int _NET_WM_STATE_ADD = 1;
    static final int _NET_WM_STATE_TOGGLE = 2;
    boolean supportChecked = false;
    long NetWindow = 0L;

    XNETProtocol() {
    }

    public boolean supportsState(int n) {
        return this.doStateProtocol();
    }

    public void setState(XWindowPeer xWindowPeer, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting state of " + xWindowPeer + " to " + n);
        }
        if (xWindowPeer.isShowing()) {
            this.requestState(xWindowPeer, n);
        } else {
            this.setInitialState(xWindowPeer, n);
        }
    }

    private void setInitialState(XWindowPeer xWindowPeer, int n) {
        XAtomList xAtomList = this.XA_NET_WM_STATE.getAtomListPropertyList(xWindowPeer);
        log.log(Level.FINE, "Current state of the window {0} is {1}", new Object[]{String.valueOf(xWindowPeer), String.valueOf(xAtomList)});
        if ((n & 4) != 0) {
            xAtomList.add(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        } else {
            xAtomList.remove(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        }
        if ((n & 2) != 0) {
            xAtomList.add(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        } else {
            xAtomList.remove(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        }
        log.log(Level.FINE, "Setting initial state of the window {0} to {1}", new Object[]{String.valueOf(xWindowPeer), String.valueOf(xAtomList)});
        this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)xWindowPeer, xAtomList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestState(XWindowPeer xWindowPeer, int n) {
        int n2 = this.getState(xWindowPeer);
        int n3 = (n ^ n2) & 6;
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            switch (n3) {
                case 0: {
                    return;
                }
                case 2: {
                    xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                    xClientMessageEvent.set_data(2, 0L);
                    break;
                }
                case 4: {
                    xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                    xClientMessageEvent.set_data(2, 0L);
                    break;
                }
                case 6: {
                    xClientMessageEvent.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                    xClientMessageEvent.set_data(2, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                    break;
                }
                default: {
                    return;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Requesting state on " + xWindowPeer + " for " + n);
            }
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindowPeer.getWindow());
            xClientMessageEvent.set_message_type(this.XA_NET_WM_STATE.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, 2L);
            try {
                XToolkit.awtLock();
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 0x180000L, xClientMessageEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    public int getState(XWindowPeer xWindowPeer) {
        XAtom[] xAtomArray = this.XA_NET_WM_STATE.getAtomListProperty(xWindowPeer);
        if (xAtomArray.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < xAtomArray.length; ++i) {
            if (this.XA_NET_WM_STATE_MAXIMIZED_VERT.equals(xAtomArray[i])) {
                n |= 4;
                continue;
            }
            if (!this.XA_NET_WM_STATE_MAXIMIZED_HORZ.equals(xAtomArray[i])) continue;
            n |= 2;
        }
        return n;
    }

    public boolean isStateChange(XPropertyEvent xPropertyEvent) {
        return this.doStateProtocol() && xPropertyEvent.get_atom() == this.XA_NET_WM_STATE.getAtom();
    }

    public void unshadeKludge(XWindowPeer xWindowPeer) {
        XAtomList xAtomList = this.XA_NET_WM_STATE.getAtomListPropertyList(xWindowPeer);
        xAtomList.remove(this.XA_NET_WM_STATE_SHADED);
        this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)xWindowPeer, xAtomList);
    }

    public boolean supportsLayer(int n) {
        return (n == 1 || n == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateHelper(XWindowPeer xWindowPeer, XAtom xAtom, boolean bl) {
        Object object;
        block9: {
            log.log(Level.FINER, "Window visibility is: withdrawn={0}, visible={1}, mapped={2} showing={3}", new Object[]{xWindowPeer.isWithdrawn(), xWindowPeer.isVisible(), xWindowPeer.isMapped(), xWindowPeer.isShowing()});
            if (xWindowPeer.isShowing()) {
                object = new XClientMessageEvent();
                try {
                    ((XClientMessageEvent)object).set_type(33);
                    ((XClientMessageEvent)object).set_window(xWindowPeer.getWindow());
                    ((XClientMessageEvent)object).set_message_type(this.XA_NET_WM_STATE.getAtom());
                    ((XClientMessageEvent)object).set_format(32);
                    ((XClientMessageEvent)object).set_data(0, !bl ? 0L : 1L);
                    ((XClientMessageEvent)object).set_data(1, xAtom.getAtom());
                    log.log(Level.FINE, "Setting _NET_STATE atom {0} on {1} for {2}", new Object[]{String.valueOf(xAtom), String.valueOf(xWindowPeer), bl});
                    try {
                        XToolkit.awtLock();
                        XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 0x180000L, ((XClientMessageEvent)object).pData);
                        break block9;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                finally {
                    ((XClientMessageEvent)object).dispose();
                }
            }
            object = this.XA_NET_WM_STATE.getAtomListPropertyList(xWindowPeer);
            log.log(Level.FINE, "Current state on {0} is {1}", new Object[]{String.valueOf(xWindowPeer), object});
            if (!bl) {
                ((XAtomList)object).remove(xAtom);
            } else {
                ((XAtomList)object).add(xAtom);
            }
            log.log(Level.FINE, "Setting states on {0} to {1}", new Object[]{String.valueOf(xWindowPeer), object});
            this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)xWindowPeer, (XAtomList)object);
            XToolkit.XSync();
        }
        object = this.XA_NET_WM_STATE.getAtomListPropertyList(xWindowPeer);
        log.log(Level.FINE, "State after set on window {0} is {1}", new Object[]{xWindowPeer, object});
    }

    public void setLayer(XWindowPeer xWindowPeer, int n) {
        this.setStateHelper(xWindowPeer, this.XA_NET_WM_STATE_ABOVE, n == 1);
    }

    public boolean setModal(XDialogPeer xDialogPeer, boolean bl) {
        log.log(Level.FINE, "Setting modality for {0} to {1}", new Object[]{xDialogPeer, bl});
        this.XA_NET_WM_WINDOW_TYPE.setAtomListProperty((XBaseWindow)xDialogPeer, new XAtom[]{this.XA_NET_WM_WINDOW_TYPE_DIALOG});
        XToolkit.XSync();
        this.setStateHelper(xDialogPeer, this.XA_NET_WM_STATE_MODAL, bl);
        this.modalDelegate.setModal(xDialogPeer, bl);
        return false;
    }

    public boolean isBlocked(XDialogPeer xDialogPeer, XWindowPeer xWindowPeer) {
        return this.modalDelegate.isBlocked(xDialogPeer, xWindowPeer);
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.NetWindow = this.checkAnchor(this.XA_NET_SUPPORTING_WM_CHECK, 33L);
        this.supportChecked = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " is active: " + (this.NetWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.NetWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE);
        return bl;
    }

    boolean doLayerProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_ABOVE);
        return bl;
    }

    boolean doModalityProtocol() {
        boolean bl = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_MODAL);
        return bl;
    }

    boolean isWMName(String string) {
        if (!this.active()) {
            return false;
        }
        String string2 = this.getWMName();
        if (string2 == null) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("### WM_NAME = " + string2);
        }
        return string2.startsWith(string);
    }

    public String getWMName() {
        if (!this.active()) {
            return null;
        }
        String string = "UTF8";
        byte[] byArray = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, this.XA_UTF8_STRING.getAtom());
        if (byArray == null) {
            byArray = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, 31L);
            string = "ASCII";
        }
        if (byArray == null) {
            return null;
        }
        try {
            String string2 = new String(byArray, string);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

