/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public class XKeyboardFocusManagerPeer
implements KeyboardFocusManagerPeer {
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XKeyboardFocusManagerPeer");
    KeyboardFocusManager manager;
    private static Object lock = new Lock();
    private static Component currentFocusOwner;
    private static Window currentFocusedWindow;
    static Method shouldNativelyFocusHeavyweightMethod;

    XKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) {
        this.manager = keyboardFocusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusOwner(Component component) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focus owner " + component);
        }
        Object object = lock;
        synchronized (object) {
            currentFocusOwner = component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusedWindow(Window window) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focused window " + window);
        }
        Object object = lock;
        synchronized (object) {
            currentFocusedWindow = window;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Component getCurrentNativeFocusOwner() {
        Object object = lock;
        synchronized (object) {
            return currentFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Window getCurrentNativeFocusedWindow() {
        Object object = lock;
        synchronized (object) {
            return currentFocusedWindow;
        }
    }

    public void setCurrentFocusedWindow(Window window) {
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow(window);
    }

    public Window getCurrentFocusedWindow() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
    }

    public void setCurrentFocusOwner(Component component) {
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(component);
    }

    public Component getCurrentFocusOwner() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner();
    }

    public void clearGlobalFocusOwner(Window window) {
        if (window != null) {
            XComponentPeer xComponentPeer;
            Component component = window.getFocusOwner();
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Clearing global focus owner " + component);
            }
            if (component != null && (xComponentPeer = XComponentPeer.getNativeContainer(component)) != null) {
                FocusEvent focusEvent = new FocusEvent(component, 1005);
                XWindow.sendEvent(focusEvent);
            }
        }
    }

    static boolean simulateMotifRequestFocus(Component component, Component component2, boolean bl, boolean bl2, long l) {
        Component component3;
        if (component == null) {
            component = component2;
        }
        if ((component3 = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && component3.getPeer() == null) {
            component3 = null;
        }
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Simulating transfer from " + component3 + " to " + component);
        }
        FocusEvent focusEvent = new FocusEvent(component, 1004, false, component3);
        FocusEvent focusEvent2 = null;
        if (component3 != null) {
            focusEvent2 = new FocusEvent(component3, 1005, false, component);
        }
        if (focusEvent2 != null) {
            XWindow.sendEvent(focusEvent2);
        }
        XWindow.sendEvent(focusEvent);
        return true;
    }

    static int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl, boolean bl2, long l) {
        int n;
        block6: {
            Object[] objectArray;
            if (shouldNativelyFocusHeavyweightMethod == null) {
                objectArray = new Class[]{Component.class, Component.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE};
                shouldNativelyFocusHeavyweightMethod = XToolkit.getMethod(KeyboardFocusManager.class, "shouldNativelyFocusHeavyweight", (Class[])objectArray);
            }
            objectArray = new Object[]{component, component2, bl, bl2, new Long(l)};
            n = 0;
            if (shouldNativelyFocusHeavyweightMethod != null) {
                try {
                    n = (Integer)shouldNativelyFocusHeavyweightMethod.invoke(null, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        return n;
    }

    private static class Lock {
        private Lock() {
        }
    }
}

