/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ColorData;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XIconSize;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11.awtImageData;

public class XIconWindow
extends XBaseWindow {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XIconWindow");
    XFramePeer parent;
    Dimension size;
    long iconPixmap;
    int iconWidth;
    int iconHeight;

    XIconWindow(XFramePeer xFramePeer) {
        super(new XCreateWindowParams(new Object[]{"parent", xFramePeer, "delayed", Boolean.TRUE}));
    }

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        this.parent = (XFramePeer)xCreateWindowParams.get("parent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XIconSize[] getIconSizes() {
        XToolkit.awtLock();
        try {
            long l;
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            long l2 = awtGraphicsConfigData.get_awt_visInfo().get_screen();
            long l3 = XToolkit.getDisplay();
            if (log.isLoggable(Level.FINEST)) {
                log.finest(awtGraphicsConfigData.toString());
            }
            if ((l = (long)XlibWrapper.XGetIconSizes(l3, XlibWrapper.RootWindow(l3, l2), XlibWrapper.larg1, XlibWrapper.iarg1)) == 0L) {
                XIconSize[] xIconSizeArray = null;
                return xIconSizeArray;
            }
            int n = Native.getInt(XlibWrapper.iarg1);
            long l4 = Native.getLong(XlibWrapper.larg1);
            log.log(Level.FINEST, "count = {1}, sizes_ptr = {0}", new Object[]{new Long(l4), new Integer(n)});
            XIconSize[] xIconSizeArray = new XIconSize[n];
            int n2 = 0;
            while (n2 < n) {
                xIconSizeArray[n2] = new XIconSize(l4);
                log.log(Level.FINEST, "sizes_ptr[{1}] = {0}", new Object[]{String.valueOf(xIconSizeArray[n2]), new Integer(n2)});
                ++n2;
                l4 += (long)XIconSize.getSize();
            }
            XIconSize[] xIconSizeArray2 = xIconSizeArray;
            return xIconSizeArray2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcIconSize(int n, int n2) {
        int n3;
        XIconSize[] xIconSizeArray = this.getIconSizes();
        if (xIconSizeArray == null) {
            return new Dimension(16, 16);
        }
        boolean bl = false;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < xIconSizeArray.length; ++n3) {
            int n8;
            if (n < xIconSizeArray[n3].get_min_width() || n > xIconSizeArray[n3].get_max_width() || n2 < xIconSizeArray[n3].get_min_height() || n2 > xIconSizeArray[n3].get_max_height()) continue;
            bl = true;
            if ((n - xIconSizeArray[n3].get_min_width()) % xIconSizeArray[n3].get_width_inc() == 0 && (n2 - xIconSizeArray[n3].get_min_height()) % xIconSizeArray[n3].get_height_inc() == 0) {
                n6 = n;
                n7 = n2;
                n4 = 0;
                break;
            }
            n5 = n - xIconSizeArray[n3].get_min_width();
            int n9 = n5 == 0 ? n : n - (n5 %= xIconSizeArray[n3].get_width_inc());
            int n10 = n9 * n9 + (n8 = (n5 = n2 - xIconSizeArray[n3].get_min_height()) == 0 ? n2 : n2 - (n5 %= xIconSizeArray[n3].get_height_inc())) * n8;
            if (n4 <= n10) continue;
            n6 = n9;
            n7 = n8;
            n4 = n10;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("found=" + bl);
        }
        if (!bl) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("widthHint=" + n + ", heightHint=" + n2 + ", saveWidth=" + n6 + ", saveHeight=" + n7 + ", max_width=" + xIconSizeArray[0].get_max_width() + ", max_height=" + xIconSizeArray[0].get_max_height() + ", min_width=" + xIconSizeArray[0].get_min_width() + ", min_height=" + xIconSizeArray[0].get_min_height());
            }
            if (n > xIconSizeArray[0].get_max_width() || n2 > xIconSizeArray[0].get_max_height()) {
                n3 = n - xIconSizeArray[0].get_max_width();
                int n11 = n2 - xIconSizeArray[0].get_max_height();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("wdiff=" + n3 + ", hdiff=" + n11);
                }
                if (n3 >= n11) {
                    n6 = xIconSizeArray[0].get_max_width();
                    n7 = (int)((double)xIconSizeArray[0].get_max_width() / (double)n * (double)n2);
                } else {
                    n6 = (int)((double)xIconSizeArray[0].get_max_height() / (double)n2 * (double)n);
                    n7 = xIconSizeArray[0].get_max_height();
                }
            } else if (n < xIconSizeArray[0].get_min_width() || n2 < xIconSizeArray[0].get_min_height()) {
                n6 = (xIconSizeArray[0].get_min_width() + xIconSizeArray[0].get_max_width()) / 2;
                n7 = (xIconSizeArray[0].get_min_height() + xIconSizeArray[0].get_max_height()) / 2;
            } else {
                n6 = n;
                n7 = n;
            }
        }
        Object object = XIconWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XFree(xIconSizeArray[0].pData);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("return " + n6 + "x" + n7);
        }
        return new Dimension(n6, n7);
    }

    Dimension getIconSize(int n, int n2) {
        if (this.size == null) {
            this.size = this.calcIconSize(n, n2);
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIconImage(int n, int n2, DataBuffer dataBuffer) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("iconsWidth = " + n + ", iconHeight = " + n2);
        }
        XToolkit.awtLock();
        try {
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            awtImageData awtImageData2 = awtGraphicsConfigData.get_awtImage(0);
            XVisualInfo xVisualInfo = awtGraphicsConfigData.get_awt_visInfo();
            if (this.iconPixmap != 0L && (this.iconWidth != n || this.iconHeight != n2)) {
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                this.iconPixmap = 0L;
                log.finest("Freed previous pixmap");
            }
            if (this.iconPixmap == 0L) {
                this.iconPixmap = XlibWrapper.XCreatePixmap(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xVisualInfo.get_screen()), n, n2, awtImageData2.get_Depth());
                if (this.iconPixmap == 0L) {
                    log.finest("Can't create new pixmap for icon");
                    return;
                }
                log.finest("New pixmap for icon created");
                this.iconWidth = n;
                this.iconHeight = n2;
            }
            long l = 0L;
            try {
                int n3;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    if (dataBuffer instanceof DataBufferInt) {
                        l = Native.toData(((DataBufferInt)dataBuffer).getData());
                    } else {
                        if (!(dataBuffer instanceof DataBufferUShort)) throw new IllegalArgumentException("Unknown data buffer: " + dataBuffer);
                        l = Native.toData(((DataBufferUShort)dataBuffer).getData());
                    }
                } else {
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    ColorData colorData = awtGraphicsConfigData.get_color_data(0);
                    n3 = colorData.get_awt_numICMcolors();
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = byArray[i] >= n3 ? (byte)0 : colorData.get_awt_icmLUT2Colors(byArray[i]);
                    }
                    l = Native.toData(byArray);
                }
                int n4 = awtImageData2.get_wsImageFormat().get_bits_per_pixel();
                int n5 = awtImageData2.get_wsImageFormat().get_scanline_pad();
                n3 = XlibWrapper.paddedwidth(n * n4, n5) >> 3;
                if ((n3 << 3) / n4 < n) {
                    log.finest("Image format doesn't fit to icon width");
                    return;
                }
                long l2 = XlibWrapper.XCreateImage(XToolkit.getDisplay(), xVisualInfo.get_visual(), awtImageData2.get_Depth(), 2, 0, l, n, n2, 32, n3);
                if (l2 == 0L) {
                    log.finest("Can't create XImage for icon");
                    return;
                }
                log.finest("Created XImage for icon");
                try {
                    long l3 = XlibWrapper.XCreateGC(XToolkit.getDisplay(), this.iconPixmap, 0L, 0L);
                    if (l3 == 0L) {
                        log.finest("Can't create GC for pixmap");
                        return;
                    }
                    log.finest("Created GC for pixmap");
                    try {
                        XlibWrapper.XPutImage(XToolkit.getDisplay(), this.iconPixmap, l3, l2, 0, 0, 0, 0, n, n2);
                    }
                    finally {
                        XlibWrapper.XFreeGC(XToolkit.getDisplay(), l3);
                    }
                }
                finally {
                    XlibWrapper.XDestroyImage(l2);
                }
            }
            finally {
                XlibWrapper.unsafe.freeMemory(l);
            }
            XWMHints xWMHints = this.parent.getWMHints();
            this.window = xWMHints.get_icon_window();
            if (this.window == 0L) {
                log.finest("Icon window wasn't set");
                XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
                xCreateWindowParams.add((Object)"border pixel", new Long(XToolkit.getAwtDefaultFg()));
                xCreateWindowParams.add((Object)"pixmap", this.iconPixmap);
                xCreateWindowParams.add((Object)"color map", awtGraphicsConfigData.get_awt_cmap());
                xCreateWindowParams.add((Object)"visual depth", awtImageData2.get_Depth());
                xCreateWindowParams.add((Object)"visual class", 1);
                xCreateWindowParams.add((Object)"visual", xVisualInfo.get_visual());
                xCreateWindowParams.add((Object)"value mask", 8201L);
                xCreateWindowParams.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), xVisualInfo.get_screen()));
                xCreateWindowParams.add((Object)"bounds", new Rectangle(0, 0, n, n2));
                xCreateWindowParams.remove("delayed");
                this.init(xCreateWindowParams);
                if (this.getWindow() == 0L) {
                    log.finest("Can't create new icon window");
                    xWMHints.set_flags(xWMHints.get_flags() | 4L);
                    xWMHints.set_icon_pixmap(this.iconPixmap);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), xWMHints.pData);
                    return;
                }
                log.finest("Created new icon window");
            }
            xWMHints.set_flags(xWMHints.get_flags() | 8L | 4L);
            xWMHints.set_icon_pixmap(this.iconPixmap);
            xWMHints.set_icon_window(this.window);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), xWMHints.pData);
            log.finest("Set icon window hint");
            XlibWrapper.XSetWindowBackgroundPixmap(XToolkit.getDisplay(), this.getWindow(), this.iconPixmap);
            XlibWrapper.XClearWindow(XToolkit.getDisplay(), this.getWindow());
            return;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }
}

