/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XContentWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

abstract class XDecoratedPeer
extends XWindowPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XDecoratedPeer");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XDecoratedPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XDecoratedPeer");
    private static XAtom resize_request = new XAtom("_SUN_AWT_RESIZE_REQUEST", false);
    boolean configure_seen;
    WindowDimensions dimensions;
    XContentWindow content;
    Insets currentInsets;
    long reparent_serial = 0L;
    private XWindowPeer actualFocusedWindow = null;

    XDecoratedPeer(Window window) {
        super(window);
    }

    XDecoratedPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    public long getShell() {
        return this.window;
    }

    public long getContentWindow() {
        return this.content == null ? this.window : this.content.getWindow();
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        if (!resize_request.isInterned()) {
            resize_request.intern(false);
        }
        this.winAttr.initialFocus = true;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.changeInsets();
        Rectangle rectangle = (Rectangle)xCreateWindowParams.get("bounds");
        this.dimensions = new WindowDimensions(rectangle, this.getRealInsets(), false);
        xCreateWindowParams.put("bounds", this.dimensions.getClientRect());
        insLog.log(Level.FINE, "Initial dimensions {0}", new Object[]{String.valueOf(this.dimensions)});
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.initResizability();
        this.updateSizeHints(this.dimensions);
        this.content = this.createContent(this.dimensions);
        this.content.initialize();
        if (this.warningWindow != null) {
            this.warningWindow.toFront();
        }
    }

    XContentWindow createContent(WindowDimensions windowDimensions) {
        Rectangle rectangle = windowDimensions.getBounds();
        Insets insets = windowDimensions.getInsets();
        if (insets != null) {
            rectangle.x = -insets.left;
            rectangle.y = -insets.top;
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        return new XContentWindow(this, rectangle);
    }

    protected XAtomList getWMProtocols() {
        XAtomList xAtomList = super.getWMProtocols();
        xAtomList.add(wm_delete_window);
        xAtomList.add(wm_take_focus);
        return xAtomList;
    }

    public Graphics getGraphics() {
        return this.getGraphics(this.content.surfaceData, this.target.getForeground(), this.target.getBackground(), this.target.getFont());
    }

    public void setTitle(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Title is " + string);
        }
        this.setWMName(string);
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleFocusEvent(long l) {
        super.handleFocusEvent(l);
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent(l);
        if (xFocusChangeEvent.get_type() == 10 && xFocusChangeEvent.get_mode() == 1) {
            log.finer("Generating MOVED event due to a user grab on toplevel");
            this.postEvent(new ComponentEvent(this.target, 100));
        }
    }

    protected boolean isInitialReshape() {
        return false;
    }

    Insets difference(Insets insets, Insets insets2) {
        return new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
    }

    void add(Insets insets, Insets insets2) {
        insets.left += insets2.left;
        insets.top += insets2.top;
        insets.right += insets2.right;
        insets.bottom += insets2.bottom;
    }

    boolean isNull(Insets insets) {
        return (insets.left | insets.top | insets.right | insets.bottom) == 0;
    }

    Insets copy(Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReparentNotifyEvent(long l) {
        XReparentEvent xReparentEvent = new XReparentEvent(l);
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine(xReparentEvent.toString());
        }
        this.reparent_serial = xReparentEvent.get_serial();
        XToolkit.awtLock();
        try {
            long l2 = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            if (this.isEmbedded()) {
                this.reparented = true;
                return;
            }
            Component component = this.target;
            if (this.getDecorations() == XWindowAttributesData.AWT_DECOR_NONE) {
                this.reparented = true;
                this.reshape(this.dimensions, 2, false);
            } else if (xReparentEvent.get_parent() == l2) {
                this.configure_seen = false;
                if (this.isVisible()) {
                    XWM.getWM().unshadeKludge(this);
                }
            } else {
                this.reparented = true;
                Insets insets = XWM.getWM().getInsets(this, xReparentEvent);
                insLog.log(Level.FINER, "correctWM {0}", new Object[]{String.valueOf(insets)});
                Insets insets2 = this.difference(insets, this.currentInsets);
                insLog.log(Level.FINEST, "Corrention {0}", new Object[]{String.valueOf(insets2)});
                if (!this.isNull(insets2)) {
                    this.add(this.currentInsets, insets2);
                    this.changeInsets();
                }
                if (insLog.isLoggable(Level.FINER)) {
                    insLog.finer("Dimensions before reparent: " + this.dimensions);
                }
                this.dimensions.setInsets(this.getRealInsets());
                if (this.isMaximized()) {
                    return;
                }
                if ((this.getHints().get_flags() & 5L) != 0L) {
                    this.reshape(this.dimensions, 3, false);
                } else {
                    this.reshape(this.dimensions, 2, false);
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void handleMoved(WindowDimensions windowDimensions) {
        Point point = windowDimensions.getLocation();
        ComponentAccessor.setX(this.target, point.x);
        ComponentAccessor.setY(this.target, point.y);
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    protected Insets guessInsets() {
        if (this.isEmbedded()) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.currentInsets.top > 0) {
            return this.copy(this.currentInsets);
        }
        return XWM.getWM().guessInsets(this);
    }

    void changeInsets() {
        Insets insets = this.guessInsets();
        this.currentInsets = this.copy(insets);
        this.insets = this.copy(this.currentInsets);
    }

    public void revalidate() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                XDecoratedPeer.this.target.invalidate();
                XDecoratedPeer.this.target.validate();
            }
        });
    }

    Insets getRealInsets() {
        if (this.isNull(this.insets)) {
            this.changeInsets();
        }
        return this.insets;
    }

    public Insets getInsets() {
        Insets insets = this.copy(this.getRealInsets());
        insets.top += this.getMenuBarHeight() + this.getWarningWindowHeight();
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.log(Level.FINEST, "Get insets returns {0}", new Object[]{String.valueOf(insets)});
        }
        return insets;
    }

    boolean gravityBug() {
        return XWM.configureGravityBuggy();
    }

    int getInputMethodHeight() {
        return 0;
    }

    void updateSizeHints(WindowDimensions windowDimensions) {
        Rectangle rectangle = windowDimensions.getClientRect();
        this.checkShellRect(rectangle);
        this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void updateSizeHints() {
        this.updateSizeHints(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(WindowDimensions windowDimensions, int n, boolean bl) {
        Insets insets;
        Rectangle rectangle;
        Rectangle rectangle2;
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Reshaping " + this + " to " + windowDimensions);
        }
        if (bl) {
            rectangle2 = windowDimensions.getBounds();
            rectangle = this.constrainBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (!rectangle.equals(rectangle2)) {
                if (windowDimensions.isClientSizeSet()) {
                    insets = windowDimensions.getInsets();
                    windowDimensions = new WindowDimensions(new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom)), windowDimensions.getInsets(), true);
                } else {
                    windowDimensions = new WindowDimensions(rectangle, windowDimensions.getInsets(), false);
                }
            }
        }
        XToolkit.awtLock();
        try {
            if (!this.reparented || !this.isVisible()) {
                insLog.log(Level.FINE, "- not reparented({0}) or not visible({1}), default reshape", new Object[]{this.reparented, this.visible});
                this.dimensions = new WindowDimensions(windowDimensions);
                this.updateSizeHints(this.dimensions);
                rectangle2 = this.dimensions.getClientRect();
                this.checkShellRect(rectangle2);
                this.setShellBounds(rectangle2);
                if (this.content != null && !this.content.getSize().equals(windowDimensions.getSize())) {
                    this.reconfigureContentWindow(windowDimensions);
                }
                return;
            }
            int n2 = XWM.getWMID();
            this.updateChildrenSizes();
            this.changeInsets();
            rectangle = windowDimensions.getClientRect();
            if (this.gravityBug()) {
                insets = windowDimensions.getInsets();
                rectangle.translate(insets.left, insets.top);
            }
            if ((n & 0x4000) == 0 && this.isEmbedded()) {
                rectangle.setLocation(0, 0);
            }
            this.checkShellRect(rectangle);
            if (n == 1) {
                this.setShellPosition(rectangle);
            } else if (this.isResizable()) {
                if (n == 3) {
                    this.setShellBounds(rectangle);
                } else {
                    this.setShellSize(rectangle);
                }
            } else {
                XWM.setShellNotResizable(this, windowDimensions, rectangle, true);
                if (n == 3) {
                    this.setShellPosition(rectangle);
                }
            }
            this.reconfigureContentWindow(windowDimensions);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void reshape(int n, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = false;
        WindowDimensions windowDimensions = new WindowDimensions(this.dimensions);
        switch (n5 & 0xFFFFBFFF) {
            case 1: {
                windowDimensions.setLocation(n, n2);
                break;
            }
            case 2: {
                windowDimensions.setSize(n3, n4);
                break;
            }
            case 4: {
                Insets insets = this.currentInsets;
                windowDimensions.setClientSize(n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom);
                break;
            }
            default: {
                windowDimensions.setLocation(n, n2);
                windowDimensions.setSize(n3, n4);
            }
        }
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "For the operation {0} new dimensions are {1}", new Object[]{XDecoratedPeer.operationToString(n5), String.valueOf(windowDimensions)});
        }
        this.reshape(windowDimensions, n5, bl);
    }

    abstract boolean isTargetUndecorated();

    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n, n2, n3, n4);
        }
        if (!this.isVisible() || this.isTargetUndecorated()) {
            return super.constrainBounds(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle2 = this.getBounds();
        int n9 = Math.max(rectangle.width - insets.left - insets.right, rectangle2.width);
        int n10 = Math.max(rectangle.height - insets.top - insets.bottom, rectangle2.height);
        if (n7 > n9) {
            n7 = n9;
        }
        if (n8 > n10) {
            n8 = n10;
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.reshape(n, n2, n3, n4, n5, true);
        this.validateSurface();
    }

    void reconfigureContentWindow(WindowDimensions windowDimensions) {
        if (this.content == null) {
            insLog.fine("WARNING: Content window is null");
            return;
        }
        this.content.setContentBounds(windowDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfigureNotifyEvent(long l) {
        XConfigureEvent xConfigureEvent = new XConfigureEvent(l);
        insLog.log(Level.FINE, "Configure notify {0}", new Object[]{String.valueOf(xConfigureEvent)});
        if (this.reparented) {
            this.configure_seen = true;
        }
        if (!(this.isMaximized() || xConfigureEvent.get_serial() != this.reparent_serial && xConfigureEvent.get_window() == this.getShell())) {
            insLog.fine("- reparent artifact, skipping");
            return;
        }
        if (!this.isVisible() && XWM.getWMID() != 2) {
            insLog.fine(" - not visible, skipping");
            return;
        }
        XToolkit.awtLock();
        try {
            int n = XWM.getWMID();
            if (!this.reparented && this.isVisible() && n != 2) {
                if (this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
                    insLog.fine("- visible but not reparented, skipping");
                    return;
                }
            }
            this.updateChildrenSizes();
            Rectangle rectangle = new Rectangle(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target), ComponentAccessor.getWidth(this.target), ComponentAccessor.getHeight(this.target));
            WindowDimensions windowDimensions = new WindowDimensions(rectangle, this.copy(this.currentInsets), false);
            WindowDimensions windowDimensions2 = new WindowDimensions(new Point(xConfigureEvent.get_send_event() ? xConfigureEvent.get_x() - this.currentInsets.left : ComponentAccessor.getX(this.target), xConfigureEvent.get_send_event() ? xConfigureEvent.get_y() - this.currentInsets.top : ComponentAccessor.getY(this.target)), new Dimension(xConfigureEvent.get_width(), xConfigureEvent.get_height()), this.copy(this.currentInsets), true);
            insLog.log(Level.FINER, "Insets are {0}, new dimensions {1}", new Object[]{String.valueOf(this.currentInsets), String.valueOf(windowDimensions2)});
            this.checkIfOnNewScreen(windowDimensions2.getBounds());
            this.dimensions = windowDimensions2;
            if (!windowDimensions2.equals(windowDimensions) && !windowDimensions2.getLocation().equals(windowDimensions.getLocation())) {
                this.handleMoved(windowDimensions2);
            }
            this.reconfigureContentWindow(windowDimensions2);
            this.updateChildrenSizes();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void checkShellRect(Rectangle rectangle) {
        int n;
        if (rectangle.width < 0) {
            rectangle.width = 1;
        }
        if (rectangle.height < 0) {
            rectangle.height = 1;
        }
        if (((n = XWM.getWMID()) == 5 || n == 6) && rectangle.x == 0 && rectangle.y == 0) {
            rectangle.y = 1;
            rectangle.x = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellBounds(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell bounds on " + this + " to " + rectangle);
        }
        try {
            XToolkit.awtLock();
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellSize(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell size on " + this + " to " + rectangle);
        }
        try {
            XToolkit.awtLock();
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellPosition(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell position on " + this + " to " + rectangle);
        }
        try {
            XToolkit.awtLock();
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void initResizability() {
        this.setResizable(this.winAttr.initialResizability);
    }

    public void setResizable(boolean bl) {
        if (!this.isResizable() && bl) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.target.invalidate();
            if (!this.isEmbedded()) {
                this.reparented = false;
            }
            this.winAttr.isResizable = bl;
            XWM.setShellResizable(this);
        } else if (this.isResizable() && !bl) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.target.invalidate();
            if (!this.isEmbedded()) {
                this.reparented = false;
            }
            this.winAttr.isResizable = bl;
            XWM.setShellNotResizable(this, this.dimensions, this.dimensions.getBounds(), false);
        }
    }

    Rectangle getShellBounds() {
        return this.dimensions.getClientRect();
    }

    public Rectangle getBounds() {
        return this.dimensions.getBounds();
    }

    public Dimension getSize() {
        return this.dimensions.getSize();
    }

    public WindowDimensions getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = XDecoratedPeer.getAWTLock();
        synchronized (object) {
            if (this.configure_seen) {
                return this.toGlobal(0, 0);
            }
            Point point = this.target.getLocation();
            if (insLog.isLoggable(Level.FINE)) {
                insLog.fine("getLocationOnScreen " + this + " not reparented: " + point);
            }
            return point;
        }
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        switch (iXAnyEvent.get_type()) {
            case 22: {
                return true;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isEventDisabled(iXAnyEvent);
    }

    int getDecorations() {
        return this.winAttr.decorations;
    }

    public void setVisible(boolean bl) {
        log.log(Level.FINER, "Setting to visible {0}", new Object[]{bl});
        if (bl && !this.isVisible()) {
            XWM.setShellDecor(this);
            super.setVisible(bl);
            if (this.winAttr.isResizable) {
                XWM.removeSizeHints(this, 48L);
            }
        } else {
            super.setVisible(bl);
        }
    }

    public void dispose() {
        if (this.content != null) {
            this.content.destroy();
        }
        super.dispose();
    }

    public void handleClientMessage(long l) {
        super.handleClientMessage(l);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (wm_protocols != null && xClientMessageEvent.get_message_type() == wm_protocols.getAtom()) {
            if (xClientMessageEvent.get_data(0) == wm_delete_window.getAtom()) {
                this.handleQuit();
            } else if (xClientMessageEvent.get_data(0) == wm_take_focus.getAtom()) {
                focusLog.log(Level.FINE, "WM_TAKE_FOCUS on {0}", new Object[]{String.valueOf(this)});
                if (this.focusAllowedFor()) {
                    focusLog.fine("WM_TAKE_FOCUS accepted focus");
                    this.xRequestFocus(xClientMessageEvent.get_data(1));
                }
            }
        } else if (xClientMessageEvent.get_message_type() == resize_request.getAtom()) {
            this.reshape((int)xClientMessageEvent.get_data(0), (int)xClientMessageEvent.get_data(1), (int)xClientMessageEvent.get_data(2), (int)xClientMessageEvent.get_data(3), (int)xClientMessageEvent.get_data(4), true);
        }
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    final void dumpMe() {
        System.err.println(">>> Peer: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
    }

    final void dumpTarget() {
        int n = ComponentAccessor.getWidth(this.target);
        int n2 = ComponentAccessor.getHeight(this.target);
        int n3 = ComponentAccessor.getX(this.target);
        int n4 = ComponentAccessor.getY(this.target);
        System.err.println(">>> Target: " + n3 + ", " + n4 + ", " + n + ", " + n2);
    }

    final void dumpShell() {
        this.dumpWindow("Shell", this.getShell());
    }

    final void dumpContent() {
        this.dumpWindow("Content", this.getContentWindow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpParent() {
        XQueryTree xQueryTree = new XQueryTree(this.getShell());
        try {
            xQueryTree.execute();
            if (xQueryTree.get_parent() != 0L) {
                this.dumpWindow("Parent", xQueryTree.get_parent());
            } else {
                System.err.println(">>> NO PARENT");
            }
        }
        finally {
            xQueryTree.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpWindow(String string, long l) {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.awtLock();
            int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        System.err.println(">>>> " + string + ": " + xWindowAttributes.get_x() + ", " + xWindowAttributes.get_y() + ", " + xWindowAttributes.get_width() + ", " + xWindowAttributes.get_height());
        xWindowAttributes.dispose();
    }

    final void dumpAll() {
        this.dumpTarget();
        this.dumpMe();
        this.dumpParent();
        this.dumpShell();
        this.dumpContent();
    }

    boolean isMaximized() {
        return false;
    }

    boolean isOverrideRedirect() {
        return false;
    }

    public boolean requestWindowFocus() {
        focusLog.fine("Request for decorated window focus");
        Window window = (Window)this.target;
        focusLog.log(Level.FINER, "Current window is: focused={0}, active={1}", new Object[]{window.isActive(), window.isFocused()});
        if (this.focusAllowedFor()) {
            if (window.isActive() && !window.isFocused()) {
                focusLog.fine("Focus is on child window - transfering it back");
                this.handleWindowFocusInSync(-1L);
            } else {
                focusLog.fine("Requesting focus to this top-level");
                ((XWindowPeer)this.target.getPeer()).xRequestFocus();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean requestWindowFocus(XWindowPeer xWindowPeer) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.actualFocusedWindow = xWindowPeer;
        }
        return this.requestWindowFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWindowFocusIn(long l) {
        super.handleWindowFocusIn(l);
        XWindowPeer xWindowPeer = null;
        Object object = this.getStateLock();
        synchronized (object) {
            xWindowPeer = this.actualFocusedWindow;
            this.actualFocusedWindow = null;
        }
        if (xWindowPeer != null && xWindowPeer.isVisible()) {
            xWindowPeer.handleWindowFocusIn(l);
        }
    }

    public void handleWindowFocusOut(Window window, long l) {
        Window window2 = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        if (window2 != null && window2 != this.target) {
            Window window3 = window2.getOwner();
            while (window3 != null && !(window3 instanceof Frame) && !(window3 instanceof Dialog)) {
                window3 = window2.getOwner();
            }
            if (window3 != null && window3 == this.target) {
                this.actualFocusedWindow = (XWindowPeer)window2.getPeer();
            }
        }
        super.handleWindowFocusOut(window, l);
    }
}

