/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.font.NativeFontWrapper;
import sun.io.CharacterEncoding;

public abstract class FontProperties
extends Properties {
    protected static String osVersion;
    protected static String osName;
    private static boolean usesPlatformFont;
    private static final String[] fontNames;

    public FontProperties() {
        super(FontProperties.getDefaultFontProperties());
        this.setOsNameAndVersion();
        this.initializeProperties();
    }

    private void initializeProperties() {
        Object object;
        try {
            usesPlatformFont = NativeFontWrapper.usePlatformFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        Locale locale = SunToolkit.getStartupLocale();
        String string3 = locale.getLanguage();
        String string4 = locale.getCountry();
        string3 = string3.toLowerCase();
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName((String)string5);
        if (string6 == null) {
            string6 = string5;
        }
        if (osVersion == null) {
            osVersion = System.getProperty("os.version");
        }
        String string7 = usesPlatformFont ? "native" + File.separator : "";
        String string8 = string2 + File.separator + "lib" + File.separator + string7 + "fprop.dir";
        File file = new File(string8);
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                object = new BufferedInputStream(LocalizedInputStream.localize((InputStream)new FileInputStream(file.getPath())));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = null;
        if (osVersion.lastIndexOf(".") != -1) {
            object = osVersion.substring(0, osVersion.lastIndexOf("."));
        }
        try {
            File file2 = null;
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, string6, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, string6, osName, (String)object);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, string6, null, null);
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, null, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, null, osName, (String)object);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, string6, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, string6, osName, (String)object);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, string4, null, null, null);
            if ("zh".equals(string3) && ("TW".equals(string4) || "MO".equals(string4))) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, string3, "TW", null, null, null);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, null, string4, null, null, null);
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, string6, null, null);
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, null, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, null, osName, (String)object);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, string6, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, string6, osName, (String)object);
            }
            file2 = this.tryOpeningFontProp(file2, properties, string2, string3, null, null, null, null);
            file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, string6, null, null);
            file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, null, osName, osVersion);
            if (object != null) {
                file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, null, osName, (String)object);
            }
            if ((file2 = this.tryOpeningFontProp(file2, properties, string2, null, null, null, null, null)) != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize((InputStream)new FileInputStream(file2.getPath())));
                this.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                if (("ja".equals(string3) || "zh".equals(string3) || "ko".equals(string3) || "iw".equals(string3) || "th".equals(string3) || "hi".equals(string3)) && this.isOriginalFP(file2)) {
                    this.put("_PLSF_LANGUAGE", string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File tryOpeningFontProp(File file, Properties properties, String string, String string2, String string3, String string4, String string5, String string6) {
        if (file != null) {
            return file;
        }
        String string7 = usesPlatformFont ? "native" + File.separator : "";
        String string8 = "font.properties";
        String string9 = null;
        string9 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.jvm.fontproperties.dir");
            }
        });
        String string10 = string9 != null ? string9 + File.separator : string + File.separator + "lib" + File.separator + string7;
        string8 = this.getPropsFilename(string8, string2, string3, string4, string5, string6);
        if (properties != null) {
            string8 = properties.getProperty(string8);
        }
        if (string8 != null && (file = new File(string10 + string8)).canRead()) {
            return file;
        }
        return null;
    }

    private static Properties getDefaultFontProperties() {
        Properties properties = new Properties();
        properties.put("serif.0", "unknown");
        properties.put("sansserif.0", "unknown");
        properties.put("monospaced.0", "unknown");
        properties.put("dialog.0", "unknown");
        properties.put("dialoginput.0", "unknown");
        properties.put("default.0", "sansserif");
        properties.put("timesroman.0", "serif");
        properties.put("helvetica.0", "sansserif");
        properties.put("courier.0", "monospaced");
        properties.put("zapfdingbats.0", "unknown");
        return properties;
    }

    private String getPropsFilename(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string == null) {
            return null;
        }
        String string7 = null;
        String string8 = null;
        if (string2 != null) {
            string7 = "." + string2;
        }
        if (string3 != null) {
            string7 = string7 != null ? string7 + "_" + string3 : "." + string3;
        }
        if (string4 != null) {
            string7 = string7 != null ? string7 + "_" + string4 : "." + string4;
        }
        if (string5 != null) {
            string8 = "." + string5;
        }
        if (string6 != null) {
            string8 = string8 != null ? string8 + string6 : "." + string6;
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string8 == null) {
            string8 = "";
        }
        return string + string7 + string8;
    }

    protected void setOsNameAndVersion() {
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
    }

    public static boolean isLogicalFontFamilyName(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < fontNames.length; ++i) {
            if (!string.equals(fontNames[i])) continue;
            return true;
        }
        return false;
    }

    public String getAliasedFamilyName(String string) {
        assert (!FontProperties.isLogicalFontFamilyName(string));
        string = string.toLowerCase(Locale.ENGLISH);
        String string2 = this.getProperty("alias." + string);
        if (string2 != null) {
            for (int i = 0; i < fontNames.length; ++i) {
                if (!string2.equals(fontNames[i])) continue;
                return string2;
            }
        }
        return null;
    }

    public abstract String getFallbackFamilyName(String var1, String var2);

    protected String getCompatibilityFamilyName(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("timesroman")) {
            return "serif";
        }
        if (string.equals("helvetica")) {
            return "sansserif";
        }
        if (string.equals("courier")) {
            return "monospaced";
        }
        return null;
    }

    protected boolean isOriginalFP(File file) {
        return false;
    }

    public boolean supportPLSF() {
        return false;
    }

    public FontProperties applyPreferLocaleSpecificFonts(FontProperties fontProperties) {
        return this;
    }

    static {
        usesPlatformFont = false;
        fontNames = new String[]{"serif", "sansserif", "monospaced", "dialog", "dialoginput"};
    }
}

