/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.math.BigInteger;
import java.util.Arrays;
import sun.awt.image.BufImgSurfaceData;

public class IndexColorModel
extends ColorModel {
    private int[] rgb;
    private int map_size;
    private int transparent_index = -1;
    private boolean allgrayopaque;
    private BigInteger validBits;
    private static int[] opaqueBits = new int[]{8, 8, 8};
    private static int[] alphaBits = new int[]{8, 8, 8, 8};
    private static final int CACHESIZE = 40;
    private int[] lookupcache = new int[40];
    int[] lastRGB = new int[]{0, 0};
    int[] lastPix = new int[]{0, 0};
    IndexColorModel[] lastCM = new IndexColorModel[]{null, null};
    int lastSet = 0;
    int Element2 = 1;

    private static native void initIDs();

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
        this.setTransparentPixel(n3);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, alphaBits, ColorSpace.getInstance(1000), true, false, 3, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, byArray4);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[this.calcRealMapSize(n, n2)];
        int n5 = n3;
        int n6 = 255;
        boolean bl2 = true;
        int n7 = 1;
        for (int i = 0; i < n2; ++i) {
            int n8 = byArray[n5++] & 0xFF;
            int n9 = byArray[n5++] & 0xFF;
            int n10 = byArray[n5++] & 0xFF;
            boolean bl3 = bl2 = bl2 && n8 == n9 && n9 == n10;
            if (bl && (n6 = byArray[n5++] & 0xFF) != 255) {
                if (n6 == 0) {
                    if (n7 == 1) {
                        n7 = 2;
                    }
                    if (this.transparent_index < 0) {
                        this.transparent_index = i;
                    }
                } else {
                    n7 = 3;
                }
                bl2 = false;
            }
            this.rgb[i] = n6 << 24 | n8 << 16 | n9 << 8 | n10;
        }
        this.allgrayopaque = bl2;
        this.setTransparency(n7);
        this.setTransparentPixel(n4);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, n5);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        this.setRGBs(n2, nArray, n3, bl);
        this.setTransparentPixel(n4);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, int n4, BigInteger bigInteger) {
        super(n, alphaBits, ColorSpace.getInstance(1000), true, false, 3, n4);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        if (bigInteger != null) {
            for (int i = 0; i < n2; ++i) {
                if (bigInteger.testBit(i)) continue;
                this.validBits = bigInteger;
                break;
            }
        }
        this.setRGBs(n2, nArray, n3, true);
    }

    private void setRGBs(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n < 1) {
            throw new IllegalArgumentException("Map size (" + n + ") must be >= 1");
        }
        this.map_size = n;
        this.rgb = new int[this.calcRealMapSize(this.pixel_bits, n)];
        int n2 = 255;
        int n3 = 1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = byArray2[i] & 0xFF;
            int n6 = byArray3[i] & 0xFF;
            boolean bl2 = bl = bl && n4 == n5 && n5 == n6;
            if (byArray4 != null && (n2 = byArray4[i] & 0xFF) != 255) {
                if (n2 == 0) {
                    if (n3 == 1) {
                        n3 = 2;
                    }
                    if (this.transparent_index < 0) {
                        this.transparent_index = i;
                    }
                } else {
                    n3 = 3;
                }
                bl = false;
            }
            this.rgb[i] = n2 << 24 | n4 << 16 | n5 << 8 | n6;
        }
        this.allgrayopaque = bl;
        this.setTransparency(n3);
    }

    private void setRGBs(int n, int[] nArray, int n2, boolean bl) {
        this.map_size = n;
        this.rgb = new int[this.calcRealMapSize(this.pixel_bits, n)];
        int n3 = n2;
        int n4 = 1;
        boolean bl2 = true;
        BigInteger bigInteger = this.validBits;
        int n5 = 0;
        while (n5 < n) {
            if (bigInteger == null || bigInteger.testBit(n5)) {
                int n6 = nArray[n3];
                int n7 = n6 >> 16 & 0xFF;
                int n8 = n6 >> 8 & 0xFF;
                int n9 = n6 & 0xFF;
                boolean bl3 = bl2 = bl2 && n7 == n8 && n8 == n9;
                if (bl) {
                    int n10 = n6 >>> 24;
                    if (n10 != 255) {
                        if (n10 == 0) {
                            if (n4 == 1) {
                                n4 = 2;
                            }
                            if (this.transparent_index < 0) {
                                this.transparent_index = n5;
                            }
                        } else {
                            n4 = 3;
                        }
                        bl2 = false;
                    }
                } else {
                    n6 |= 0xFF000000;
                }
                this.rgb[n5] = n6;
            }
            ++n5;
            ++n3;
        }
        this.allgrayopaque = bl2;
        this.setTransparency(n4);
    }

    private int calcRealMapSize(int n, int n2) {
        int n3 = Math.max(1 << n, n2);
        return Math.max(n3, 256);
    }

    private BigInteger getAllValid() {
        int n = (this.map_size + 7) / 8;
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)-1);
        byArray[0] = (byte)(255 >>> n * 8 - this.map_size);
        return new BigInteger(1, byArray);
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int[] getComponentSize() {
        if (this.nBits == null) {
            if (this.supportsAlpha) {
                this.nBits = new int[4];
                this.nBits[3] = 8;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        return this.nBits;
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.transparent_index;
    }

    public final void getReds(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(this.rgb[i] >> 16);
        }
    }

    public final void getGreens(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(this.rgb[i] >> 8);
        }
    }

    public final void getBlues(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)this.rgb[i];
        }
    }

    public final void getAlphas(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(this.rgb[i] >> 24);
        }
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    private void setTransparentPixel(int n) {
        if (n >= 0 && n < this.map_size) {
            int n2 = n;
            this.rgb[n2] = this.rgb[n2] & 0xFFFFFF;
            this.transparent_index = n;
            this.allgrayopaque = false;
            if (this.transparency == 1) {
                this.setTransparency(2);
            }
        }
    }

    private void setTransparency(int n) {
        if (this.transparency != n) {
            this.transparency = n;
            if (n == 1) {
                this.supportsAlpha = false;
                this.numComponents = 3;
                this.nBits = opaqueBits;
            } else {
                this.supportsAlpha = true;
                this.numComponents = 4;
                this.nBits = alphaBits;
            }
        }
    }

    public final int getRed(int n) {
        return this.rgb[n] >> 16 & 0xFF;
    }

    public final int getGreen(int n) {
        return this.rgb[n] >> 8 & 0xFF;
    }

    public final int getBlue(int n) {
        return this.rgb[n] & 0xFF;
    }

    public final int getAlpha(int n) {
        return this.rgb[n] >> 24 & 0xFF;
    }

    public final int getRGB(int n) {
        return this.rgb[n];
    }

    public synchronized Object getDataElements(int n, Object object) {
        int n2 = 0;
        if (this.equals(this.lastCM[this.lastSet]) && this.lastRGB[this.lastSet] == n) {
            n2 = this.lastPix[this.lastSet];
        } else if (this.equals(this.lastCM[this.Element2]) && this.lastRGB[this.Element2] == n) {
            n2 = this.lastPix[this.Element2];
            int n3 = this.lastSet;
            this.lastSet = this.Element2;
            this.Element2 = n3;
        } else {
            int n4;
            int n5 = n >> 16 & 0xFF;
            int n6 = n >> 8 & 0xFF;
            int n7 = n & 0xFF;
            int n8 = n >>> 24;
            for (n4 = 38; n4 >= 0 && (n2 = this.lookupcache[n4]) != 0; n4 -= 2) {
                if (n != this.lookupcache[n4 + 1]) continue;
                return this.installpixel(object, ~n2);
            }
            if (this.allgrayopaque) {
                n4 = 256;
                int n9 = (n5 * 77 + n6 * 150 + n7 * 29 + 128) / 256;
                for (int i = 0; i < this.map_size; ++i) {
                    if (this.rgb[i] == 0) continue;
                    int n10 = (this.rgb[i] & 0xFF) - n9;
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if (n10 >= n4) continue;
                    n2 = i;
                    if (n10 != 0) {
                        n4 = n10;
                        continue;
                    }
                    break;
                }
            } else if (n8 == 0) {
                if (this.transparent_index >= 0) {
                    n2 = this.transparent_index;
                } else {
                    n4 = 256;
                    for (int i = 0; i < this.map_size; ++i) {
                        int n11 = this.rgb[i] >>> 24;
                        if (n4 <= n8 || this.validBits != null && !this.validBits.testBit(i)) continue;
                        n4 = n8;
                        n2 = i;
                    }
                }
            } else {
                n4 = 16581375;
                int n12 = 255;
                for (int i = 0; i < this.map_size; ++i) {
                    int n13 = this.rgb[i];
                    if (n13 == n) {
                        n2 = i;
                        break;
                    }
                    int n14 = (n13 >>> 24) - n8;
                    if (n14 < 0) {
                        n14 = -n14;
                    }
                    if (n14 > n12) continue;
                    n12 = n14;
                    n14 = (n13 >> 16 & 0xFF) - n5;
                    int n15 = n14 * n14;
                    if (n15 >= n4 || (n15 += (n14 = (n13 >> 8 & 0xFF) - n6) * n14) >= n4 || (n15 += (n14 = (n13 & 0xFF) - n7) * n14) >= n4 || this.validBits != null && !this.validBits.testBit(i)) continue;
                    n2 = i;
                    n4 = n15;
                }
                this.Element2 = this.lastSet == 0 ? this.lastSet++ : this.lastSet--;
                this.lastPix[this.lastSet] = n2;
                this.lastRGB[this.lastSet] = n;
                this.lastCM[this.lastSet] = this;
            }
        }
        System.arraycopy(this.lookupcache, 2, this.lookupcache, 0, 38);
        this.lookupcache[39] = n;
        this.lookupcache[38] = ~n2;
        return this.installpixel(object, n2);
    }

    private Object installpixel(Object object, int n) {
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        nArray[n2 + 0] = this.getRed(n);
        nArray[n2 + 1] = this.getGreen(n);
        nArray[n2 + 2] = this.getBlue(n);
        if (this.supportsAlpha && nArray.length - n2 > 3) {
            nArray[n2 + 3] = this.getAlpha(n);
        }
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        int n2;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n2, nArray, n);
    }

    public int getDataElement(int[] nArray, int n) {
        int n2;
        int n3 = nArray[n + 0] << 16 | nArray[n + 1] << 8 | nArray[n + 2];
        n3 = this.supportsAlpha ? (n3 |= nArray[n + 3] << 24) : (n3 |= 0xFF000000);
        Object object = this.getDataElements(n3, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0];
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n2;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = nArray[n + 0] << 16 | nArray[n + 1] << 8 | nArray[n + 2];
        n2 = this.supportsAlpha ? (n2 |= nArray[n + 3] << 24) : (n2 &= 0xFF000000);
        return this.getDataElements(n2, object);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        WritableRaster writableRaster;
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            writableRaster = Raster.createPackedRaster(0, n, n2, 1, this.pixel_bits, null);
        } else if (this.pixel_bits <= 8) {
            writableRaster = Raster.createInterleavedRaster(0, n, n2, 1, null);
        } else if (this.pixel_bits <= 16) {
            writableRaster = Raster.createInterleavedRaster(1, n, n2, 1, null);
        } else {
            throw new UnsupportedOperationException("This method is not supported  for pixel bits > 16.");
        }
        return writableRaster;
    }

    public boolean isCompatibleRaster(Raster raster) {
        int n = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 1 && 1 << n >= this.map_size;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[]{0};
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            return new MultiPixelPackedSampleModel(this.transferType, n, n2, this.pixel_bits);
        }
        return new ComponentSampleModel(this.transferType, n, n2, 1, n, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel) && !(sampleModel instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        return sampleModel.getNumBands() == 1;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException("This raster is not compatiblewith this IndexColorModel.");
        }
        ColorModel colorModel = bl || this.transparency == 3 ? ColorModel.getRGBdefault() : (this.transparency == 2 ? new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000) : new DirectColorModel(24, 0xFF0000, 65280, 255));
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        Object object = null;
        int[] nArray = null;
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = 0;
        while (n5 < n2) {
            nArray = (object = raster.getDataElements(n3, n4, n, 1, object)) instanceof int[] ? (int[])object : DataBuffer.toIntArray(object);
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.rgb[nArray[i]];
            }
            writableRaster.setDataElements(0, n5, n, 1, nArray);
            ++n5;
            ++n4;
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public boolean isValid(int n) {
        return n >= 0 && n < this.map_size && (this.validBits == null || this.validBits.testBit(n));
    }

    public boolean isValid() {
        return this.validBits == null;
    }

    public BigInteger getValidPixels() {
        if (this.validBits == null) {
            return this.getAllValid();
        }
        return this.validBits;
    }

    public void finalize() {
        BufImgSurfaceData.freeNativeICMData(this);
    }

    public String toString() {
        return new String("IndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " transIndex   = " + this.transparent_index + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    static {
        IndexColorModel.initIDs();
    }
}

