/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.methoddictionary.MethodDictionaryDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.jvm.Trace;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public abstract class TraceDataProvider
implements DataProvider {
    private static final String J9VM_333 = "j9vm.333";
    protected static final String J9MM_DOT = "j9mm.";
    private static final String MAXIMAL = "maximal";
    private static final String EXCEPTION = "exception";
    protected static final String PARSERTIME = "5";
    protected final Logger logger;
    protected int maxSendBytes = 100000;
    protected static final int BYTES_PER_LONG = 8;
    private static final int BIG_ENDIAN_SIG = 305419896;
    private static final int LITTLE_ENDIAN_SIG = 2018915346;
    private Set<String> enabledTracePoints = new HashSet<String>();
    private Set<String> exceptionTracePoints = new HashSet<String>();
    protected final HealthCenterOptionHandler handler;
    protected byte[] traceFileHeader = null;
    protected int traceBufferSize = 1;
    protected boolean needTraceHeader = true;
    protected int sizeOfHeader = 0;
    protected int _processID = 0;

    public TraceDataProvider(int pid, HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        this.init(pid, handler);
        if (this.isDataSupported()) {
            this.initializeTracePoints();
        }
    }

    protected abstract void init(int var1, HealthCenterOptionHandler var2);

    private void initializeTracePoints() {
        DataCollectionLevel level = this.handler.getDataCollectionLevel();
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            block10: {
                block9: {
                    boolean nodynamic = this.setNoDynamicProperties(this.handler);
                    if (this.profilingTracepointAvailableInThisVM()) {
                        try {
                            this.enableNormalTracePoint("j9jit.15");
                            if (level.ordinal() >= DataCollectionLevel.FULL.ordinal()) {
                                this.enableNormalTracePoint("j9jit.16");
                            }
                            if (new MethodDictionaryDataProvider(this.handler).isDataSupported()) {
                                this.disableNormalTracePoint(J9VM_333);
                            } else {
                                this.enableNormalTracePoint(J9VM_333);
                            }
                            this.enableNormalTracePoint("j9jit.17");
                            this.enableNormalTracePoint("j9jit.18");
                        }
                        catch (ProviderModificationException e) {
                            if (!HealthCenter.isDebug) break block9;
                            System.out.println(Messages.getString("TraceDataProvider.profiling.unavailable"));
                        }
                    }
                }
                try {
                    this.enableNormalTracePoint("j9bcu.1");
                    this.enableNormalTracePoint("j9shr.51");
                    this.enableNormalTracePoint("j9bcverify.14");
                    this.enableNormalTracePoint("j9bcverify.18");
                }
                catch (ProviderModificationException e) {
                    if (!HealthCenter.isDebug) break block10;
                    System.out.println(Messages.getString("TraceDataProvider.classes.unavailable"));
                }
            }
            int[] gcTPs = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 64, 65, 68, 69, 71, 72, 73, 74, 75, 85, 86, 90, 91, 94, 131, 132, 133, 134, 135, 136, 137, 138, 139};
            this.enableGCTracePoints(gcTPs);
        }
    }

    protected abstract boolean setNoDynamicProperties(HealthCenterOptionHandler var1);

    private boolean profilingTracepointAvailableInThisVM() {
        return Util.getJavaLevel() != 5 || Util.getServiceRefreshNumber() >= 8;
    }

    public void startSession() {
        this.needTraceHeader = true;
    }

    protected void initialiseTraceFileHeader(byte[] array) {
        int length = 0;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(array);
            buffer.getInt();
            length = buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            this.traceBufferSize = buffer.getInt();
            int endianSignature = buffer.getInt();
            switch (endianSignature) {
                case 305419896: {
                    buffer.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 2018915346: {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    length = TraceDataProvider.convertEndian(length);
                    this.traceBufferSize = TraceDataProvider.convertEndian(this.traceBufferSize);
                    break;
                }
                default: {
                    System.out.println(Messages.getString("TraceDataProvider.invalid.endian.signature"));
                    break;
                }
            }
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
        }
        if (this.traceBufferSize > this.maxSendBytes) {
            this.maxSendBytes = this.traceBufferSize;
        }
        if (length > 0) {
            this.traceFileHeader = new byte[length];
            System.arraycopy(array, 0, this.traceFileHeader, 0, length);
        }
        this.sizeOfHeader = this.traceFileHeader.length;
    }

    protected static final int convertEndian(int in) {
        return in >>> 24 | in << 24 | in << 8 & 0xFF0000 | in >> 8 & 0xFF00;
    }

    public void resetData() {
    }

    public void modify(String command, String ... params) throws ProviderModificationException {
        block4: {
            block3: {
                if (!command.toLowerCase().equals("on")) break block3;
                if (params == null) break block4;
                for (String trace : params) {
                    this.enableNormalTracePoint(trace);
                }
                break block4;
            }
            if (command.toLowerCase().equals("off") && params != null) {
                for (String trace : params) {
                    this.disableNormalTracePoint(trace);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEnabledTracePointsString() {
        StringBuffer string = new StringBuffer();
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            for (String tp : this.enabledTracePoints) {
                string.append(tp);
                string.append(",");
            }
            for (String tp : this.exceptionTracePoints) {
                string.append(tp);
                string.append(",");
            }
        }
        if (string.length() > 0) {
            string.deleteCharAt(string.length() - 1);
        }
        return string.toString();
    }

    private void disableExceptionTracePoint(String tp) throws ProviderModificationException {
        this.disableTracePoint(tp, EXCEPTION);
        this.exceptionTracePoints.remove(tp);
    }

    protected void enableExceptionTracePoint(String tp) throws ProviderModificationException {
        this.enableTracePoint(tp, EXCEPTION);
        this.exceptionTracePoints.add(tp);
    }

    protected void disableNormalTracePoint(String tp) throws ProviderModificationException {
        this.disableTracePoint(tp, MAXIMAL);
        this.enabledTracePoints.remove(tp);
    }

    protected void enableNormalTracePoint(String tp) throws ProviderModificationException {
        this.enableTracePoint(tp, MAXIMAL);
        this.enabledTracePoints.add(tp);
    }

    protected abstract void enableGCTracePoints(int[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableTracePoint(String tp, String buffer) throws ProviderModificationException {
        tp = tp.trim().toLowerCase();
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            int rc = Trace.set((String)MessageFormat.format("{0}=!tpnid'{'{1}'}'", buffer, tp));
            if (rc != 0) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling"), tp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableTracePoint(String tp, String buffer) throws ProviderModificationException {
        tp = tp.trim().toLowerCase();
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            int rc = Trace.set((String)MessageFormat.format("{0}=tpnid'{'{1}'}'", buffer, tp));
            if (rc != 0) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.enabling"), tp));
            }
            this.enabledTracePoints.add(tp);
        }
    }
}

