/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class ExternalClient
implements SaslClient {
    private byte[] username;
    private boolean completed = false;

    ExternalClient(String authorizationID) throws SaslException {
        if (authorizationID != null) {
            try {
                this.username = authorizationID.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("Cannot convert " + authorizationID + " into UTF-8", e);
            }
        } else {
            this.username = new byte[0];
        }
    }

    public String getMechanismName() {
        return "EXTERNAL";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("EXTERNAL authentication already completed");
        }
        this.completed = true;
        return this.username;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication Not completed");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            return null;
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }
}

