/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.motif;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import sun.plugin.navig.motif.AThread;
import sun.plugin.navig.motif.Plugin;

public class OJIPlugin {
    public static final int SpontFD = 10;
    private static int spontcount = 0;
    private static Hashtable threads = new Hashtable();
    private static Object SpontMonitor = new Lock();
    private static DataOutputStream spontOut;
    private static DataInputStream spontIn;

    public static void initialize() {
        spontIn = Plugin.newInput("Spont Comm", 10);
        spontOut = Plugin.newOutput("Spont Comm", 10);
    }

    public static int acquirePipeForCurrentThread() {
        int n;
        AThread aThread = OJIPlugin.getCurrentAThread();
        if (aThread != null) {
            n = aThread.getPipe();
            Plugin.trace("OJIPlugin acq thread=:" + aThread.toString() + " pipe=" + n);
        } else {
            n = 10;
            Plugin.trace("OJIPlugin acq Spontaneous pipe=" + n);
            OJIPlugin.enterSpontaneousMonitor();
        }
        return n;
    }

    public static void releasePipeForCurrentThread() {
        Thread thread = Thread.currentThread();
        if (thread != null) {
            Plugin.trace(" OJIPlugin release for:" + thread.toString());
        } else {
            Plugin.trace(" OJIPlugin release for: null thread!?");
        }
        if (!threads.contains(thread)) {
            Plugin.trace("OJIPlugin releasePipe - exiting spont monitor");
            OJIPlugin.exitSpontaneousMonitor();
        } else {
            Plugin.trace("OJIPlugin release - non spontaneous pipe");
        }
    }

    private static synchronized AThread getCurrentAThread() {
        Thread thread = Thread.currentThread();
        Plugin.trace("Current thread:" + thread.toString());
        if (threads.contains(thread)) {
            Plugin.trace("OJIPlugin: Retrieve the AThread\n");
            return (AThread)threads.get(thread);
        }
        Plugin.trace("OJIPlugin: No AThread\n");
        return null;
    }

    public static synchronized void registerThread(AThread aThread) {
        Thread thread = Thread.currentThread();
        Plugin.trace("Registering thread: " + thread.toString() + " with AThread " + aThread.toString());
        threads.put(thread, aThread);
    }

    static void enterSpontaneousMonitor() {
        Plugin.trace("Trying to enter spont monitor: " + spontcount);
        OJIPlugin.enterMonitor(SpontMonitor);
        ++spontcount;
    }

    static void exitSpontaneousMonitor() {
        --spontcount;
        OJIPlugin.exitMonitor(SpontMonitor);
    }

    private static native void enterMonitor(Object var0);

    private static native void exitMonitor(Object var0);

    private static class Lock {
        private Lock() {
        }
    }
}

