/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;
import java.util.Set;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 1024;
    private PKCS11Session session = null;
    private Config config = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private boolean paramsUsed = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator";

    public RSAPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
    }

    public RSAPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null || !(params instanceof PKCS11RSAKeyPairParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 RSA KeyPair Parameters must be specified");
        }
        PKCS11RSAKeyPairParameterSpec spec = (PKCS11RSAKeyPairParameterSpec)params;
        try {
            RSAKeyFactory.checkKeyLengths((int)spec.getStrength(), null, (int)512, (int)65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        this.modlen = spec.getStrength();
        if (spec.getKeyID() != null) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        }
        if (spec.getSubject() != null) {
            try {
                this.subject = spec.getSubject().getBytes("8859_1");
            }
            catch (Exception e) {
                this.subject = spec.getSubject().getBytes();
            }
        }
        this.label = spec.getLabel();
        this.isSensitive = spec.getSensitive();
        this.isToken = spec.getToken();
        this.sign = spec.getSign();
        this.encrypt = spec.getEncrypt();
        this.wrapping = spec.getWrap();
        this.extractable = spec.getExtractable();
        this.paramsUsed = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength), (Object)random);
        }
        try {
            RSAKeyFactory.checkKeyLengths((int)strength, (BigInteger)RSAKeyGenParameterSpec.F4, (int)512, (int)65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.modlen = strength;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength) {
        this.initialize(strength, null);
    }

    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        int sizePubArray = 9;
        int sizePrivArray = 9;
        int count = 0;
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        Boolean isTokenPub = this.isToken;
        Boolean isTokenPriv = this.isToken;
        Boolean signPub = this.sign;
        Boolean signPriv = this.sign;
        Boolean encryptPub = this.encrypt;
        Boolean encryptPriv = this.encrypt;
        Boolean wrappingPub = this.wrapping;
        Boolean wrappingPriv = this.wrapping;
        if (this.isToken == null) {
            --sizePrivArray;
            --sizePubArray;
        }
        if (this.isSensitive == null) {
            --sizePrivArray;
        }
        if (this.sign == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.encrypt == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.wrapping == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.extractable == null) {
            --sizePrivArray;
        }
        if (this.config != null) {
            hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
            keys = hattrs.keySet();
            block19: for (Integer key : keys) {
                switch (key) {
                    case 1: {
                        if (this.paramsUsed) continue block19;
                        if (isTokenPub == null) {
                            ++sizePubArray;
                        }
                        isTokenPub = (Boolean)hattrs.get(key);
                        continue block19;
                    }
                    case 266: {
                        if (this.paramsUsed) continue block19;
                        if (signPub == null) {
                            ++sizePubArray;
                        }
                        signPub = (Boolean)hattrs.get(key);
                        continue block19;
                    }
                    case 260: {
                        if (this.paramsUsed) continue block19;
                        if (encryptPub == null) {
                            ++sizePubArray;
                        }
                        encryptPub = (Boolean)hattrs.get(key);
                        continue block19;
                    }
                    case 262: {
                        if (this.paramsUsed) continue block19;
                        if (wrappingPub == null) {
                            ++sizePubArray;
                        }
                        wrappingPub = (Boolean)hattrs.get(key);
                        continue block19;
                    }
                }
                ++sizePubArray;
            }
        }
        int[] pubTypes = new int[sizePubArray];
        Object[] pubValues = new Object[sizePubArray];
        pubTypes[count] = 289;
        pubValues[count++] = new Integer(this.modlen);
        pubTypes[count] = 290;
        pubValues[count++] = new BigInteger("65537");
        pubTypes[count] = 258;
        pubValues[count++] = this.id;
        pubTypes[count] = 257;
        pubValues[count++] = this.subject;
        pubTypes[count] = 3;
        pubValues[count++] = this.label;
        if (isTokenPub != null) {
            pubTypes[count] = 1;
            pubValues[count++] = isTokenPub;
        }
        if (signPub != null) {
            pubTypes[count] = 266;
            pubValues[count++] = signPub;
        }
        if (encryptPub != null) {
            pubTypes[count] = 260;
            pubValues[count++] = encryptPub;
        }
        if (wrappingPub != null) {
            pubTypes[count] = 262;
            pubValues[count++] = wrappingPub;
        }
        if (keys != null) {
            for (Integer key : keys) {
                if (key == 1 || key == 266 || key == 260 || key == 262) continue;
                pubTypes[count] = key;
                pubValues[count++] = hattrs.get(key);
            }
        }
        if (this.config != null) {
            hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
            keys = hattrs.keySet();
            block21: for (Integer key : keys) {
                switch (key) {
                    case 1: {
                        if (this.paramsUsed) continue block21;
                        if (isTokenPriv == null) {
                            ++sizePubArray;
                        }
                        isTokenPriv = (Boolean)hattrs.get(key);
                        continue block21;
                    }
                    case 259: {
                        if (this.paramsUsed) continue block21;
                        if (this.isSensitive == null) {
                            ++sizePubArray;
                        }
                        this.isSensitive = (Boolean)hattrs.get(key);
                        continue block21;
                    }
                    case 261: {
                        if (this.paramsUsed) continue block21;
                        if (encryptPriv == null) {
                            ++sizePubArray;
                        }
                        encryptPriv = (Boolean)hattrs.get(key);
                        continue block21;
                    }
                    case 264: {
                        if (this.paramsUsed) continue block21;
                        if (signPriv == null) {
                            ++sizePubArray;
                        }
                        signPriv = (Boolean)hattrs.get(key);
                        continue block21;
                    }
                    case 263: {
                        if (this.paramsUsed) continue block21;
                        if (wrappingPriv == null) {
                            ++sizePubArray;
                        }
                        wrappingPriv = (Boolean)hattrs.get(key);
                        continue block21;
                    }
                }
                ++sizePubArray;
            }
        }
        int[] privTypes = new int[sizePrivArray];
        Object[] privValues = new Object[sizePrivArray];
        count = 0;
        privTypes[count] = 258;
        privValues[count++] = this.id;
        privTypes[count] = 257;
        privValues[count++] = this.subject;
        privTypes[count] = 3;
        privValues[count++] = this.label;
        if (isTokenPriv != null) {
            privTypes[count] = 1;
            privValues[count++] = isTokenPriv;
        }
        if (this.isSensitive != null) {
            privTypes[count] = 259;
            privValues[count++] = this.isSensitive;
        }
        if (encryptPriv != null) {
            privTypes[count] = 261;
            privValues[count++] = encryptPriv;
        }
        if (signPriv != null) {
            privTypes[count] = 264;
            privValues[count++] = signPriv;
        }
        if (wrappingPriv != null) {
            privTypes[count] = 263;
            privValues[count++] = wrappingPriv;
        }
        if (this.extractable != null) {
            privTypes[count] = 354;
            privValues[count] = this.extractable;
        }
        if (keys != null) {
            for (Integer key : keys) {
                if (key == 1 || key == 259 || key == 261 || key == 264 || key == 263 || key == 354) continue;
                pubTypes[count] = key;
                pubValues[count++] = hattrs.get(key);
            }
        }
        String error = "";
        PKCS11Object[] objs = null;
        KeyPair pair = null;
        try {
            objs = this.session.generateKeyPair(0, null, pubTypes, pubValues, privTypes, privValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        PKCS11Object[] returnobjs = this.orderObjects(objs);
        PKCS11Object pubObj = returnobjs[0];
        PKCS11Object privObj = returnobjs[1];
        try {
            RSAPublicKey pubKey = new RSAPublicKey(this.session, pubObj, this.id, this.subject, this.label, this.isToken, this.sign, this.encrypt, this.wrapping, (BigInteger)this.getValue(pubObj, 288), (Integer)this.getValue(pubObj, 289), (BigInteger)this.getValue(pubObj, 290));
            RSAPrivateKey privKey = null;
            if (this.isSensitive.booleanValue()) {
                privKey = new RSAPrivateKey(this.session, privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290));
            } else {
                try {
                    privKey = new RSAPrivateKey(this.session, privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290), (BigInteger)this.getValue(privObj, 291), (BigInteger)this.getValue(privObj, 292), (BigInteger)this.getValue(privObj, 293), (BigInteger)this.getValue(privObj, 294), (BigInteger)this.getValue(privObj, 295), (BigInteger)this.getValue(privObj, 296));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)ex);
                    }
                    privKey = new RSAPrivateKey(this.session, privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290));
                }
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_3", (Throwable)e);
            }
            pair = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] objs) {
        if (debug != null) {
            String objString = objs.toString();
            debug.entry(16384L, (Object)className, "orderObjects", (Object)objString);
        }
        Integer objsType0 = (Integer)this.getValue(objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)objs);
        }
        return objs;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

