/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithRSA
extends SignatureSpi {
    private Signature sig;
    private byte[] hashData;
    private int count = 0;

    public PKCS11SSLHashingwithRSA(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(1, provider);
        this.hashData = new byte[128];
    }

    public PKCS11SSLHashingwithRSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    protected void engineSetParameter(String key, Object param) {
    }

    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte b) {
        if (this.count + 1 > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        this.hashData[this.count] = b;
        ++this.count;
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (this.count + len > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128 + len];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        System.arraycopy(data, off, this.hashData, this.count, len);
        this.count += len;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] rtn = this.sig.engineSign(this.hashData, this.count);
        this.count = 0;
        return rtn;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        boolean rtn = this.sig.engineVerify(signature, this.hashData, this.count);
        this.count = 0;
        return rtn;
    }
}

