/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class GeneralPKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder = null;
    private Provider provider = null;

    public GeneralPKCS11KeyFactory(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        this.provider = provider;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        GeneralKey genKey = null;
        Integer keyType = this.mechanismBuilder.getKeyType();
        if (keySpec == null) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            try {
                KeySpec dks;
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isSensitive = Boolean.FALSE;
                Boolean encrypt = Boolean.TRUE;
                Boolean wrapping = Boolean.TRUE;
                Boolean extractable = Boolean.TRUE;
                byte[] value = null;
                int[] attrTypes = null;
                Object[] attrValues = null;
                if (keySpec instanceof SecretKeySpec) {
                    SecretKeySpec generalPKCS11KeySpec = (SecretKeySpec)keySpec;
                    value = generalPKCS11KeySpec.getEncoded();
                } else if (keySpec instanceof DESKeySpec) {
                    dks = (DESKeySpec)keySpec;
                    value = ((DESKeySpec)dks).getKey();
                } else if (keySpec instanceof DESedeKeySpec) {
                    dks = (DESedeKeySpec)keySpec;
                    value = ((DESedeKeySpec)dks).getKey();
                } else {
                    throw new InvalidKeySpecException("Unknown Key specification");
                }
                ID = this.genID();
                HashMap<Integer, Object> hattrs = null;
                Set<Integer> keys = null;
                int numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.SECRET_KEY, keyType);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[4 + numEles];
                    attrValues = new Object[4 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 17;
                    attrValues[0] = PKCS11Object.SECRET_KEY;
                    attrValues[1] = keyType;
                    attrValues[2] = ID;
                    attrValues[3] = value;
                    Iterator<Integer> it = keys.iterator();
                    int i = 1;
                    while (it.hasNext()) {
                        Integer key = it.next();
                        attrTypes[3 + i] = key;
                        attrValues[3 + i] = hattrs.get(key);
                        ++i;
                    }
                } else {
                    int[] attrTypes1 = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                    attrTypes = attrTypes1;
                    attrValues = new Object[]{PKCS11Object.SECRET_KEY, keyType, ID, Boolean.TRUE, isToken, isSensitive, encrypt, new Boolean(encrypt), wrapping, new Boolean(wrapping), value};
                }
                object = this.session.createObject(attrTypes, attrValues);
                genKey = new GeneralKey(this.session, object, this.mechanismBuilder.getAlgorithm());
            }
            catch (InvalidKeyException e) {}
        } else {
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                genKey = new GeneralKey(this.session, object, this.mechanismBuilder.getAlgorithm());
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
        }
        return genKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            String algorithmName = this.mechanismBuilder.getAlgorithm();
            if (key != null && key instanceof PKCS11SecretKey && key.getAlgorithm().equalsIgnoreCase(algorithmName) && key.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> SecretKeySpec2 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (keySpec != null && SecretKeySpec2.isAssignableFrom(keySpec)) {
                    if (((GeneralKey)key).getSensitive().booleanValue()) {
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    return new SecretKeySpec(((GeneralKey)key).getValue(), algorithmName);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key != null && key.getAlgorithm().equalsIgnoreCase(algorithmName) && key.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> SecretKeySpec3 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (keySpec != null && SecretKeySpec3.isAssignableFrom(keySpec)) {
                    return new SecretKeySpec(key.getEncoded(), algorithmName);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm())) {
                if (key instanceof PKCS11SecretKey) {
                    return key;
                }
                if (key.getFormat().equalsIgnoreCase("RAW")) {
                    SecretKeySpec genKeySpec = (SecretKeySpec)this.engineGetKeySpec(key, (Class)SecretKeySpec.class);
                    return this.engineGenerateSecret(genKeySpec);
                }
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            rtn = null;
        }
        return rtn;
    }
}

