/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.Provider;

public final class GeneralHashing
extends MessageDigestSpi
implements Cloneable {
    private static final int MD2_LENGTH = 16;
    private static final int MD5_LENGTH = 16;
    private static final int SHA_LENGTH = 20;
    private static final int SHA2_LENGTH = 32;
    private static final int SHA3_LENGTH = 48;
    private static final int SHA5_LENGTH = 64;
    private Hash hash;
    private int mechanism;

    public GeneralHashing(Provider provider, String algorithm) {
        if (algorithm.equalsIgnoreCase("MD2")) {
            this.mechanism = 512;
        } else if (algorithm.equalsIgnoreCase("MD5")) {
            this.mechanism = 528;
        } else if (algorithm.equalsIgnoreCase("SHA")) {
            this.mechanism = 544;
        } else if (algorithm.equalsIgnoreCase("SHA-256")) {
            this.mechanism = 592;
        } else if (algorithm.equalsIgnoreCase("SHA-384")) {
            this.mechanism = 608;
        } else if (algorithm.equalsIgnoreCase("SHA-512")) {
            this.mechanism = 624;
        } else {
            System.out.println("Algo = " + algorithm);
        }
        this.init(provider);
    }

    private GeneralHashing(GeneralHashing old) {
        this.hash = (Hash)old.hash.clone();
        this.mechanism = old.mechanism;
    }

    public void init(Provider provider) {
        this.hash = new Hash(this.mechanism, ((IBMPKCS11Impl)provider).getSession());
    }

    protected void engineReset() {
        this.hash.engineReset();
    }

    protected int engineGetDigestLength() {
        int result = 0;
        switch (this.mechanism) {
            case 512: {
                result = 16;
                break;
            }
            case 528: {
                result = 16;
                break;
            }
            case 544: {
                result = 20;
                break;
            }
            case 592: {
                result = 32;
                break;
            }
            case 608: {
                result = 48;
                break;
            }
            case 624: {
                result = 64;
            }
        }
        return result;
    }

    protected synchronized void engineUpdate(byte b) {
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
    }

    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        this.hash.engineUpdate(input, offset, len);
    }

    protected byte[] engineDigest() {
        byte[] result = this.hash.engineDigest();
        return result;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        int resultLen = this.hash.engineDigest(buf, offset, len);
        return resultLen;
    }

    public Object clone() {
        GeneralHashing that = null;
        try {
            that = (GeneralHashing)super.clone();
            that.hash = (Hash)this.hash.clone();
            return that;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return that;
        }
    }
}

