/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getProtectionDomains(int var0);

    public static void checkPermission(Permission permission) throws AccessControlException {
        if (permission == null) {
            throw new NullPointerException();
        }
        if ((AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace").printStackTrace();
        }
        Object[] objectArray = AccessController.getProtectionDomains(1);
        AccessControlContext accessControlContext = (AccessControlContext)objectArray[0];
        ProtectionDomain[] protectionDomainArray = null;
        if (accessControlContext != null && accessControlContext.domainCombiner != null) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
            }
            protectionDomainArray = accessControlContext.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(objectArray, null), accessControlContext.context);
        } else {
            protectionDomainArray = AccessController.toArrayOfProtectionDomains(objectArray, accessControlContext);
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (protectionDomainArray.length == 0) {
                System.err.println("domain (context is null)");
            }
        }
        int n = protectionDomainArray.length;
        for (int i = 0; i < n; ++i) {
            if (protectionDomainArray[i].implies(permission)) continue;
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + permission);
            }
            if ((AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + protectionDomainArray[i]);
            }
            throw new AccessControlException(Msg.getString("K002c", permission), permission);
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + permission);
        }
    }

    private static void keepalive(AccessControlContext accessControlContext) {
    }

    public static AccessControlContext getContext() {
        Object[] objectArray = AccessController.getProtectionDomains(1);
        AccessControlContext accessControlContext = (AccessControlContext)objectArray[0];
        ProtectionDomain[] protectionDomainArray = null;
        if (accessControlContext != null && accessControlContext.domainCombiner != null) {
            protectionDomainArray = accessControlContext.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(objectArray, null), accessControlContext.context);
            AccessControlContext accessControlContext2 = new AccessControlContext(protectionDomainArray, false);
            accessControlContext2.domainCombiner = accessControlContext.domainCombiner;
            return accessControlContext2;
        }
        return new AccessControlContext(AccessController.toArrayOfProtectionDomains(objectArray, accessControlContext), false);
    }

    private static ProtectionDomain[] toArrayOfProtectionDomains(Object[] objectArray, AccessControlContext accessControlContext) {
        int n = 0;
        int n2 = objectArray.length - 1;
        int n3 = accessControlContext == null ? 0 : accessControlContext.context.length;
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n2 + n3];
        for (int i = 1; i <= n2; ++i) {
            boolean bl = false;
            protectionDomainArray[n] = (ProtectionDomain)objectArray[i];
            if (protectionDomainArray[n] == null) break;
            if (accessControlContext != null) {
                for (int j = 0; j < accessControlContext.context.length; ++j) {
                    if (protectionDomainArray[n] != accessControlContext.context[j]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            ++n;
        }
        if (n == 0 && accessControlContext != null) {
            return accessControlContext.context;
        }
        if (n < n2) {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n + n3];
            System.arraycopy((Object)protectionDomainArray, 0, (Object)protectionDomainArray2, 0, n);
            protectionDomainArray = protectionDomainArray2;
        }
        if (accessControlContext != null) {
            System.arraycopy((Object)accessControlContext.context, 0, (Object)protectionDomainArray, n, accessControlContext.context.length);
        }
        return protectionDomainArray;
    }

    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        return privilegedAction.run();
    }

    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
        T t = privilegedAction.run();
        AccessController.keepalive(accessControlContext);
        return t;
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        try {
            T t = privilegedExceptionAction.run();
            AccessController.keepalive(accessControlContext);
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    static {
        AccessController.initializeInternal();
    }
}

