/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;

public final class AccessControlContext {
    static int debugSetting = -1;
    DomainCombiner domainCombiner;
    ProtectionDomain[] context;
    private static final SecurityPermission createAccessControlContext = new SecurityPermission("createAccessControlContext");
    private static final SecurityPermission getDomainCombiner = new SecurityPermission("getDomainCombiner");
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        boolean bl = false;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (string == null) {
            return debugSetting;
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            String string2;
            int n3 = string.indexOf(44, n);
            if (n3 == -1) {
                n3 = n2;
            }
            if ((string2 = string.substring(n, n3)).equals("all")) {
                debugSetting = 255;
                return debugSetting;
            }
            if (string2.startsWith("access")) {
                debugSetting |= 1;
                if (n + 6 < n2 && string.charAt(n + 6) == ':') {
                    n3 = n + 6;
                    bl = true;
                }
            } else if (bl && string2.equals("stack")) {
                debugSetting |= 2;
            } else if (bl && string2.equals("domain")) {
                debugSetting |= 4;
            } else if (bl && string2.equals("failure")) {
                debugSetting |= 8;
            } else if (bl && string2.equals("thread")) {
                debugSetting |= 0x10;
            } else {
                bl = false;
            }
            n = n3 + 1;
        }
        return debugSetting;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        int n = protectionDomainArray.length;
        int n2 = 0;
        this.context = new ProtectionDomain[n];
        block0: for (int i = 0; i < n; ++i) {
            ProtectionDomain protectionDomain = protectionDomainArray[i];
            for (int j = 0; j < i; ++j) {
                if (protectionDomain == this.context[j]) continue block0;
            }
            this.context[n2++] = protectionDomain;
        }
        if (n2 != n) {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n2];
            System.arraycopy((Object)this.context, 0, (Object)protectionDomainArray2, 0, n2);
            this.context = protectionDomainArray2;
        }
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(createAccessControlContext);
        }
        this.context = accessControlContext.context;
        this.domainCombiner = domainCombiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n;
        if (permission == null) {
            throw new NullPointerException();
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (this.context.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (n = 0; n < this.context.length; ++n) {
                    System.err.println("domain " + n + " " + this.context[n]);
                }
            }
        }
        n = this.context.length;
        while (--n >= 0 && this.context[n].implies(permission)) {
        }
        if (n >= 0) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + permission);
            }
            if ((AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + this.context[n]);
            }
            throw new AccessControlException(Msg.getString("K002c", permission), permission);
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + permission);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        int n = this.context.length;
        ProtectionDomain[] protectionDomainArray = accessControlContext.context;
        if (n != protectionDomainArray.length) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            ProtectionDomain protectionDomain = this.context[i];
            for (int j = 0; j < n; ++j) {
                if (protectionDomain == protectionDomainArray[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.context.length;
        while (--n2 >= 0) {
            n ^= this.context[n2].hashCode();
        }
        return n;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(getDomainCombiner);
        }
        return this.domainCombiner;
    }
}

