/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.IPC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

class Attachment
extends Thread {
    public static final String ATTACH_LOADAGENT = "ATTACH_LOADAGENT";
    public static final String ATTACH_LOADAGENTPATH = "ATTACH_LOADAGENTPATH";
    public static final String ATTACH_LOADAGENTLIBRARY = "ATTACH_LOADAGENTLIBRARY";
    public static final String ATTACH_ACK = "ATTACH_ACK";
    public static final String ATTACH_DETACH = "ATTACH_DETACH";
    public static final String ATTACH_EXCEPTION_IOEXCEPTION = "IOException";
    public static final String ATTACH_EXCEPTION_AGENT_INITIALIZATION_EXCEPTION = "AgentInitializationException";
    public static final String ATTACH_EXCEPTION_AGENT_LOAD_EXCEPTION = "AgentLoadException";
    public static final String ATTACH_CONNECTED = "ATTACH_CONNECTED";
    public static final String ATTACH_DETACHED = "ATTACH_DETACHED";
    public static final String ATTACH_ERR = "ATTACH_ERR";
    public static final String ATTACH_GETSYSTEMPROPERTIES = "ATTACH_GETSYSTEMPROPERTIES";
    public static final String ATTACH_GETAGENTPROPERTIES = "ATTACH_GETAGENTPROPERTIES";
    public Exception lastError;
    private OutputStream responseStream;
    private Socket attacherSocket;
    private final int portNumber;
    private InputStream commandStream;
    private String attachError;
    private final AttachHandler handler;
    private final String key;

    public Attachment(AttachHandler attachHandler, IPC.ReplyContent replyContent) {
        this.setName("Attachment " + replyContent.getPortNumber());
        this.portNumber = replyContent.getPortNumber();
        this.key = replyContent.getKey();
        this.handler = attachHandler;
        this.setDaemon(true);
    }

    public boolean connectToAttacher(int n) {
        try {
            AttachHandler.logMessage("connectToAttacher portNum=" + n);
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.attacherSocket = new Socket(inetAddress, n);
            AttachHandler.logMessage("connectToAttacher localPort=" + this.attacherSocket.getLocalPort() + " remotePort=" + this.attacherSocket.getPort());
            this.responseStream = this.attacherSocket.getOutputStream();
            this.commandStream = this.attacherSocket.getInputStream();
            IPC.streamSend(this.responseStream, "ATTACH_CONNECTED " + this.key + ' ');
        }
        catch (IOException iOException) {
            AttachHandler.logMessage("connectToAttacher exception " + iOException.getMessage() + " " + iOException.toString());
            try {
                if (null != this.responseStream) {
                    this.responseStream.close();
                }
                if (null != this.commandStream) {
                    this.commandStream.close();
                }
                if (null != this.attacherSocket) {
                    this.attacherSocket.close();
                }
            }
            catch (IOException iOException2) {
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            AttachHandler.logMessage("connectToAttacher exception " + exception.toString());
            return false;
        }
        return true;
    }

    public void run() {
        boolean bl = false;
        AttachHandler.logMessage("Attachment run");
        this.connectToAttacher(this.getPortNumber());
        while (!bl && !this.isInterrupted()) {
            bl = this.doCommand(this.commandStream, this.responseStream);
        }
        try {
            IPC.streamSend(this.responseStream, ATTACH_DETACHED);
            if (null != this.responseStream) {
                this.responseStream.close();
                this.responseStream = null;
            }
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
        if (null != this.handler) {
            this.handler.removeAttachment(this);
        }
    }

    public boolean doCommand(InputStream inputStream, OutputStream outputStream) {
        try {
            String string = null;
            string = IPC.streamReceiveString(inputStream);
            AttachHandler.logMessage("doCommand " + string);
            if (null == string) {
                return true;
            }
            if (string.startsWith(ATTACH_DETACH)) {
                return true;
            }
            if (string.startsWith(ATTACH_LOADAGENT)) {
                if (this.parseLoadAgent(string)) {
                    IPC.streamSend(outputStream, ATTACH_ACK);
                } else {
                    IPC.streamSend(outputStream, "ATTACH_ERR " + this.attachError);
                }
            } else if (string.startsWith(ATTACH_GETSYSTEMPROPERTIES)) {
                this.replyWithProperties(true);
            } else if (string.startsWith(ATTACH_GETAGENTPROPERTIES)) {
                this.replyWithProperties(false);
            } else {
                IPC.streamSend(outputStream, "ATTACH_ERR command invalid: " + string);
            }
        }
        catch (IOException iOException) {
            AttachHandler.logMessage("doCommand exception " + iOException.toString());
            return true;
        }
        return false;
    }

    private void replyWithProperties(boolean bl) throws IOException {
        Properties properties = bl ? System.getProperties() : AttachHandler.getAgentProperties();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "");
        this.responseStream.write(byteArrayOutputStream.toByteArray());
        this.responseStream.write(0);
    }

    public synchronized void teardown() {
        try {
            if (null != this.responseStream) {
                this.responseStream.close();
            }
            if (null != this.attacherSocket) {
                this.attacherSocket.close();
            }
            if (null != this.commandStream) {
                this.commandStream.close();
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
    }

    private boolean parseLoadAgent(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        int n3 = string.indexOf(44);
        String string2 = "";
        boolean bl = true;
        this.attachError = null;
        if (string.startsWith(ATTACH_LOADAGENTPATH)) {
            bl = false;
        }
        if (n < 0 || n2 < 0) {
            this.attachError = "syntax error";
            return false;
        }
        int n4 = n3 < 0 ? n2 : n3;
        String string3 = string.substring(n + 1, n4);
        if (string3.length() < 1) {
            this.attachError = "invalid agent name";
            return false;
        }
        if (n3 > 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        this.attachError = this.loadAgentLibrary(string3, string2, bl);
        return this.attachError == null;
    }

    public String loadAgentLibrary(String string, String string2, boolean bl) {
        AttachHandler.logMessage("loadAgentLibrary " + string + ":" + string2 + " decorate=" + bl);
        int n = this.loadAgentLibraryImpl(string, string2, bl);
        if (0 != n) {
            if (-1 == n) {
                return "AgentLoadException " + string + ":" + string2;
            }
            return ATTACH_EXCEPTION_AGENT_INITIALIZATION_EXCEPTION + n;
        }
        return null;
    }

    private native int loadAgentLibraryImpl(String var1, String var2, boolean var3);

    private int getPortNumber() {
        return this.portNumber;
    }
}

