/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.MemoryCache;
import com.ibm.security.cert.X509CertificatePair;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedAction;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;

public class LDAPCertStoreImpl
extends CertStoreSpi {
    private static final String USER_CERT = "userCertificate";
    private static final String CA_CERT = "cACertificate";
    private static final String CROSS_CERT = "crossCertificatePair";
    private static final String CRL = "certificateRevocationList";
    private static final String ARL = "authorityRevocationList";
    private static final String DELTA_CRL = "deltaRevocationList";
    private static final String USER_CERT_BIN = "userCertificate;binary";
    private static final String CA_CERT_BIN = "cACertificate;binary";
    private static final String CROSS_CERT_BIN = "crossCertificatePair;binary";
    private static final String CRL_BIN = "certificateRevocationList;binary";
    private static final String ARL_BIN = "authorityRevocationList;binary";
    private static final String DELTA_CRL_BIN = "deltaRevocationList;binary";
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private static final byte[][] EMPTY_VALUES = new byte[0][];
    private static final int DEFAULT_CACHE_SIZE = 3000;
    private static final int DEFAULT_CACHE_LIFETIME = 86400;
    private static int LIFETIME;
    private static final String PROP_LIFETIME = "ibm.security.certpath.ldap.cache.lifetime";
    private DirContext ctx;
    private static final int MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS = 2;
    private int consecutiveFailedGetAttributeAttemptsCounter = 0;
    LDAPCertStoreParameters savedLDAPCertStoreParameters = null;
    private boolean prefetchCRLs = false;
    private final MemoryCache valueCache;
    private static final Debug debug;

    public LDAPCertStoreImpl(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        this.init((LDAPCertStoreParameters)params);
        this.valueCache = LIFETIME <= 0 ? new MemoryCache(3000, 0) : new MemoryCache(3000, LIFETIME);
    }

    public void init(LDAPCertStoreParameters params) throws InvalidAlgorithmParameterException {
        Properties env = new Properties();
        String myHost = null;
        String stringLDAP = new String("ldap://");
        int myPort = -1;
        this.savedLDAPCertStoreParameters = params;
        if (debug != null) {
            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  init():  Saving the LDAPCertStoreParameters used to initialize.");
            System.out.println("                                            consecutiveFailedGetAttributeAttemptsCounter     = " + this.consecutiveFailedGetAttributeAttemptsCounter);
            System.out.println("                                            MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS = 2");
        }
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.factory.url.pkgs", "com.sun.jndi.ldap");
            if (!(params instanceof LDAPCertStoreParameters)) {
                throw new InvalidAlgorithmParameterException();
            }
            myHost = params.getServerName();
            myPort = params.getPort();
            if (myHost == null || myPort < 0) {
                throw new InvalidAlgorithmParameterException();
            }
            String stringHostPort = stringLDAP + myHost + ":" + myPort;
            env.put("java.naming.provider.url", stringHostPort);
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException ne) {
            InvalidAlgorithmParameterException iaex = new InvalidAlgorithmParameterException(ne.getMessage());
            iaex.initCause(ne);
            throw iaex;
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidAlgorithmParameterException iaex = new InvalidAlgorithmParameterException(iape.getMessage());
            iaex.initCause(iape);
            throw iaex;
        }
    }

    private Collection getCertificates(LDAPRequest request, String id, CertSelector sel) throws CertStoreException {
        byte[][] encodedCert;
        try {
            encodedCert = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCert.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CertImpl> certs = new ArrayList<X509CertImpl>(n);
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert[i]);
            try {
                X509CertImpl cert = new X509CertImpl((InputStream)bais);
                if (!sel.match((Certificate)cert)) continue;
                if (debug != null) {
                    System.out.println("CERTPATH: found a matched cert");
                }
                certs.add(cert);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad cert data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCert[i]) + " ]");
            }
        }
        return certs;
    }

    private Collection getCertPairs(LDAPRequest request, String id) throws CertStoreException {
        byte[][] encodedCertPair;
        try {
            encodedCertPair = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCertPair.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CertificatePair> certPairs = new ArrayList<X509CertificatePair>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CertificatePair certPair = new X509CertificatePair(encodedCertPair[i]);
                certPairs.add(certPair);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad certificate pair data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCertPair[i]) + " ]");
            }
        }
        return certPairs;
    }

    private Collection getMatchingCrossCerts(LDAPRequest request, CertSelector forward, CertSelector reverse) throws CertStoreException {
        Collection certPairs = this.getCertPairs(request, CROSS_CERT);
        ArrayList<X509Certificate> matchingCerts = new ArrayList<X509Certificate>();
        for (X509CertificatePair certPair : certPairs) {
            X509Certificate cert;
            if (forward != null && (cert = certPair.getForward()) != null && forward.match(cert)) {
                matchingCerts.add(cert);
            }
            if (reverse == null || (cert = certPair.getReverse()) == null || !reverse.match(cert)) continue;
            matchingCerts.add(cert);
        }
        return matchingCerts;
    }

    public synchronized Collection engineGetCertificates(CertSelector selector) throws CertStoreException {
        LDAPRequest request;
        X509CertSelector xsel = null;
        if (selector == null) {
            xsel = new X509CertSelector();
        }
        if (!(selector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        xsel = (X509CertSelector)selector;
        HashSet certs = new HashSet();
        X500Principal subjectName = xsel.getSubject();
        X500Principal issuerName = xsel.getIssuer();
        String subject = null;
        if (subjectName != null) {
            subject = subjectName.getName("RFC1779");
            subject = this.removeOIDStringsFromDN(subject);
        }
        String issuer = null;
        if (issuerName != null) {
            issuer = issuerName.getName("RFC1779");
            issuer = this.removeOIDStringsFromDN(issuer);
        }
        int basicConst = xsel.getBasicConstraints();
        if (subject != null) {
            request = new LDAPRequest(subject);
            if (basicConst > -2) {
                request.addRequestedAttribute(CROSS_CERT);
                request.addRequestedAttribute(CROSS_CERT_BIN);
                request.addRequestedAttribute(CA_CERT);
                request.addRequestedAttribute(CA_CERT_BIN);
                request.addRequestedAttribute(ARL);
                request.addRequestedAttribute(ARL_BIN);
                if (this.prefetchCRLs) {
                    request.addRequestedAttribute(CRL);
                    request.addRequestedAttribute(CRL_BIN);
                }
            }
            if (basicConst < 0) {
                request.addRequestedAttribute(USER_CERT);
                request.addRequestedAttribute(USER_CERT_BIN);
            }
            if (basicConst > -2) {
                certs.addAll(this.getMatchingCrossCerts(request, xsel, null));
                certs.addAll(this.getCertificates(request, CA_CERT, xsel));
                certs.addAll(this.getCertificates(request, CA_CERT_BIN, xsel));
            }
            if (basicConst < 0) {
                certs.addAll(this.getCertificates(request, USER_CERT, xsel));
                certs.addAll(this.getCertificates(request, USER_CERT_BIN, xsel));
            }
        } else {
            if (debug != null) {
                System.out.println("CERTPATH: LDAP type certstore, subject is null");
            }
            if (basicConst == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (issuer == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (issuer != null && basicConst > -2) {
            request = new LDAPRequest(issuer);
            request.addRequestedAttribute(CROSS_CERT);
            request.addRequestedAttribute(CROSS_CERT_BIN);
            request.addRequestedAttribute(CA_CERT);
            request.addRequestedAttribute(CA_CERT_BIN);
            request.addRequestedAttribute(ARL);
            request.addRequestedAttribute(ARL_BIN);
            if (this.prefetchCRLs) {
                request.addRequestedAttribute(CRL);
                request.addRequestedAttribute(CRL_BIN);
            }
            certs.addAll(this.getMatchingCrossCerts(request, null, xsel));
            certs.addAll(this.getCertificates(request, CA_CERT, xsel));
            certs.addAll(this.getCertificates(request, CA_CERT_BIN, xsel));
        }
        if (debug != null) {
            System.out.println("CERTPATH: LDAP type certstore returning certs size=" + certs.size());
        }
        return certs;
    }

    private Collection getCRLs(LDAPRequest request, String id, CRLSelector sel) throws CertStoreException {
        byte[][] encodedCRL;
        try {
            encodedCRL = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCRL.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CRLImpl> crls = new ArrayList<X509CRLImpl>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CRLImpl crl = new X509CRLImpl((InputStream)new ByteArrayInputStream(encodedCRL[i]));
                if (!sel.match((CRL)crl)) continue;
                crls.add(crl);
                continue;
            }
            catch (CRLException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad CRL data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCRL[i]) + " ]");
            }
        }
        return crls;
    }

    public synchronized Collection engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (debug != null) {
            System.out.println("CERTPATH: selector used to retrieve CRLs from LDAP CertStore: " + selector);
        }
        if (selector == null) {
            selector = new X509CRLSelector();
        }
        if (!(selector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector xsel = (X509CRLSelector)selector;
        HashSet crls = new HashSet();
        Collection<Object> issuerNames = new HashSet();
        X509Certificate certChecking = xsel.getCertificateChecking();
        if (certChecking != null) {
            if (certChecking instanceof X509CertImpl) {
                issuerNames.add(((X500Name)certChecking.getIssuerDN()).getName());
            } else {
                X500Principal issuer = certChecking.getIssuerX500Principal();
                issuerNames.add(issuer.getName("RFC2253"));
            }
        } else {
            issuerNames = xsel.getIssuerNames();
            if (issuerNames == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        for (Object nameObject : issuerNames) {
            LDAPRequest request;
            boolean empty;
            String issuerName;
            block20: {
                block19: {
                    if (nameObject instanceof byte[]) {
                        try {
                            X500Name issuer = new X500Name((byte[])nameObject);
                            issuerName = issuer.getName();
                            break block19;
                        }
                        catch (IOException e) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: non fatal error happens while getting CRLs from LDAP CertStore " + e);
                            continue;
                        }
                    }
                    issuerName = (String)nameObject;
                }
                Collection entryCRLs = Collections.EMPTY_LIST;
                empty = true;
                if (certChecking == null || certChecking.getBasicConstraints() != -1) {
                    request = new LDAPRequest(issuerName);
                    request.addRequestedAttribute(CROSS_CERT);
                    request.addRequestedAttribute(CROSS_CERT_BIN);
                    request.addRequestedAttribute(CA_CERT);
                    request.addRequestedAttribute(CA_CERT_BIN);
                    request.addRequestedAttribute(ARL);
                    request.addRequestedAttribute(ARL_BIN);
                    if (this.prefetchCRLs) {
                        request.addRequestedAttribute(CRL);
                        request.addRequestedAttribute(CRL_BIN);
                    }
                    try {
                        entryCRLs = this.getCRLs(request, ARL, xsel);
                        if (!entryCRLs.isEmpty()) {
                            crls.addAll(entryCRLs);
                            empty = false;
                        }
                        if (!(entryCRLs = this.getCRLs(request, ARL_BIN, xsel)).isEmpty()) {
                            crls.addAll(entryCRLs);
                            empty = false;
                        }
                        if (empty) {
                            this.prefetchCRLs = true;
                        }
                    }
                    catch (CertStoreException e) {
                        if (debug == null) break block20;
                        System.out.println("CERTPATH: error getting CRLs from LDAP CertStore " + e);
                        e.printStackTrace();
                    }
                }
            }
            if (!empty && certChecking != null) continue;
            request = new LDAPRequest(issuerName);
            request.addRequestedAttribute(CRL);
            request.addRequestedAttribute(CRL_BIN);
            request.addRequestedAttribute(ARL);
            request.addRequestedAttribute(ARL_BIN);
            crls.addAll(this.getCRLs(request, CRL, xsel));
            crls.addAll(this.getCRLs(request, CRL_BIN, xsel));
        }
        return crls;
    }

    private String removeOIDStringsFromDN(String inputDN) {
        if (inputDN.length() == 0) {
            return inputDN;
        }
        while (inputDN.length() != 0 && inputDN.charAt(0) == ' ') {
            inputDN = inputDN.substring(1);
        }
        if (inputDN.length() == 0) {
            return inputDN;
        }
        if (inputDN.indexOf("OID.") == 0) {
            inputDN = inputDN.substring(4);
        }
        int indexOfNextOID = 0;
        while ((indexOfNextOID = inputDN.indexOf("OID.", indexOfNextOID + 1)) != -1) {
            int tempIndex = indexOfNextOID - 1;
            while (inputDN.charAt(tempIndex) == ' ') {
                --tempIndex;
            }
            if (inputDN.charAt(tempIndex) != ',') continue;
            StringBuffer myStringBuffer = new StringBuffer(inputDN);
            myStringBuffer.delete(indexOfNextOID, indexOfNextOID + 4);
            inputDN = new String(myStringBuffer);
        }
        return inputDN;
    }

    static {
        String lifetime = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(LDAPCertStoreImpl.PROP_LIFETIME);
            }
        });
        if (lifetime != null) {
            try {
                LIFETIME = Integer.parseInt(lifetime);
            }
            catch (NumberFormatException ex) {
                LIFETIME = 86400;
            }
        } else {
            LIFETIME = 86400;
        }
        debug = Debug.getInstance((String)"certpath");
    }

    private class LDAPRequest {
        private final String name;
        private Map valueMap;
        private final ArrayList requestedAttributes;
        private Attributes attrs;

        LDAPRequest(String name) {
            this.name = name;
            this.requestedAttributes = new ArrayList(5);
        }

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String attrId) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(attrId);
        }

        byte[][] getValues(String attrId) throws NamingException {
            String key = this.name + attrId;
            Object values = null;
            values = (byte[][])LDAPCertStoreImpl.this.valueCache.get(key);
            if (values != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: got matched values from LDAP CertStore cache, key=" + key);
                }
                return values;
            }
            if (this.valueMap != null) {
                values = (byte[][])this.valueMap.get(attrId);
            } else {
                this.valueMap = new HashMap(5);
            }
            if (values != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: got values from LDAP CertStore local memory");
                }
                return values;
            }
            if (this.attrs == null) {
                String[] attrIds = new String[this.requestedAttributes.size()];
                this.requestedAttributes.toArray(attrIds);
                boolean communicationExceptionOccurred = true;
                while (communicationExceptionOccurred) {
                    if (debug != null) {
                        System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Entering getAttributes() retry loop");
                    }
                    try {
                        this.attrs = LDAPCertStoreImpl.this.ctx.getAttributes(this.name, attrIds);
                        communicationExceptionOccurred = false;
                        LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter = 0;
                        if (debug == null) continue;
                        System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  The getAttributes() call succeeded.");
                        System.out.println("                                                 Setting consecutiveFailedGetAttributeAttemptsCounter = 0");
                        System.out.println("                                                 Setting communicationExceptionOccurred = false");
                    }
                    catch (CommunicationException commEx) {
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  The getAttributes() call failed with the following CommunicationException.");
                            System.out.println("          This may be due to the LDAP server dropping the connection due to inactivity.");
                            System.out.println(commEx.toString());
                            commEx.printStackTrace();
                        }
                        communicationExceptionOccurred = true;
                        LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter++;
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Setting consecutiveFailedGetAttributeAttemptsCounter = " + LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter);
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Setting communicationExceptionOccurred = true");
                        }
                        if (LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter < 2) {
                            if (debug != null) {
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  We have not yet exceeded the MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS ");
                            }
                            try {
                                if (debug != null) {
                                    System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Attempting to re-initialize this LDAPCertStore object (and the DirContext).");
                                }
                                LDAPCertStoreImpl.this.init(LDAPCertStoreImpl.this.savedLDAPCertStoreParameters);
                                if (debug == null) continue;
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Re-initialization succeeded following the CommunicationException");
                            }
                            catch (Exception unexpectedException) {
                                if (debug == null) continue;
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Re-initialization failed.  The following exception was thrown:");
                                System.out.println(unexpectedException.toString());
                                unexpectedException.printStackTrace();
                            }
                            continue;
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  We have exceeded the MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS!!");
                            System.out.println("                                                 Giving up and returning null attributes (same as original implementation)");
                        }
                        this.attrs = null;
                        return EMPTY_VALUES;
                    }
                    catch (NamingException nex) {
                        if (debug != null) {
                            System.out.println("CERTPATH: failed to get attrs of LDAP context");
                            nex.printStackTrace();
                        }
                        this.attrs = null;
                        return EMPTY_VALUES;
                    }
                }
                if (debug != null) {
                    System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Exiting getAttributes() retry loop");
                }
            }
            for (String id : this.requestedAttributes) {
                Attribute attr = this.attrs.get(id);
                if (attr != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH: retrieved the attribute with id " + id);
                    }
                    byte[][] temp = new byte[attr.size()][];
                    for (int j = 0; j < attr.size(); ++j) {
                        Object obj = attr.get(j);
                        if (obj instanceof byte[]) {
                            temp[j] = (byte[])obj;
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("CERTPATH: attribute with id " + id + " has non byte[] value");
                    }
                    this.valueMap.put(id, temp);
                    LDAPCertStoreImpl.this.valueCache.put(this.name + id, temp);
                    if (debug != null) {
                        System.out.println("CERTPATH: put the retrieved bytes into value map, key=" + this.name + id);
                    }
                    if (!id.equals(attrId)) continue;
                    if (debug != null) {
                        System.out.println("CERTPATH: find the values for attribute " + this.name + "with id " + id);
                    }
                    values = temp;
                    continue;
                }
                this.valueMap.put(id, EMPTY_VALUES);
                LDAPCertStoreImpl.this.valueCache.put(this.name + id, EMPTY_VALUES);
            }
            if (values == null) {
                return EMPTY_VALUES;
            }
            return values;
        }
    }
}

