/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class CRLReason {
    private int code;
    public static final CRLReason UNSPECIFIED = new CRLReason(0);
    public static final CRLReason KEY_COMPROMISE = new CRLReason(1);
    public static final CRLReason CA_COMPROMISE = new CRLReason(2);
    public static final CRLReason AFFILIATION_CHANGED = new CRLReason(3);
    public static final CRLReason SUPERSEDED = new CRLReason(4);
    public static final CRLReason CESSATION_OF_OPERATION = new CRLReason(5);
    public static final CRLReason CERTIFICATE_HOLD = new CRLReason(6);
    public static final CRLReason REMOVE_FROM_CRL = new CRLReason(8);
    public static final CRLReason PRIVILEGE_WITHDRAWN = new CRLReason(9);
    public static final CRLReason AA_COMPROMISE = new CRLReason(10);

    private CRLReason(int code) {
        this.code = code;
    }

    public byte[] encode() throws IOException {
        DerOutputStream dos = new DerOutputStream();
        dos.putEnumerated(BigInteger.valueOf(this.code));
        return dos.toByteArray();
    }

    public String toString() {
        if (this.equals(UNSPECIFIED)) {
            return "CRLReason: unspecified";
        }
        if (this.equals(KEY_COMPROMISE)) {
            return "CRLReason: key compromise";
        }
        if (this.equals(CA_COMPROMISE)) {
            return "CRLReason: ca compromise";
        }
        if (this.equals(AFFILIATION_CHANGED)) {
            return "CRLReason: affiliation changed";
        }
        if (this.equals(SUPERSEDED)) {
            return "CRLReason: superseded";
        }
        if (this.equals(CESSATION_OF_OPERATION)) {
            return "CRLReason: cessation of operation";
        }
        if (this.equals(CERTIFICATE_HOLD)) {
            return "CRLReason: certificate hold";
        }
        if (this.equals(REMOVE_FROM_CRL)) {
            return "CRLReason: remove from crl";
        }
        if (this.equals(PRIVILEGE_WITHDRAWN)) {
            return "CRLReason: privilege withdrown";
        }
        if (this.equals(AA_COMPROMISE)) {
            return "CRLReason: aa compromise";
        }
        return null;
    }
}

