/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.DisplayText;
import com.ibm.security.x509.NoticeReference;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UserNotice
implements Qualifier,
Cloneable {
    private ObjectIdentifier oid = PKIXExtensions.UserNotice_Id;
    private NoticeReference noticeRef;
    private DisplayText explicitText;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.UserNotice";
    private volatile int cachedHashVal = 0;

    public UserNotice(NoticeReference noticeRef, DisplayText explicitText) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "UserNotice", noticeRef, explicitText);
            debug.exit(16384L, className, "UserNotice");
        }
        this.noticeRef = noticeRef;
        this.explicitText = explicitText;
    }

    public UserNotice(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UserNotice", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "UserNotice");
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.noticeRef != null) {
            this.noticeRef.encode(bytes);
        }
        if (this.explicitText != null) {
            this.explicitText.encode(bytes);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public NoticeReference getNoticeReference() {
        if (debug != null) {
            debug.entry(16384L, className, "getNoticeReference");
            debug.exit(16384L, (Object)className, "getNoticeReference", this.noticeRef);
        }
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        if (debug != null) {
            debug.entry(16384L, className, "getExplicitText");
            debug.exit(16384L, (Object)className, "getExplicitText", this.explicitText);
        }
        return this.explicitText;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKIXExtensions.UserNotice_Id);
        }
        return PKIXExtensions.UserNotice_Id;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "UserNotice");
        }
        return "UserNotice";
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            UserNotice result = new UserNotice(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "UserNotice: [";
        out = out + "\r\n\tObjectIdentifier: " + this.oid;
        out = out + "\r\n\tNoticeReference: ";
        out = this.noticeRef != null ? out + this.noticeRef.toString() : out + "null";
        out = out + "\r\n\tExplicitText: ";
        out = this.explicitText != null ? out + this.explicitText.toString() : out + "null";
        out = out + "\r\n]";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof UserNotice)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((UserNotice)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "UserNotice parsing error");
            }
            throw new IOException("UserNotice parsing error");
        }
        if (encoding.length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "empty User notice");
            }
            return;
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() == 48) {
            this.noticeRef = new NoticeReference(der.toByteArray());
            if (encoding.getData().available() != 0) {
                der = encoding.getData().getDerValue();
            } else {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_1");
                }
                return;
            }
        }
        this.explicitText = new DisplayText(der.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "decode_2");
        }
    }
}

