/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PolicyQualifierInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyInformation
implements Cloneable {
    private ObjectIdentifier certPolicyId;
    private Vector<PolicyQualifierInfo> policyQualifiers;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyInformation";
    private volatile int cachedHashVal = 0;

    public PolicyInformation(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyInformation", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyInformation");
        }
    }

    public PolicyInformation(ObjectIdentifier policyId, Vector<PolicyQualifierInfo> qualifiers) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyInformation", policyId, qualifiers);
        }
        this.certPolicyId = policyId;
        if (qualifiers != null && qualifiers.size() > 0) {
            Vector<PolicyQualifierInfo> vec = new Vector<PolicyQualifierInfo>();
            for (int i = 0; i < qualifiers.size(); ++i) {
                PolicyQualifierInfo info = qualifiers.get(i);
                vec.addElement(info);
            }
            this.policyQualifiers = vec;
        } else {
            this.policyQualifiers = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyInformation");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            PolicyInformation result = new PolicyInformation(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream derout = new DerOutputStream();
        DerOutputStream seq = new DerOutputStream();
        seq.putOID(this.certPolicyId);
        if (this.policyQualifiers != null && this.policyQualifiers.size() > 0) {
            DerOutputStream os = new DerOutputStream();
            for (int i = 0; i < this.policyQualifiers.size(); ++i) {
                this.policyQualifiers.elementAt(i).encode(os);
            }
            seq.write((byte)48, os);
        }
        derout.write((byte)48, seq);
        out.write(derout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoding for PolicyInformation.");
            }
            throw new IOException("Invalid encoding for PolicyInformation.");
        }
        this.certPolicyId = encoding.getData().getOID();
        this.policyQualifiers = null;
        if (encoding.getData().available() != 0) {
            DerValue derVal = encoding.getData().getDerValue();
            if (derVal.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Invalid encoding of PolicyInformation.");
                }
                throw new IOException("Invalid encoding of PolicyInformation.");
            }
            this.policyQualifiers = new Vector();
            while (derVal.getData().available() != 0) {
                DerValue opt = derVal.getData().getDerValue();
                PolicyQualifierInfo info = new PolicyQualifierInfo(opt.toByteArray());
                this.policyQualifiers.addElement(info);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof PolicyInformation)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((PolicyInformation)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getPolicyIdentifier() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPolicyIdentifier");
            debug.exit(16384L, (Object)className, "getPolicyIdentifier", this.certPolicyId);
        }
        return this.certPolicyId;
    }

    public Vector getPolicyQualifiers() {
        if (debug != null) {
            debug.entry(16384L, className, "getPolicyQualifiers");
        }
        if (this.policyQualifiers == null || this.policyQualifiers.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPolicyQualifiers_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPolicyQualifiers_2", (Vector)this.policyQualifiers.clone());
        }
        return (Vector)this.policyQualifiers.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "\r\nPolicyInformation: [\r\n\tCertPolicyId: ";
        s = this.certPolicyId != null ? s + this.certPolicyId.toString() : s + "null";
        s = s + "\r\n\tPolicyQualifiers: ";
        s = this.policyQualifiers != null ? s + this.policyQualifiers.toString() : s + "null";
        s = s + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }
}

