/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HoldInstructionCodeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.HoldInstructionCode";
    public static final String NAME = "HoldInstructionCode";
    public static final String NUMBER = "value";
    private ObjectIdentifier holdInstructionCode;
    private static final int[] None_data = new int[]{1, 2, 840, 10040, 2, 1};
    private static final int[] CallIssuer_data = new int[]{1, 2, 840, 10040, 2, 2};
    private static final int[] Reject_data = new int[]{1, 2, 840, 10040, 2, 3};
    public static ObjectIdentifier HoldInstructionNone_Id;
    public static ObjectIdentifier HoldInstructionCallIssuer_Id;
    public static ObjectIdentifier HoldInstructionReject_Id;
    private static Debug debug;
    private static String className;

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.holdInstructionCode == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        os.putOID(this.holdInstructionCode);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public HoldInstructionCodeExtension(ObjectIdentifier holdInstructionCode) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "HoldInstructionCodeExtension", holdInstructionCode);
        }
        this.setHoldInstructionCode(holdInstructionCode);
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "HoldInstructionCodeExtension");
        }
    }

    public HoldInstructionCodeExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "HoldInstructionCodeExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.setHoldInstructionCode(val.getOID());
        if (debug != null) {
            debug.exit(16384L, className, "HoldInstructionCodeExtension");
        }
    }

    private void setHoldInstructionCode(ObjectIdentifier holdInstructionCode) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHoldInstructionCode", holdInstructionCode);
        }
        if (holdInstructionCode == null) {
            if (debug != null) {
                debug.text(8192L, className, "setHoldInstructionCode", "holdInstructionCode not specified.");
            }
            throw new IllegalArgumentException("holdInstructionCode not specified.");
        }
        if (!(holdInstructionCode.equals(HoldInstructionNone_Id) || holdInstructionCode.equals(HoldInstructionCallIssuer_Id) || holdInstructionCode.equals(HoldInstructionReject_Id))) {
            if (debug != null) {
                debug.text(8192L, className, "setHoldInstructionCode", "holdInstructionCode OID " + holdInstructionCode.toString() + " is not valid.");
            }
            throw new IllegalArgumentException("holdInstructionCode OID " + holdInstructionCode.toString() + " is not valid.");
        }
        this.holdInstructionCode = holdInstructionCode;
        if (debug != null) {
            debug.exit(8192L, className, "setHoldInstructionCode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof ObjectIdentifier)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type ObjectIdentifier.");
                }
                throw new IOException("Attribute must be of type ObjectIdentifier.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.setHoldInstructionCode((ObjectIdentifier)obj);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.holdInstructionCode == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.holdInstructionCode);
            }
            return this.holdInstructionCode;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.holdInstructionCode = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "Hold Instruction Code: ";
        s = this.holdInstructionCode == null ? s + "null" : (this.isNone() ? s + "None" : (this.isCallIssuer() ? s + "CallIssuer" : (this.isReject() ? s + "Reject" : s + this.holdInstructionCode.toString())));
        s = s + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean isNone() {
        if (debug != null) {
            debug.entry(16384L, className, "isNone");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isNone_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isNone_2", this.holdInstructionCode.equals(HoldInstructionNone_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionNone_Id);
    }

    public boolean isCallIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "isCallIssuer");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isCallIssuer_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isCallIssuer_2", this.holdInstructionCode.equals(HoldInstructionCallIssuer_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionCallIssuer_Id);
    }

    public boolean isReject() {
        if (debug != null) {
            debug.entry(16384L, className, "isReject");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isReject_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isReject_2", this.holdInstructionCode.equals(HoldInstructionReject_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionReject_Id);
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.HoldInstructionCodeExtension";
        try {
            HoldInstructionNone_Id = new ObjectIdentifier(None_data);
            HoldInstructionCallIssuer_Id = new ObjectIdentifier(CallIssuer_data);
            HoldInstructionReject_Id = new ObjectIdentifier(Reject_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

