/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import java.io.IOException;

public final class GeneralName
implements GeneralNameInterface {
    private GeneralNameInterface name = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralName";

    public GeneralName(GeneralNameInterface name) {
        if (debug != null) {
            debug.entry(16384L, className, "GeneralName");
            debug.exit(16384L, className, "GeneralName");
        }
        this.name = name;
    }

    public GeneralName(DerValue encName) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralName", encName);
        }
        short tag = (byte)(encName.getTag() & 0x1F);
        switch (tag) {
            case 0: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new OtherName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of Other-Name");
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new RFC822Name(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of RFC822 name");
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new DNSName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of DNS name");
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new URIName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of URI");
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    this.name = new IPAddressName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of IP address");
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)6);
                    this.name = new OIDName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of OID name");
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    this.name = new X500Name(encName.getData());
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of Directory name");
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new EDIPartyName(encName);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of EDI name");
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Unrecognized GeneralName tag, (" + tag + ")");
                }
                throw new IOException("Unrecognized GeneralName tag, (" + tag + ")");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralName");
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", this.name.getType());
        }
        return this.name.getType();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.name.toString());
        }
        return this.name.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneralName)) {
            return false;
        }
        GeneralNameInterface otherGNI = ((GeneralName)other).name;
        try {
            return this.name.constrains(otherGNI) == 0;
        }
        catch (UnsupportedOperationException ioe) {
            return false;
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        this.name.encode(tmp);
        int nameType = this.name.getType();
        if (nameType == 4) {
            out.write(DerValue.createTag((byte)-128, true, (byte)nameType), tmp);
        } else if (nameType == 0 || nameType == 3 || nameType == 5) {
            out.writeImplicit(DerValue.createTag((byte)-128, true, (byte)nameType), tmp);
        } else {
            out.writeImplicit(DerValue.createTag((byte)-128, false, (byte)nameType), tmp);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        if (this.name != null) {
            return this.name.constrains(inputName);
        }
        throw new UnsupportedOperationException("The name of this GeneralName is null");
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        if (this.name != null) {
            return this.name.subtreeDepth();
        }
        throw new UnsupportedOperationException("The name of this GeneralName is null");
    }
}

