/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateX509Key
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.key";
    public static final String NAME = "key";
    public static final String KEY = "value";
    private PublicKey key;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateX509Key";

    public CertificateX509Key(PublicKey key) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", key);
            debug.exit(16384L, className, "CertificateX509Key");
        }
        this.key = key;
    }

    public CertificateX509Key(PublicKey key, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", key, provider);
            debug.exit(16384L, className, "CertificateX509Key");
        }
        this.key = key;
        if (provider != null) {
            this.provider = new String(provider);
        }
    }

    public CertificateX509Key(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", in);
        }
        DerValue val = in.getDerValue();
        this.key = X509Key.parse(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(DerInputStream in, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", in, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        DerValue val = in.getDerValue();
        this.key = X509Key.parse(val, provider);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", in);
        }
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(InputStream in, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", in, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val, provider);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.key == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", this.key.toString());
        }
        return this.key.toString();
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.write(this.key.getEncoded());
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!name.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = (PublicKey)obj;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.key);
            }
            return this.key;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(KEY);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, className, "NAME");
        }
        return NAME;
    }
}

