/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateAlgorithmId
implements CertAttrSet<String> {
    private AlgorithmId algId;
    public static final String IDENT = "x509.info.algorithmID";
    public static final String NAME = "algorithmID";
    public static final String ALGORITHM = "algorithm";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateAlgorithmId";

    public CertificateAlgorithmId(AlgorithmId algId) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", algId);
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
        this.algId = algId;
    }

    public CertificateAlgorithmId(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", in);
        }
        DerValue val = in.getDerValue();
        this.algId = AlgorithmId.parse(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
    }

    public CertificateAlgorithmId(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateAlgorithmId", in);
        }
        DerValue val = new DerValue(in);
        this.algId = AlgorithmId.parse(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateAlgorithmId");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n");
        }
        return this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n";
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        this.algId.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof AlgorithmId)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type AlgorithmId.");
            }
            throw new IOException("Attribute must be of type AlgorithmId.");
        }
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = (AlgorithmId)obj;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.algId);
            }
            return this.algId;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ALGORITHM);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.algId.getOID());
        }
        return this.algId.getOID();
    }
}

