/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRLReasonCodeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "CRLReasonCode";
    public static final String REASON = "reason";
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFLIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private int reasonCode = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLReasonCodeExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeThis");
        }
        if (this.reasonCode == -1) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(16384L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putEnumerated(BigInteger.valueOf(this.reasonCode));
        this.extensionValue = dos.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "encodeThis_2");
        }
    }

    public CRLReasonCodeExtension(int reason) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLReasonCodeExtension", new Integer(reason));
        }
        if (reason > 10 || reason == 7 || reason < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code specified");
            }
            throw new IOException("Illegal reason code specified");
        }
        this.reasonCode = reason;
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    public CRLReasonCodeExtension(boolean critical, int reason) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLReasonCodeExtension", new Boolean(critical), new Integer(reason));
        }
        if (reason > 10 || reason == 7 || reason < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code specified");
            }
            throw new IOException("Illegal reason code specified");
        }
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        this.reasonCode = reason;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    public CRLReasonCodeExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLReasonCodeExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.reasonCode = val.getEnumerated().intValue();
        if (this.reasonCode > 10 || this.reasonCode == 7 || this.reasonCode < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code parsed");
            }
            throw new IOException("Illegal reason code parsed");
        }
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Integer.");
            }
            throw new IOException("Attribute must be of type Integer.");
        }
        if (name.equalsIgnoreCase(REASON)) {
            this.reasonCode = (Integer)obj;
            if (this.reasonCode > 10 || this.reasonCode == 7 || this.reasonCode < 0) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Illegal reason code specified");
                }
                throw new IOException("Illegal reason code specified");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Name not supported by CRLReasonCodeExtension");
            }
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(REASON)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", new Integer(this.reasonCode));
            }
            return new Integer(this.reasonCode);
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Name not supported by CRLReasonCodeExtension");
        }
        throw new IOException("Name not supported by CRLReasonCodeExtension");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(REASON)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Name not supported by CRLReasonCodeExtension");
            }
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = -1;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "    Reason Code: ";
        switch (this.reasonCode) {
            case 0: {
                s = s + "Unspecified";
                break;
            }
            case 1: {
                s = s + "Key Compromise";
                break;
            }
            case 2: {
                s = s + "CA Compromise";
                break;
            }
            case 3: {
                s = s + "Affiliation Changed";
                break;
            }
            case 4: {
                s = s + "Superseded";
                break;
            }
            case 5: {
                s = s + "Cessation Of Operation";
                break;
            }
            case 6: {
                s = s + "Certificate Hold";
                break;
            }
            case 8: {
                s = s + "Remove from CRL";
                break;
            }
            case 9: {
                s = s + "Privilege Withdrawn";
                break;
            }
            case 10: {
                s = s + "AA Compromise";
                break;
            }
            default: {
                s = s + "Unrecognized reason code";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ReasonCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(REASON);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

