/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs8;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class EncryptedPrivateKeyInfo
extends PKCSDerObject {
    private AlgorithmId algid;
    private byte[] encryptedKey;
    private byte[] encoded;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs8.EncryptedPrivateKeyInfo";
    private volatile int cachedHashVal = 0;

    public EncryptedPrivateKeyInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", (Object)der);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", der, provider);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(AlgorithmId alg, byte[] encryptedKey) {
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", alg, encryptedKey);
        }
        this.setEncryptionAlgorithm(alg);
        this.setEncryptionKey(encryptedKey);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(AlgorithmId alg, byte[] encryptedKey, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{alg, encryptedKey, provider};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", parms);
        }
        this.setEncryptionAlgorithm(alg);
        this.setEncryptionKey(encryptedKey);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(char[] passwd, PrivateKeyInfo pki, String digest, String cryptoAlg) throws PKCSException, IOException {
        this(passwd, pki, digest, cryptoAlg, null);
    }

    public EncryptedPrivateKeyInfo(char[] passwd, PrivateKeyInfo pki, String digest, String cryptoAlg, String provider) throws PKCSException, IOException {
        super(provider);
        AlgorithmId algid;
        AlgorithmId tmpAlgId;
        byte[] eKeyInfo;
        Cipher cipher;
        SecretKey secretkey;
        if (debug != null) {
            Object[] parms = new Object[]{passwd, pki, digest, cryptoAlg, provider};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", parms);
        }
        if (passwd == null || passwd.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "EncryptedPrivateKeyInfo", "passwd not specified.");
            }
            throw new IllegalArgumentException("passwd not specified.");
        }
        if (pki == null) {
            if (debug != null) {
                debug.text(16384L, className, "EncryptedPrivateKeyInfo", "pki not specified.");
            }
            throw new IllegalArgumentException("pki not specified.");
        }
        String cipherName = "PBEWith" + digest + "And" + cryptoAlg;
        byte[] pkikey = pki.getKeyBytes();
        PKCSAttributes pkiattributes = pki.getAttributes();
        AlgorithmId pkialgid = pki.getAlgorithmId();
        DerOutputStream derout = new DerOutputStream();
        PrivateKeyInfo.encode(derout, pkialgid, pkikey, pkiattributes);
        byte[] keyInfo = derout.toByteArray();
        PBEKeySpec keySpec = new PBEKeySpec(passwd);
        try {
            SecretKeyFactory keyFact = this.provider != null ? SecretKeyFactory.getInstance(cipherName, this.provider) : SecretKeyFactory.getInstance(cipherName);
            secretkey = keyFact.generateSecret(keySpec);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", e2);
            }
            throw new PKCSException(e2, "Error encrypting private key (" + e2.toString() + ")");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(cipherName, this.provider) : Cipher.getInstance(cipherName);
            cipher.init(1, secretkey);
            eKeyInfo = cipher.doFinal(keyInfo);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", e2);
            }
            throw new PKCSException(e2, "Error encrypting private key (" + e2.toString() + ")");
        }
        AlgorithmParameters params = cipher.getParameters();
        byte[] encodedParms = null;
        if (params != null) {
            encodedParms = params.getEncoded();
        }
        try {
            tmpAlgId = AlgorithmId.get(cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", e);
            }
            throw new PKCSException(e, "Unsupported password-based encryption algorithm: " + cipher.getAlgorithm());
        }
        if (encodedParms != null) {
            ObjectIdentifier oid = tmpAlgId.getOID();
            algid = new AlgorithmId(oid, encodedParms, this.provider);
        } else {
            algid = tmpAlgId;
        }
        this.setEncryptionAlgorithm(algid);
        this.setEncryptionKey(eKeyInfo);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", parms);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    private void setEncryptionAlgorithm(AlgorithmId alg) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "SetEncryptionAlgorithm", alg);
            debug.exit(8192L, className, "SetEncryptionAlgorithm");
        }
        this.algid = alg;
    }

    private void setEncryptionKey(byte[] encryptedKey) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "SetEncryptionKey", (Object)encryptedKey);
        }
        this.encryptedKey = (byte[])encryptedKey.clone();
        if (debug != null) {
            debug.exit(8192L, className, "SetEncryptionKey");
        }
    }

    public Object clone() {
        EncryptedPrivateKeyInfo result = null;
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            result = new EncryptedPrivateKeyInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.algid.encode(bytes);
        bytes.putOctetString(this.encryptedKey);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof EncryptedPrivateKeyInfo) {
            result = this.equals((EncryptedPrivateKeyInfo)other);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", result);
            }
            return result;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getAlgorithmId");
                debug.exit(16384L, (Object)className, "getAlgorithmId_1", new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAlgorithmId_2", new AlgorithmId(this.algid.getOID(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.provider);
        }
    }

    public byte[] getEncryptedData() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedData");
        }
        byte[] result = (byte[])this.encryptedKey.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedData", result);
        }
        return result;
    }

    public byte[] decrypt(char[] passwd) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)passwd);
        }
        String algname = this.algid.getName();
        byte[] encodedParams = this.algid.getParameters();
        DerValue derParams = new DerValue(encodedParams);
        DerValue[] seq = new DerValue[]{derParams.getData().getDerValue(), derParams.getData().getDerValue()};
        byte[] salt = seq[0].getOctetString();
        int iCount = seq[1].getInteger().intValue();
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iCount);
        try {
            AlgorithmParameters params = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
            params.init(paramSpec);
            PBEKeySpec keySpec = new PBEKeySpec(passwd);
            SecretKeyFactory keyFact = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
            SecretKey sKey = keyFact.generateSecret(keySpec);
            Cipher cipher = this.provider != null ? Cipher.getInstance(algname, this.provider) : Cipher.getInstance(algname);
            cipher.init(2, (Key)sKey, params);
            byte[] result = cipher.doFinal(this.encryptedKey);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Private key decryption error: (" + e.toString() + ")");
        }
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS #8 EncryptedPrivateKeyInfo:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + "\talgorithm identifier: " + this.algid;
        out = out + "\r\n\tencrypted key:\r\n" + hexDump.encode(this.encryptedKey);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedPrivateKeyInfo parsing error.");
            }
            throw new IOException("EncryptedPrivateKeyInfo parsing error.");
        }
        this.algid = AlgorithmId.parse(encoding.getData().getDerValue());
        this.encryptedKey = encoding.getData().getOctetString();
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedPrivateKeyInfo parsing error.  Field overrun.");
            }
            throw new IOException("EncryptedPrivateKeyInfo parsing error.  Field overrun.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(EncryptedPrivateKeyInfo other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

