/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class SignedData
extends Content
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    protected static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    protected static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private BigInteger version;
    private AlgorithmId[] digestAlgorithms;
    private EncapsulatedContentInfo encapsulatedContentInfo;
    private Certificate[] certs;
    private CRL[] crls;
    private SignerInfo[] signers;
    private SignerInfo[] orig_signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignedData";

    public SignedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            if (der != null) {
                debug.entry(16384L, (Object)className, "SignedData", (Object)der);
            } else {
                debug.entry(16384L, className, "SignedData");
            }
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            if (der != null && provider != null) {
                debug.entry(16384L, className, "SignedData", der, provider);
            } else {
                debug.entry(16384L, className, "SignedData");
            }
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certs, CRL[] crls) throws IOException {
        if (debug != null) {
            if (certs != null && crls != null) {
                debug.entry(16384L, className, "SignedData", certs, crls);
            } else {
                debug.entry(16384L, className, "SignedData");
            }
        }
        this.addCertificate(certs);
        this.addCRL(crls);
        byte[] content = null;
        ContentInfo contentInfo = new ContentInfo(PKCSOID.DATA_OID, content);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certs, CRL[] crls, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{certs, crls, provider};
            debug.entry(16384L, (Object)className, "SignedData", parms);
        }
        this.addCertificate(certs);
        this.addCRL(crls);
        byte[] content = null;
        ContentInfo contentInfo = new ContentInfo(PKCSOID.DATA_OID, content, provider);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo, provider);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(AlgorithmId[] digestAlgorithms, EncapsulatedContentInfo eci, Certificate[] certsIn, CRL[] crlsIn, SignerInfo[] signersIn) {
        if (debug != null) {
            Object[] parms = new Object[]{digestAlgorithms, eci, certsIn, crlsIn, signersIn};
            debug.entry(16384L, (Object)className, "SignedData", parms);
        }
        if (digestAlgorithms != null) {
            this.digestAlgorithms = (AlgorithmId[])digestAlgorithms.clone();
        }
        this.encapsulatedContentInfo = eci;
        this.addCertificate(certsIn);
        this.addCRL(crlsIn);
        if (signersIn != null) {
            this.signers = (SignerInfo[])signersIn.clone();
            this.orig_signers = this.signers;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(AlgorithmId[] digestAlgorithms, EncapsulatedContentInfo eci, Certificate[] certsIn, CRL[] crlsIn, SignerInfo[] signersIn, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{digestAlgorithms, eci, certsIn, crlsIn, signersIn, provider};
            debug.entry(16384L, (Object)className, "SignedData", parms);
        }
        if (digestAlgorithms != null) {
            this.digestAlgorithms = (AlgorithmId[])digestAlgorithms.clone();
        }
        this.encapsulatedContentInfo = eci;
        this.addCertificate(certsIn);
        this.addCRL(crlsIn);
        if (signersIn != null) {
            this.signers = (SignerInfo[])signersIn.clone();
            this.orig_signers = this.signers;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate cert, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, boolean signatureOnly) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(cert, contentInfo, digestSignatureAlgorithm, privateKey, signatureOnly, null);
        if (debug != null) {
            Object[] parms = new Object[]{cert, contentInfo, digestSignatureAlgorithm, privateKey, new Boolean(signatureOnly)};
            debug.entry(16384L, (Object)className, "SignedData", parms);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate cert, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, boolean signatureOnly, String provider) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{cert, contentInfo, digestSignatureAlgorithm, privateKey, new Boolean(signatureOnly), provider};
            debug.entry(16384L, (Object)className, "SignedData", parms);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "ContentInfo must be specified.");
            }
            throw new IllegalArgumentException("ContentInfo must be specified.");
        }
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        String signatureAlgorithm = PKCS7.getSignatureAlgorithm(digestSignatureAlgorithm);
        this.encapsulatedContentInfo = provider == null ? new EncapsulatedContentInfo(contentInfo) : new EncapsulatedContentInfo(contentInfo, provider);
        if (signatureOnly) {
            this.addSignerSignatureOnly(cert, privateKey, digestSignatureAlgorithm);
        } else {
            this.addSigner(cert, privateKey, digestSignatureAlgorithm, null, null);
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certs, CRL[] crls, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey[] privateKeys, PKCSAttributes signedAttribs, PKCSAttributes unsignedAttribs, boolean signatureOnly) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(certs, crls, contentInfo, digestSignatureAlgorithm, privateKeys, signedAttribs, unsignedAttribs, signatureOnly, null);
        if (debug != null) {
            Object[] parms = new Object[]{certs, crls, contentInfo, digestSignatureAlgorithm, privateKeys, signedAttribs, unsignedAttribs, new Boolean(signatureOnly)};
            debug.entry(16384L, (Object)className, "SignedData", parms);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certs, CRL[] crls, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey[] privateKeys, PKCSAttributes signedAttribs, PKCSAttributes unsignedAttribs, boolean signatureOnly, String provider) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{certs, crls, contentInfo, digestSignatureAlgorithm, privateKeys, signedAttribs, unsignedAttribs, new Boolean(signatureOnly)};
            debug.entry(16384L, (Object)className, "SignedData", parms);
        }
        if (certs == null || certs.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "One or more certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more certificates must be specified.");
        }
        if (privateKeys == null || privateKeys.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "One or more private keys must be specified.");
            }
            throw new IllegalArgumentException("One or more private keys must be specified.");
        }
        if (privateKeys.length != certs.length) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Length of certificate array must match the length of the private key array.");
            }
            throw new IllegalArgumentException("Length of certificate array must match the length of the private key array.");
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "ContentInfo must be specified.");
            }
            throw new IllegalArgumentException("ContentInfo must be specified.");
        }
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        this.addDigestAlgorithm(digestAlgorithm);
        this.addCertificate(certs);
        this.addCRL(crls);
        this.encapsulatedContentInfo = provider == null ? new EncapsulatedContentInfo(contentInfo) : new EncapsulatedContentInfo(contentInfo, provider);
        for (int i = 0; i < certs.length; ++i) {
            PKCSAttributes newSignedAttribs = null;
            if (signedAttribs != null) {
                newSignedAttribs = (PKCSAttributes)signedAttribs.clone();
            }
            if (signatureOnly) {
                this.addSignerSignatureOnly(certs[i], privateKeys[i], digestSignatureAlgorithm);
                continue;
            }
            this.addSigner(certs[i], privateKeys[i], digestSignatureAlgorithm, newSignedAttribs, unsignedAttribs);
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            if (filename != null) {
                debug.entry(16384L, className, "SignedData", filename, new Boolean(base64));
            } else {
                debug.entry(16384L, className, "SignedData");
            }
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SignedData", parms);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SignedData result = new SignedData(derout.toByteArray(), this.provider);
            if (this.orig_signers == null) {
                if (this.signers != null) {
                    result.orig_signers = (SignerInfo[])this.signers.clone();
                }
            } else {
                result.orig_signers = (SignerInfo[])this.orig_signers.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNED_DATA_OID);
        }
        return PKCSOID.SIGNED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithms() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithms");
        }
        if (this.digestAlgorithms == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithms_1", null);
            }
            return null;
        }
        AlgorithmId[] newdigestAlgorithms = new AlgorithmId[this.digestAlgorithms.length];
        for (int i = 0; i < this.digestAlgorithms.length; ++i) {
            try {
                newdigestAlgorithms[i] = new AlgorithmId(this.digestAlgorithms[i].getOID(), this.digestAlgorithms[i].getParameters(), this.provider);
                continue;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getDigestAlgorithms", e);
                    debug.exit(16384L, (Object)className, "getDigestAlgorithms_2", null);
                }
                return null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithms", newdigestAlgorithms);
        }
        return newdigestAlgorithms;
    }

    public EncapsulatedContentInfo getEncapsulatedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContentInfo");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", null);
            }
            return null;
        }
        EncapsulatedContentInfo result = (EncapsulatedContentInfo)this.encapsulatedContentInfo.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", result);
        }
        return result;
    }

    private ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getContentInfo");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContentInfo", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentInfo", this.encapsulatedContentInfo.getContentInfo());
        }
        return this.encapsulatedContentInfo.getContentInfo();
    }

    private byte[] getContent() {
        if (debug != null) {
            debug.entry(8192L, className, "getContent");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContent", this.encapsulatedContentInfo.getContent());
        }
        return this.encapsulatedContentInfo.getContent();
    }

    public void removeContent() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "removeContent");
        }
        byte[] content = null;
        ContentInfo contentInfo = new ContentInfo(this.encapsulatedContentInfo.getContentType(), content, this.provider);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "removeContent");
        }
    }

    public boolean hasContent() {
        if (debug != null) {
            debug.entry(16384L, className, "hasContent");
        }
        boolean result = false;
        if (this.encapsulatedContentInfo.getContent() != null) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasContent", new Boolean(result));
        }
        return result;
    }

    public boolean hasCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCertificates");
        }
        boolean result = false;
        if (this.certs != null && this.certs.length > 0) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificates", new Boolean(result));
        }
        return result;
    }

    public boolean hasCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCRLs");
        }
        boolean result = false;
        if (this.crls != null && this.crls.length > 0) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCRLs", new Boolean(result));
        }
        return result;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        Certificate[] result = null;
        if (this.certs != null) {
            result = (Certificate[])this.certs.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", result);
        }
        return result;
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        CRL[] result = null;
        if (this.crls != null) {
            result = (CRL[])this.crls.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", result);
        }
        return result;
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
        }
        SignerInfo[] newsigners = null;
        if (this.signers != null) {
            newsigners = new SignerInfo[this.signers.length];
            for (int i = 0; i < this.signers.length; ++i) {
                newsigners[i] = (SignerInfo)this.signers[i].clone();
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfos", newsigners);
        }
        return newsigners;
    }

    public synchronized boolean hasSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "hasSignerInfos");
        }
        boolean result = false;
        if (this.signers != null && this.signers.length > 0) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignerInfos", new Boolean(result));
        }
        return result;
    }

    public SignerInfo getSignerInfo(Certificate cert) throws IOException {
        if (debug != null) {
            if (cert != null) {
                debug.entry(16384L, (Object)className, "getSignerInfo", cert);
            } else {
                debug.entry(16384L, className, "getSignerInfo");
            }
        }
        SignerInfo result = null;
        if (this.signers != null || cert != null) {
            for (int i = 0; i < this.signers.length; ++i) {
                if (!this.signers[i].hasCertificate(cert)) continue;
                result = (SignerInfo)this.signers[i].clone();
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfo", result);
        }
        return result;
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuer) throws IOException {
        if (debug != null) {
            if (issuer != null) {
                debug.entry(16384L, (Object)className, "getCertificate", issuer);
            } else {
                debug.entry(16384L, className, "getCertificate");
            }
        }
        X509CertImpl result = null;
        if (this.certs != null && issuer != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                BigInteger sn;
                X509Certificate x509cert = (X509Certificate)this.certs[i];
                Principal princ = x509cert.getIssuerDN();
                X500Name xname = new X500Name(princ.getName());
                if (!xname.equals(issuer.getIssuer()) || !(sn = x509cert.getSerialNumber()).equals(issuer.getSerialNumber())) continue;
                try {
                    byte[] bytes = this.certs[i].getEncoded();
                    result = new X509CertImpl(bytes);
                    continue;
                }
                catch (CertificateException e) {
                    if (debug != null) {
                        debug.exception(16384L, className, "getCertificate", e);
                    }
                    throw new IOException(e.toString());
                }
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificate", result);
        }
        return result;
    }

    public boolean hasCertificate(Certificate cert) {
        if (debug != null) {
            if (cert != null) {
                debug.entry(16384L, (Object)className, "hasCertificate", cert);
            } else {
                debug.entry(16384L, className, "hasCertificate");
            }
        }
        boolean result = false;
        if (this.certs != null && cert != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                if (!cert.equals(this.certs[i])) continue;
                result = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", new Boolean(result));
        }
        return result;
    }

    public boolean hasCRL(CRL crl) {
        if (debug != null) {
            if (crl != null) {
                debug.entry(16384L, (Object)className, "hasCRL", crl);
            } else {
                debug.entry(16384L, className, "hasCRL");
            }
        }
        boolean result = false;
        if (this.crls == null || crl == null) {
            result = false;
        } else {
            for (int i = 0; i < this.crls.length; ++i) {
                if (!crl.equals(this.crls[i])) continue;
                result = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCRL", new Boolean(result));
        }
        return result;
    }

    public boolean hasCertificatesOnly() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCertificatesOnly");
        }
        boolean result = false;
        if (this.hasCertificates() && !this.hasSignerInfos()) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificatesOnly", new Boolean(result));
        }
        return result;
    }

    public boolean verify(Certificate cert) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            if (cert != null) {
                debug.entry(16384L, (Object)className, "verify", cert);
            } else {
                debug.entry(16384L, className, "verify");
            }
        }
        boolean result = this.verify(cert, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(result));
        }
        return result;
    }

    public boolean verify(Certificate cert, byte[] msg) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            if (cert != null && msg != null) {
                debug.entry(16384L, className, "verify", cert, msg);
            } else {
                debug.entry(16384L, className, "verify");
            }
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        byte[] bytes = msg;
        if (bytes == null && (bytes = this.getContent()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array not specified and content not stored with SignedData.");
            }
            throw new IllegalArgumentException("Byte array not specified and content not stored with SignedData.");
        }
        if (this.signers == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", new Boolean(false));
            }
            return false;
        }
        SignerInfo signerInfo = this.getSignerInfo(cert);
        if (signerInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_2", new Boolean(false));
            }
            return false;
        }
        boolean result = signerInfo.verify(cert, bytes);
        if (!result) {
            SignerInfo rightSigner = null;
            if (this.orig_signers != null) {
                for (int i = 0; i < this.orig_signers.length; ++i) {
                    if (!this.orig_signers[i].hasCertificate(cert)) continue;
                    rightSigner = this.orig_signers[i];
                    break;
                }
            }
            if (rightSigner != null) {
                result = rightSigner.verify(((X509Certificate)cert).getPublicKey(), bytes, (byte)1);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify_2", result);
        }
        return result;
    }

    public synchronized void addSigner(Certificate cert, PrivateKey privateKey, String digestSignatureAlgorithm, PKCSAttributes signedAttribs, PKCSAttributes unsignedAttribs) throws PKCSException, IOException, NoSuchAlgorithmException {
        ContentInfo contentInfo;
        if (debug != null) {
            Object[] parms = new Object[]{cert, privateKey, digestSignatureAlgorithm, signedAttribs, unsignedAttribs};
            debug.entry(16384L, (Object)className, "addSigner", parms);
        }
        if ((contentInfo = this.getContentInfo()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSigner", "SignedData does not contain a ContentInfo to sign.");
            }
            throw new PKCSException("SignedData does not contain a ContentInfo to sign.");
        }
        SignerInfo signerInfo = new SignerInfo(cert, contentInfo, digestSignatureAlgorithm, privateKey, signedAttribs, unsignedAttribs, this.provider);
        this.addSignerInfo(signerInfo);
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        this.addDigestAlgorithm(digestAlgorithm);
        this.addCertificate(cert);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addSigner");
        }
    }

    public synchronized void addSignerSignatureOnly(Certificate cert, PrivateKey privateKey, String digestSignatureAlgorithm) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{cert, privateKey, digestSignatureAlgorithm};
            debug.entry(16384L, (Object)className, "addSignerSignatureOnly", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "Digest and Signature Algorithm must be specified.");
            }
            throw new IllegalArgumentException("Digest and Signature Algorithm must be specified.");
        }
        ContentInfo contentInfo = this.getContentInfo();
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "SignedData does not contain a ContentInfo to sign.");
            }
            throw new PKCSException("SignedData does not contain a ContentInfo to sign.");
        }
        if (!contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "ContentInfo is of type " + contentInfo.getContentTypeString() + ".  Type must be Data.");
            }
            throw new PKCSException("ContentInfo is of type " + contentInfo.getContentTypeString() + ".  Type must be Data.");
        }
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        Data data = (Data)contentInfo.getContent();
        byte[] message = data.getData();
        SignerInfo signerInfo = new SignerInfo(cert, this.provider);
        signerInfo.signSignatureOnly(message, digestSignatureAlgorithm, privateKey);
        this.addSignerInfo(signerInfo);
        this.addDigestAlgorithm(digestAlgorithm);
        this.addCertificate(cert);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addSignerSignatureOnly");
        }
    }

    private void addSignerInfo(SignerInfo signerInfo) {
        if (debug != null) {
            if (signerInfo != null) {
                debug.entry(8192L, (Object)className, "addSignerInfo", signerInfo);
            } else {
                debug.entry(8192L, className, "addSignerInfo");
            }
        }
        if (signerInfo == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addSignerInfo_1");
            }
            return;
        }
        if (this.signers == null) {
            this.signers = new SignerInfo[1];
            this.signers[0] = signerInfo;
            this.orig_signers = this.signers;
            if (debug != null) {
                debug.exit(8192L, className, "addSignerInfo_2");
            }
            return;
        }
        int len = this.signers.length;
        SignerInfo[] newSigners = new SignerInfo[len + 1];
        for (int i = 0; i < len; ++i) {
            newSigners[i] = this.signers[i];
        }
        this.signers = newSigners;
        this.signers[len] = signerInfo;
        if (this.orig_signers == null) {
            this.orig_signers = this.signers;
        }
        if (debug != null) {
            debug.exit(16384L, className, "addSignerInfo");
        }
    }

    private void addDigestAlgorithm(String digestAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            if (digestAlgorithm != null) {
                debug.entry(8192L, (Object)className, "addDigestAlgorithm", digestAlgorithm);
            } else {
                debug.entry(8192L, className, "addDigestAlgorithm");
            }
        }
        if (digestAlgorithm != null) {
            AlgorithmId algid = AlgorithmId.get(digestAlgorithm);
            this.addDigestAlgorithm(algid);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addDigestAlgorithm");
        }
    }

    private void addDigestAlgorithm(AlgorithmId digestAlgorithm) {
        if (debug != null) {
            if (digestAlgorithm != null) {
                debug.entry(8192L, (Object)className, "addDigestAlgorithm", digestAlgorithm);
            } else {
                debug.entry(8192L, className, "addDigestAlgorithm");
            }
        }
        if (digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_1");
            }
            return;
        }
        if (this.digestAlgorithms == null) {
            this.digestAlgorithms = new AlgorithmId[1];
            this.digestAlgorithms[0] = digestAlgorithm;
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_2");
            }
            return;
        }
        int len = this.digestAlgorithms.length;
        for (int i = 0; i < len; ++i) {
            if (!digestAlgorithm.equals(this.digestAlgorithms[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_3");
            }
            return;
        }
        AlgorithmId[] newDigestAlgorithms = new AlgorithmId[len + 1];
        for (int i = 0; i < len; ++i) {
            newDigestAlgorithms[i] = this.digestAlgorithms[i];
        }
        this.digestAlgorithms = newDigestAlgorithms;
        this.digestAlgorithms[len] = digestAlgorithm;
        if (debug != null) {
            debug.exit(8192L, className, "addDigestAlgorithm");
        }
    }

    private void addCertificate(Certificate cert) {
        if (debug != null) {
            if (cert != null) {
                debug.entry(8192L, (Object)className, "addCertificate", cert);
            } else {
                debug.entry(8192L, className, "addCertificate");
            }
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_1");
            }
            return;
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(8192L, className, "addCertificate", "Certificate type " + cert.getClass().getName() + "not supported.  Only instances of X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + cert.getClass().getName() + "not supported.  Only instances of X509Certificate are supported.");
        }
        if (this.certs == null) {
            this.certs = new Certificate[1];
            this.certs[0] = cert;
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_2");
            }
            return;
        }
        int len = this.certs.length;
        for (int i = 0; i < len; ++i) {
            if (!cert.equals(this.certs[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_3");
            }
            return;
        }
        Certificate[] newCerts = new Certificate[len + 1];
        for (int i = 0; i < len; ++i) {
            newCerts[i] = this.certs[i];
        }
        this.certs = newCerts;
        this.certs[len] = cert;
        if (debug != null) {
            debug.exit(8192L, className, "addCertificate");
        }
    }

    public void addCertificate(Certificate[] certs) {
        if (debug != null) {
            if (certs != null) {
                debug.entry(16384L, (Object)className, "addCertificate", certs);
            } else {
                debug.entry(16384L, className, "addCertificate");
            }
        }
        if (certs == null || certs.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addCertificate_1");
            }
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            this.addCertificate(certs[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addCertificate");
        }
    }

    private void addCRL(CRL crl) {
        if (debug != null) {
            if (crl != null) {
                debug.entry(8192L, (Object)className, "addCRL", crl);
            } else {
                debug.entry(8192L, className, "addCRL");
            }
        }
        if (crl == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_1");
            }
            return;
        }
        if (!(crl instanceof X509CRL)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "addCRL", "CRL type " + crl.getClass().getName() + "not supported.  Only instances of java.security.cert.X509CRL are supported.");
            }
            throw new IllegalArgumentException("CRL type " + crl.getClass().getName() + "not supported.  Only instances of java.security.cert.X509CRL are supported.");
        }
        if (this.crls == null) {
            this.crls = new CRL[1];
            this.crls[0] = crl;
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_2");
            }
            return;
        }
        int len = this.crls.length;
        for (int i = 0; i < len; ++i) {
            if (!crl.equals(this.crls[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_3");
            }
            return;
        }
        CRL[] newCRLs = new CRL[len + 1];
        for (int i = 0; i < len; ++i) {
            newCRLs[i] = this.crls[i];
        }
        this.crls = newCRLs;
        this.crls[len] = crl;
        if (debug != null) {
            debug.exit(8192L, className, "addCRL");
        }
    }

    public void addCRL(CRL[] crls) {
        if (debug != null) {
            if (crls != null) {
                debug.entry(16384L, (Object)className, "addCRL", crls);
            } else {
                debug.entry(16384L, className, "addCRL");
            }
        }
        if (crls != null && crls.length != 0) {
            for (int i = 0; i < crls.length; ++i) {
                this.addCRL(crls[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addCRL");
        }
    }

    public void encodeOriginal(OutputStream os) throws IOException {
        DerValue[] dvs;
        DerOutputStream tmp2;
        int i;
        DerValue[] ders;
        if (debug != null) {
            if (os != null) {
                debug.entry(16384L, (Object)className, "encode", os);
            } else {
                debug.entry(16384L, className, "encode");
            }
        }
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            ders = new DerValue[this.digestAlgorithms.length];
            for (i = 0; i < this.digestAlgorithms.length; ++i) {
                tmp2 = new DerOutputStream();
                this.digestAlgorithms[i].encode(tmp2);
                ders[i] = new DerValue(tmp2.toByteArray());
            }
            bytes.putSet(ders);
        } else {
            ders = new DerValue[]{};
            bytes.putOrderedSetOf((byte)49, ders);
        }
        this.encapsulatedContentInfo.encode(bytes);
        try {
            if (this.certs != null && this.certs.length > 0) {
                dvs = new DerValue[this.certs.length];
                for (i = 0; i < this.certs.length; ++i) {
                    if (!(this.certs[i] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                    }
                    dvs[i] = new DerValue(this.certs[i].getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putSet(dvs);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
            }
        }
        catch (CertificateEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new IOException("Error encoding certificates.  " + e.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                dvs = new DerValue[this.crls.length];
                for (int i2 = 0; i2 < this.crls.length; ++i2) {
                    if (!(this.crls[i2] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i2 + "] has a type of " + this.crls[i2].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i2 + "] has a type of " + this.crls[i2].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    X509CRL x509crl = (X509CRL)this.crls[i2];
                    dvs[i2] = new DerValue(x509crl.getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putSet(dvs);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
            }
        }
        catch (CRLException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new IOException("Error encoding crls.  " + e.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            if (this.orig_signers == null) {
                this.orig_signers = this.signers;
            }
            ders = new DerValue[this.orig_signers.length];
            for (int i3 = 0; i3 < this.orig_signers.length; ++i3) {
                tmp2 = new DerOutputStream();
                this.orig_signers[i3].encodeWithOriginalAttrs(tmp2);
                ders[i3] = new DerValue(tmp2.toByteArray());
            }
            bytes.putSet(ders);
        } else {
            ders = new DerValue[]{};
            bytes.putOrderedSetOf((byte)49, ders);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void encode(OutputStream os) throws IOException {
        DerEncoder[] temps;
        DerValue[] ders;
        if (debug != null) {
            if (os != null) {
                debug.entry(16384L, (Object)className, "encode", os);
            } else {
                debug.entry(16384L, className, "encode");
            }
        }
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            bytes.putOrderedSetOf((byte)49, this.digestAlgorithms);
        } else {
            ders = new DerValue[]{};
            bytes.putOrderedSetOf((byte)49, ders);
        }
        this.encapsulatedContentInfo.encode(bytes);
        try {
            if (this.certs != null && this.certs.length > 0) {
                temps = new DerOutputStream[this.certs.length];
                for (int i = 0; i < this.certs.length; ++i) {
                    if (!(this.certs[i] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                    }
                    temps[i] = new DerOutputStream();
                    ((OutputStream)((Object)temps[i])).write(this.certs[i].getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
            }
        }
        catch (CertificateEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new IOException("Error encoding certificates.  " + e.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                temps = new DerOutputStream[this.crls.length];
                for (int i = 0; i < this.crls.length; ++i) {
                    if (!(this.crls[i] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    temps[i] = new DerOutputStream();
                    X509CRL x509crl = (X509CRL)this.crls[i];
                    ((OutputStream)((Object)temps[i])).write(x509crl.getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
            }
        }
        catch (CRLException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new IOException("Error encoding crls.  " + e.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            bytes.putOrderedSetOf((byte)49, this.signers);
        } else {
            ders = new DerValue[]{};
            bytes.putOrderedSetOf((byte)49, ders);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue encoding) throws IOException {
        if (SignedData.debug != null) {
            if (encoding != null) {
                SignedData.debug.entry(16384L, (Object)SignedData.className, "decode", encoding);
            } else {
                SignedData.debug.entry(16384L, SignedData.className, "decode");
            }
        }
        if (encoding.getTag() != 48) {
            if (SignedData.debug != null) {
                SignedData.debug.text(16384L, SignedData.className, "decode", "SignedData parsing error.");
            }
            throw new IOException("SignedData parsing error.");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 1 && this.version.intValue() != 3) {
            if (SignedData.debug != null) {
                SignedData.debug.text(16384L, SignedData.className, "decode", "Invalid SignedData version = " + this.version + " (must be 1 or 3).");
            }
            throw new IOException("Invalid SignedData version = " + this.version + " (must be 1 or 3).");
        }
        ders = encoding.getData().getSet(1);
        this.digestAlgorithms = new AlgorithmId[ders.length];
        for (i = 0; i < ders.length; ++i) {
            this.digestAlgorithms[i] = AlgorithmId.parse(ders[i]);
        }
        opt = encoding.getData().getDerValue();
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(opt.toByteArray(), this.provider);
lbl22:
        // 3 sources

        try {
            while (encoding.getData().available() != 0) {
                block21: {
                    block20: {
                        opt = encoding.getData().getDerValue();
                        if (!opt.isContextSpecific((byte)0) || !opt.isConstructed()) break block20;
                        derin = new DerInputStream(opt.toByteArray());
                        ders = derin.getSet(1, true);
                        this.certs = new Certificate[ders.length];
                        for (i = 0; i < ders.length; ++i) {
                            this.certs[i] = new X509CertImpl(ders[i].toByteArray());
                        }
                        ** GOTO lbl22
                    }
                    if (!opt.isContextSpecific((byte)1) || !opt.isConstructed()) break block21;
                    derin = new DerInputStream(opt.toByteArray());
                    ders = derin.getSet(1, true);
                    this.crls = new X509CRL[ders.length];
                    for (i = 0; i < ders.length; ++i) {
                        this.crls[i] = new X509CRLImpl(ders[i].toByteArray());
                    }
                    ** GOTO lbl22
                }
                if (opt.getTag() == 49) break;
                if (SignedData.debug != null) {
                    SignedData.debug.text(16384L, SignedData.className, "decode", "Error decoding SignedData.  Unknown tag " + opt.getTag() + ".");
                }
                throw new IOException("Error decoding SignedData.  Unknown tag " + opt.getTag() + ".");
            }
        }
        catch (CertificateException e) {
            if (SignedData.debug != null) {
                SignedData.debug.exception(16384L, SignedData.className, "decode", e);
            }
            throw new IOException("Error decoding certificates.  " + e.toString());
        }
        catch (CRLException e) {
            if (SignedData.debug != null) {
                SignedData.debug.exception(16384L, SignedData.className, "decode", e);
            }
            throw new IOException("Error decoding CRLs.  " + e.toString());
        }
        derin = new DerInputStream(opt.toByteArray());
        ders = derin.getSet(1, true);
        this.signers = new SignerInfo[ders.length];
        for (i = 0; i < ders.length; ++i) {
            this.signers[i] = new SignerInfo(ders[i].toByteArray(), this.provider);
        }
        if (this.orig_signers == null) {
            this.orig_signers = this.signers;
        }
        if (SignedData.debug != null) {
            SignedData.debug.exit(16384L, SignedData.className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            if (other != null) {
                debug.entry(16384L, (Object)className, "equals", other);
            } else {
                debug.entry(16384L, className, "equals");
            }
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof SignedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((SignedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        try {
            DerOutputStream thisOut = new DerOutputStream();
            this.encode(thisOut);
            int HashVal = Arrays.hashCode(thisOut.toByteArray());
            return HashVal;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void removeSignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            if (oid != null) {
                debug.entry(16384L, (Object)className, "removeSignedAttribute", oid);
            } else {
                debug.entry(16384L, className, "removeSignedAttribute");
            }
        }
        if (oid != null && this.signers != null && this.signers.length != 0) {
            int len = this.signers.length;
            for (int i = 0; i < len; ++i) {
                this.signers[i].removeSignedAttribute(oid);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "removeSignedAttribute");
        }
    }

    private void removeUnsignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            if (oid != null) {
                debug.entry(16384L, (Object)className, "removeUnsignedAttribute", oid);
            } else {
                debug.entry(16384L, className, "removeUnsignedAttribute");
            }
        }
        if (oid != null && this.signers != null && this.signers.length != 0) {
            int len = this.signers.length;
            for (int i = 0; i < len; ++i) {
                this.signers[i].removeUnsignedAttribute(oid);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "removeUnsignedAttribute");
        }
    }

    public void writeBASE64(String filename) throws IOException {
        boolean bcertsonly = this.hasCertificatesOnly();
        FileOutputStream fos = new FileOutputStream(filename);
        DerOutputStream derout = new DerOutputStream();
        this.encode(derout);
        byte[] encoding = derout.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        if (bcertsonly) {
            try {
                fos.write(BEGIN_CERTIFICATE.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                fos.write(BEGIN_CERTIFICATE.getBytes());
            }
        }
        encoder.encode(encoding, (OutputStream)fos);
        if (bcertsonly) {
            try {
                fos.write(END_CERTIFICATE.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                fos.write(END_CERTIFICATE.getBytes());
            }
        }
        fos.close();
    }

    public String toString() {
        int i;
        this.calculateVersion();
        int ccount = 0;
        String out = "PKCS7 SignedData:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        ccount = 0;
        if (this.digestAlgorithms != null) {
            ccount = this.digestAlgorithms.length;
        }
        out = out + "\r\n\tdigestAlgorithms (" + ccount + "): ";
        if (this.digestAlgorithms == null || this.digestAlgorithms.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.digestAlgorithms.length; ++i) {
                out = out + "\r\n\tdigestAlgorithms[" + i + "]: " + this.digestAlgorithms[i];
            }
        }
        out = out + "\r\n\tencapsulatedContentInfo:\r\n";
        out = out + this.encapsulatedContentInfo;
        ccount = 0;
        if (this.certs != null) {
            ccount = this.certs.length;
        }
        out = out + "\r\n\tcertificates (" + ccount + "): ";
        if (this.certs == null || this.certs.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.certs.length; ++i) {
                out = out + "\r\n\tcerts[" + i + "]: " + this.certs[i];
            }
        }
        ccount = 0;
        if (this.crls != null) {
            ccount = this.crls.length;
        }
        out = out + "\r\n\tcertificate revocation lists (" + ccount + "): ";
        if (this.crls == null || this.crls.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.crls.length; ++i) {
                out = out + "\r\n\tcrls[" + i + "]: " + this.crls[i];
            }
        }
        ccount = 0;
        if (this.signers != null) {
            ccount = this.signers.length;
        }
        out = out + "\r\n\tsigners (" + ccount + "): ";
        if (this.signers == null || this.signers.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.signers.length; ++i) {
                out = out + "\r\n\tsigner[" + i + "]: " + this.signers[i];
            }
        }
        return out;
    }

    private void calculateVersion() {
        this.version = BigInteger.ONE;
    }
}

