/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AVA;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class RecipientKeyIdentifier
extends PKCSDerObject
implements RecipientIdentifier,
Cloneable {
    private byte[] keyId;
    private Date date;
    private AVA other;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.RecipientKeyIdentifier";
    private volatile int cachedHashVal = 0;

    public RecipientKeyIdentifier(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", (Object)der);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientKeyIdentifier", der, provider);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] key, Date date, AVA attr) {
        if (debug != null) {
            Object[] parms = new Object[]{key, date, attr};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", parms);
        }
        this.keyId = key;
        this.date = date;
        this.other = attr;
        if (debug != null) {
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] key, Date date, AVA attr, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{key, date, attr, provider};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", parms);
        }
        this.keyId = key;
        this.date = date;
        this.other = attr;
        if (debug != null) {
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientKeyIdentifier", filename, new Boolean(base64));
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", parms);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOctetString(this.keyId);
        if (this.date != null) {
            bytes.putGeneralizedTime(this.date);
        }
        if (this.other != null) {
            this.other.encode(bytes);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientKeyIdentifier parsing error");
            }
            throw new IOException("RecipientKeyIdentifier parsing error");
        }
        this.keyId = encoding.getData().getOctetString();
        while (encoding.getData().available() != 0) {
            int tag = encoding.getData().peekByte();
            if (tag == 24) {
                this.date = encoding.getData().getGeneralizedTime();
                continue;
            }
            if (tag != 48) continue;
            this.other = new AVA(encoding.getData());
            break;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof RecipientKeyIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((RecipientKeyIdentifier)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public byte[] getKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyIdentifier");
        }
        if (this.keyId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyIdentifier", null);
            }
            return null;
        }
        byte[] result = (byte[])this.keyId.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyIdentifier", result);
        }
        return result;
    }

    public Date getDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getDate");
        }
        if (this.date == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDate", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDate", this.date.clone());
        }
        return (Date)this.date.clone();
    }

    public AVA getOtherKeyAttribute() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOtherKeyAttribute");
        }
        if (this.other == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOtherKeyAttribute", null);
            }
            return null;
        }
        AVA result = new AVA(this.other.getOID(), this.other.getDerValue());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOtherKeyAttribute", result);
        }
        return result;
    }

    public String toString() {
        String dateString = null;
        String otherString = null;
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "";
        if (this.date != null) {
            dateString = this.date.toString();
        }
        if (this.other != null) {
            otherString = this.other.toString();
        }
        out = out + "\tkeyId:\r\n" + hexDump.encodeBuffer(this.keyId);
        out = out + "\r\n\tdate: " + dateString;
        out = out + "\r\n\tother: " + otherString;
        return out;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            RecipientKeyIdentifier result = new RecipientKeyIdentifier(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

