/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class EncryptedData
extends Content
implements Cloneable {
    private BigInteger version;
    private EncryptedContentInfo encryptedContent;
    private PKCSAttributes unprotectedAttrs;
    private SmudgedBytes contentEncryptionKey;
    private static final byte TAG_UNPROTECTED_ATTRS = 1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncryptedData";
    private volatile int cachedHashVal = 0;

    public EncryptedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedData", (Object)der);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedData", der, provider);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(EncryptedContentInfo eci, PKCSAttributes unprotectedAttrs) {
        this(eci, unprotectedAttrs, null);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedData", eci, unprotectedAttrs);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(EncryptedContentInfo eci, PKCSAttributes unprotectedAttrs, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{eci, unprotectedAttrs, provider};
            debug.entry(16384L, (Object)className, "EncryptedData", parms);
        }
        this.encryptedContent = eci;
        this.unprotectedAttrs = unprotectedAttrs;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "EncryptedData", parms);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EncryptedData", parms);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            EncryptedData result = new EncryptedData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        this.encryptedContent.encode(bytes);
        if (this.unprotectedAttrs != null && this.unprotectedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.unprotectedAttrs.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedData parsing error");
            }
            throw new IOException("EncryptedData parsing error");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version number must be 0 or 2");
            }
            throw new IllegalArgumentException("Version number must be 0 or 2");
        }
        DerValue der = encoding.getData().getDerValue();
        this.encryptedContent = new EncryptedContentInfo(der.toByteArray(), this.provider);
        if (encoding.getData().available() != 0) {
            der = encoding.getData().getDerValue();
            if (der.isContextSpecific((byte)1) && der.isConstructed()) {
                DerInputStream derin = new DerInputStream(der.toByteArray());
                this.unprotectedAttrs = new PKCSAttributes(derin, this.provider);
            } else {
                this.unprotectedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof EncryptedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((EncryptedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    private void addUnprotectedAttribute(PKCSAttributes unprotectedAttrs) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnprotectedAttribute", unprotectedAttrs);
        }
        if (unprotectedAttrs == null || unprotectedAttrs.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnprotectedAttribute");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs == null ? (PKCSAttributes)unprotectedAttrs.clone() : this.unprotectedAttrs.addAttributes(unprotectedAttrs);
        if (debug != null) {
            debug.exit(8192L, className, "addUnprotectedAttribute_1");
        }
    }

    private void addUnprotectedAttribute(PKCSAttribute unprotectedAttr) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnprotectedAttribute", this.unprotectedAttrs);
        }
        if (unprotectedAttr == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        if (this.unprotectedAttrs == null) {
            PKCSAttribute[] attribs = new PKCSAttribute[]{unprotectedAttr};
            this.unprotectedAttrs = new PKCSAttributes(attribs, this.provider);
        } else {
            this.unprotectedAttrs = this.unprotectedAttrs.addAttribute(unprotectedAttr);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnprotectedAttribute");
        }
    }

    private void removeUnprotectedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeUnprotectedAttribute", oid);
        }
        if (oid == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(8192L, className, "removeUnprotectedAttribute");
        }
    }

    public PKCSAttribute getUnprotectedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnprotectedAttribute", oid);
        }
        if (oid == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attrib = (PKCSAttribute)this.unprotectedAttrs.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttribute", attrib);
        }
        return attrib;
    }

    public PKCSAttributes getUnprotectedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnprotectedAttributes");
        }
        if (this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttributes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttributes_2", this.unprotectedAttrs);
        }
        return this.unprotectedAttrs;
    }

    private void encryptContent(ContentInfo cinfo, String algname, int keySize) throws PKCSException, IOException {
        AlgorithmId algId;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, new Integer(keySize)};
            debug.entry(8192L, (Object)className, "encryptContent", parms);
        }
        String alg = EncryptedContentInfo.getAlgorithm(algname);
        try {
            algId = AlgorithmId.get(alg);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", e);
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + alg + ".  Must be one of AES, DES, DESede or RC2.");
        }
        if (this.encryptedContent != null) {
            AlgorithmId currentAlgId = this.encryptedContent.getContentEncryptionAlgorithm();
            if (!currentAlgId.equals(algId) && debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.encryptedContent = new EncryptedContentInfo(cinfo, algname, keySize);
        this.setContentEncryptionKey(this.encryptedContent.getEncryptionKey());
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
    }

    private void encryptContent(ContentInfo cinfo, String algname, byte[] key) throws PKCSException, IOException {
        AlgorithmId algId;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, key};
            debug.entry(8192L, (Object)className, "encryptContent", parms);
        }
        String alg = EncryptedContentInfo.getAlgorithm(algname);
        try {
            algId = AlgorithmId.get(alg);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", e);
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + alg + ".  Must be one of AES, DES, DESede or RC2.");
        }
        if (this.encryptedContent != null) {
            AlgorithmId currentAlgId = this.encryptedContent.getContentEncryptionAlgorithm();
            if (!currentAlgId.equals(algId) && debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.encryptedContent = new EncryptedContentInfo(cinfo, algname, key, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
        this.setContentEncryptionKey(key);
    }

    public byte[] getEncryptionKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionKey");
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptionKey", null);
            }
            return null;
        }
        byte[] result = this.encryptedContent.getEncryptionKey();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptionKey", result);
        }
        return result;
    }

    public ContentInfo decrypt(byte[] key) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)key);
        }
        String algname = this.encryptedContent.getContentEncryptionAlgorithm().getName();
        ObjectIdentifier algOID = this.encryptedContent.getContentEncryptionAlgorithm().getOID();
        if (!(algOID.equals(AlgorithmId.DESCBC_oid) || algOID.equals(AlgorithmId.tripleDESCBC_oid) || algOID.equals(AlgorithmId.RC2CBC_oid) || algOID.equals(AlgorithmId.AES128CBC_oid) || algOID.equals(AlgorithmId.AES192CBC_oid) || algOID.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + algname);
            }
            throw new PKCSException("Unsupported decryption algorithm: " + algname);
        }
        ContentInfo result = this.encryptedContent.decrypt(key);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", result);
        }
        return result;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.ENCRYPTED_DATA_OID);
        }
        return PKCSOID.ENCRYPTED_DATA_OID;
    }

    public EncryptedContentInfo getEncryptedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContent");
            debug.exit(16384L, (Object)className, "getEncryptedContent", this.encryptedContent);
        }
        return this.encryptedContent;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String toString() {
        String out = "PKCS7 EncryptedData:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n\tencryptedContentInfo: " + this.encryptedContent;
        if (this.unprotectedAttrs != null) {
            out = out + "\r\n\tunprotectedAttrs (" + this.unprotectedAttrs.size() + "): \r\n";
            out = out + this.unprotectedAttrs + "\r\n";
        } else {
            out = out + "\tunprotectedAttrs: null\r\n";
        }
        return out;
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "EncryptedData missing encryptedContentInfo value.");
            }
            throw new IOException("EncryptedData missing encryptedContentInfo value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (this.unprotectedAttrs != null) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setContentEncryptionKey(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)bytes);
        }
        this.contentEncryptionKey = new SmudgedBytes(bytes);
        if (debug != null) {
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "setContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "setContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "setContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

