/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class KeyBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.KEYBAG_OID;
    private PrivateKeyInfo value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.KeyBag";
    private volatile int cachedHashVal = 0;

    public KeyBag(PrivateKeyInfo keyInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyBag", keyInfo);
            debug.exit(16384L, className, "KeyBag");
        }
        this.value = keyInfo;
    }

    public KeyBag(PrivateKeyInfo keyInfo, String provider) {
        super(provider);
        this.value = keyInfo;
        if (debug != null) {
            debug.entry(16384L, className, "KeyBag", keyInfo, provider);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "KeyBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "KeyBag", parms);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "KeyBag", parms);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public void encode(OutputStream out) throws IOException {
        this.value.encode(out);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.KEYBAG_OID);
        }
        return PKCSOID.KEYBAG_OID;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derout);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", null);
            }
            return null;
        }
        byte[] retval = derout.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
        }
        return retval;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "KeyBag");
        }
        return "KeyBag";
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof KeyBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((KeyBag)other));
            }
            return this.equals((KeyBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            KeyBag retobj = new KeyBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "KeyBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\nprivate key info:\r\n";
        out = out + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        this.value = new PrivateKeyInfo(encoding.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(KeyBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", true);
        }
        return true;
    }
}

