/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public abstract class TCPWriteRequestContextImpl
extends TCPBaseRequestContext
implements TCPWriteRequestContext {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl";
    protected static final int SYNC_WRITE = 0;
    protected static final int ASYNC_WRITE = 1;
    private TCPWriteCompletedCallback callback;
    private static final TraceComponent tc = Tr.register(TCPWriteRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPWriteRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
        this.setRequestTypeRead(false);
    }

    public long write(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumWrites();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalSyncWrites;
        }
        this.checkForErrors(l, 0, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "write (sync) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        long l2 = 0L;
        if (n == 0) {
            n = this.config.getInactivityTimeout();
        }
        if (n == -2) {
            this.immediateTimeout();
            return 0L;
        }
        if (this.config.getBlockingChannel() == 1) {
            long l3 = this.writeRegularSocket(l, n);
            return l3;
        }
        l2 = this.processSyncWriteRequest(l, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "blocking write returned " + String.valueOf(l2));
        }
        return l2;
    }

    public abstract long processSyncWriteRequest(long var1, int var3) throws IOException;

    public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + ",..," + bl + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumWrites();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalAsyncWrites;
        }
        this.checkForErrors(l, 1, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "write (async) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        return this.writeInternal(l, tCPWriteCompletedCallback, bl, n);
    }

    protected VirtualConnection writeInternal(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + ",..," + bl + "," + n + ")");
        }
        if (n == 0) {
            n = this.config.getInactivityTimeout();
        }
        if (n == -2) {
            this.immediateTimeout();
            return null;
        }
        this.setIOAmount(l);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setWriteCompletedCallback(tCPWriteCompletedCallback);
        this.setForceQueue(bl);
        this.setTimeoutTime(n);
        VirtualConnection virtualConnection = this.processAsyncWriteRequest();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
        return virtualConnection;
    }

    public abstract VirtualConnection processAsyncWriteRequest();

    private long writeRegularSocket(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeRegularSocket(" + l + ")");
        }
        long l2 = 0L;
        int n2 = 0;
        SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
        this.setIOAmount(l);
        socketIOChannel.getSocket().setSoTimeout(n);
        n2 = socketIOChannel.attemptWriteToSocket(this);
        if (n2 == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Throwing IOException, Connection closed: Write failed");
            }
            IOException iOException = new IOException("Connection closed: Write failed");
            throw iOException;
        }
        l2 = this.getIODoneAmount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeRegularSocket returning " + String.valueOf(l2));
        }
        return l2;
    }

    private void checkForErrors(long l, int n, int n2) {
        WsByteBuffer[] wsByteBufferArray;
        String string = null;
        if (this.config.getBlockingChannel() == 1) {
            if (n == 1) {
                string = "Async writes are not valid on blocking (regular socket) channels";
            } else if (n2 == -2) {
                string = "A cancel write,  an immediate timeout of the previous write, can not be done on blocking (regular socket) channels";
            }
        }
        if (n2 == -2) {
            return;
        }
        if (l > maxWriteSize) {
            string = "Number of bytes to requested to write: " + l + " exceeds the maximum allowed for one write";
        }
        if (this.getBuffers() == null || this.getBuffers().length == 0) {
            string = "No buffer(s) provided for writing data from";
        } else if (l < -1L || l == 0L && n == 1) {
            string = "Number of bytes requested to write: " + l + " is not valid";
        } else {
            wsByteBufferArray = this.getBuffers();
            long l2 = 0L;
            for (int i = 0; i < this.getBuffers().length && wsByteBufferArray[i] != null; ++i) {
                l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
            }
            if (l > l2 || l2 == 0L) {
                string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
            }
        }
        if (string != null) {
            wsByteBufferArray = new IllegalArgumentException(string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            FFDCFilter.processException((Throwable)wsByteBufferArray, CLASS_NAME, "100", this, this.buildDumpList());
            throw wsByteBufferArray;
        }
    }

    protected void setWriteCompletedCallback(TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.callback = tCPWriteCompletedCallback;
    }

    public TCPWriteCompletedCallback getWriteCompletedCallback() {
        return this.callback;
    }

    protected abstract void immediateTimeout();

    public ByteBuffer preProcessOneWriteBuffer() {
        WsByteBufferImpl wsByteBufferImpl = null;
        try {
            wsByteBufferImpl = (WsByteBufferImpl)this.getBuffer();
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
            }
            return wsByteBufferImpl.getWrappedByteBuffer();
        }
        if (!wsByteBufferImpl.isDirect() && wsByteBufferImpl.hasArray()) {
            wsByteBufferImpl.copyToDirectBuffer();
            return wsByteBufferImpl.oWsBBDirect;
        }
        return wsByteBufferImpl.getWrappedByteBuffer();
    }

    public ByteBuffer[] preProcessWriteBuffers() {
        int n;
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        boolean bl = false;
        for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
            if (wsByteBufferArray[n].isDirect() || !wsByteBufferArray[n].hasArray()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return this.getByteBufferArray();
        }
        try {
            for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                ((WsByteBufferImpl)wsByteBufferArray[n]).copyToDirectBuffer();
            }
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
            }
            return this.getByteBufferArray();
        }
        this.setBuffersToDirect(wsByteBufferArray);
        return this.getByteBufferArrayDirect();
    }

    public void postProcessWriteBuffers(long l) {
        if (this.getByteBufferArrayDirect() == null) {
            try {
                if (((WsByteBufferImpl)this.getBuffer()).oWsBBDirect != null) {
                    ((WsByteBufferImpl)this.getBuffer()).setParmsFromDirectBuffer();
                    return;
                }
                return;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            try {
                ((WsByteBufferImpl)wsByteBufferArray[i]).setParmsFromDirectBuffer();
                continue;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
    }

    public String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("TCPWriteRequestContextImpl FFDC Data");
        String string = super.getFFDCDumpData();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

