/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.tcp.channel.impl.AccessLists;
import com.ibm.ws.tcp.channel.impl.ChannelTermination;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class TCPChannel
implements InboundChannel,
OutboundChannel,
TCPChannelMessageConstants {
    private String channelName = null;
    protected String externalName = null;
    private ChannelData channelData;
    protected TCPChannelConfiguration config;
    protected ConnectionManager connectionManager = null;
    protected static NBAccept acceptReqProcessor = null;
    private WsByteBufferPoolManager wsByteBufferManager = null;
    protected VirtualConnectionFactory vcFactory = null;
    private TCPPort endPoint = null;
    private DiscriminationProcess discriminationProcess = null;
    private ThreadPool oThreadPool;
    private long lastConnExceededTime = 0L;
    private long lastThreadPoolErrorTime = 0L;
    private AccessLists alists;
    private TCPChannelLinkedList inUse = new TCPChannelLinkedList();
    protected boolean stopFlag = true;
    private boolean preparingToStop = false;
    private String displayableHostName = null;
    protected static final TraceComponent tc = Tr.register(TCPChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected ChannelFramework oChannelFramework;
    protected TCPChannelFactory channelFactory = null;
    protected int connectionCount = 0;
    Object connectionCountSync = new Object();
    protected StatisticsLogger statLogger = null;
    protected volatile long totalSyncReads = 0L;
    protected volatile long totalAsyncReads = 0L;
    public volatile long totalAsyncReadRetries = 0L;
    public volatile long totalPartialAsyncReads = 0L;
    public volatile long totalPartialSyncReads = 0L;
    protected volatile long totalSyncWrites = 0L;
    protected volatile long totalAsyncWrites = 0L;
    public volatile long totalAsyncWriteRetries = 0L;
    public volatile long totalPartialAsyncWrites = 0L;
    public volatile long totalPartialSyncWrites = 0L;
    protected volatile long totalConnections = 0L;
    protected volatile long maxConcurrentConnections = 0L;

    public void setup(ChannelData channelData, TCPChannelConfiguration tCPChannelConfiguration) throws ChannelException {
        this.setup(channelData, tCPChannelConfiguration, null);
    }

    public ChannelTermination setup(ChannelData channelData, TCPChannelConfiguration tCPChannelConfiguration, TCPChannelFactory tCPChannelFactory) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setup");
        }
        this.channelFactory = tCPChannelFactory;
        this.channelData = channelData;
        this.channelName = this.channelData.getName();
        this.externalName = this.channelData.getExternalName();
        this.config = tCPChannelConfiguration;
        this.oChannelFramework = this.channelData.getChannelFramework();
        this.vcFactory = this.oChannelFramework.getInboundVCFactory();
        this.wsByteBufferManager = WsByteBufferPoolManagerImpl.getRef();
        this.alists = AccessLists.getInstance(this.config);
        if (this.config.isInbound() && acceptReqProcessor == null) {
            acceptReqProcessor = new NBAccept(this.config);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setup");
        }
        return null;
    }

    protected AccessLists getAccessLists() {
        return this.alists;
    }

    protected boolean getStopFlag() {
        return this.stopFlag;
    }

    protected String getDisplayableHostName() {
        return this.displayableHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementConnectionCount() {
        Object object = this.connectionCountSync;
        synchronized (object) {
            --this.connectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionCount() {
        Object object = this.connectionCountSync;
        synchronized (object) {
            ++this.connectionCount;
        }
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.totalConnections;
            if ((long)this.connectionCount > this.maxConcurrentConnections) {
                this.maxConcurrentConnections = this.connectionCount;
            }
        }
    }

    protected int getInboundConnectionCount() {
        return this.connectionCount;
    }

    public Class getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    protected ConnectionManager getConnMgr() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionLink");
        }
        TCPConnLink tCPConnLink = new TCPConnLink(virtualConnection, this, this.config, this.oThreadPool);
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            this.inUse.add(tCPConnLink);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "obtained connlink: " + tCPConnLink.toString());
        }
        virtualConnection.getStateMap().put("TCP_THREADPOOL_NAME", this.config.getThreadPoolName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionLink");
        }
        return tCPConnLink;
    }

    public abstract TCPReadRequestContextImpl createReadInterface(TCPConnLink var1);

    public abstract TCPWriteRequestContextImpl createWriteInterface(TCPConnLink var1);

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.stopFlag) {
            this.stopFlag = false;
            if (this.config.isInbound()) {
                try {
                    if (null == this.endPoint.getServerSocket()) {
                        this.initializePort();
                    }
                    String string = "IPv4";
                    acceptReqProcessor.registerPort(this.endPoint);
                    this.preparingToStop = false;
                    if (this.endPoint.getServerSocket().getInetAddress() instanceof Inet6Address) {
                        string = "IPv6";
                    }
                    this.displayableHostName = this.config.getHostname() == null ? "*  (" + string + ")" : this.endPoint.getServerSocket().getInetAddress().getHostName() + "  (" + string + ": " + this.endPoint.getServerSocket().getInetAddress().getHostAddress() + ")";
                    Tr.audit(tc, "TCP_CHANNEL_STARTED", new Object[]{this.config.getChannelData().getExternalName(), this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.TCPChannel", "100", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "TCP Channel: " + this.externalName + "- Problem occurred while starting TCP Channel: " + iOException.getMessage());
                    }
                    ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + "- Problem occurred while starting channel: " + iOException.getMessage());
                    this.stopFlag = true;
                    throw channelException;
                }
            }
            if (this.config.getDumpStatsInterval() > 0) {
                this.createStatisticsThread();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void init() throws ChannelException {
        String string = this.config.getThreadPoolName();
        if (string != null) {
            this.oThreadPool = this.oChannelFramework.getThreadPool(string);
            if (this.oThreadPool == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "TCP Channel: " + this.externalName + " - Could not obtain named thread pool from the Channel Framework, thread pool name: " + string);
                }
                ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + " - Could not obtain named thread pool from the Channel Framework, thread pool name: " + string);
                throw channelException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "TCP Channel: " + this.externalName + "  Using Thread Pool: " + string + "  max pool size: " + this.oThreadPool.getMaximumPoolSize());
            }
        } else {
            this.oThreadPool = this.oChannelFramework.getDefaultThreadPool();
            if (this.oThreadPool == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "TCP Channel: " + this.externalName + " - Could not obtain default thread pool from the Channel Framework");
                }
                ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + " - Could not obtain default thread pool from the Channel Framework");
                throw channelException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "TCP Channel: " + this.externalName + "  Using Default Thread Pool" + "  max pool size: " + this.oThreadPool.getMaximumPoolSize());
            }
        }
        if (this.config.isInbound()) {
            this.endPoint = this.createEndPoint();
            this.initializePort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, " listening port: " + String.valueOf(this.endPoint.getListenPort()));
            }
        }
    }

    private void initializePort() throws ChannelException {
        try {
            this.endPoint.initServerSocket();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.TCPChannel", "319", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "TCP Channel: " + this.externalName + "- Problem occurred while initializing TCP Channel: " + iOException.getMessage());
            }
            ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + "- Problem occurred while starting channel: " + iOException.getMessage());
            throw channelException;
        }
        catch (RetryableChannelException retryableChannelException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "TCP Channel: " + this.externalName + "- Problem occurred while starting TCP Channel: " + retryableChannelException.getMessage());
            }
            throw retryableChannelException;
        }
        this.channelData.getPropertyBag().put("listeningPort", String.valueOf(this.endPoint.getListenPort()));
    }

    public TCPPort createEndPoint() throws ChannelException {
        return new TCPPort(this, this.vcFactory);
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroy " + this.getExternalName());
        }
        if (this.endPoint != null) {
            this.endPoint.destroyServerSocket();
        }
    }

    public Discriminator getDiscriminator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "getDiscriminator called erroneously on TCPChannel");
        }
        return null;
    }

    public void stop(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop (" + l + ") " + this.getExternalName());
        }
        if (!this.preparingToStop && acceptReqProcessor != null && this.config.isInbound()) {
            acceptReqProcessor.removePort(this.endPoint);
            this.endPoint.destroyServerSocket();
            Tr.audit(tc, "TCP_CHANNEL_STOPPED", new Object[]{this.externalName, this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
            this.preparingToStop = true;
        }
        if (l == 0L) {
            this.preparingToStop = false;
            this.stopFlag = true;
            this.destroyConnLinks();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String getName() {
        return this.channelName;
    }

    public Class getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return null;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess discriminationProcess) {
        this.discriminationProcess = discriminationProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ChannelData channelData) {
        TCPChannel tCPChannel = this;
        synchronized (tCPChannel) {
            if (this.config.checkAndSetValues(channelData)) {
                this.alists = AccessLists.getInstance(this.config);
            }
        }
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("TCP Channel: ", this.externalName, stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("**Configuration", "as follows:", stringBuffer2);
        return this.config.getFFDCDumpData(stringBuffer2);
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(new StringBuffer());
    }

    public Class getDeviceAddress() {
        throw new IllegalStateException("Not implemented and should not be");
    }

    public Class[] getApplicationAddress() {
        Class[] classArray = new Class[]{TCPConnectRequestContext.class};
        return classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnLinks() {
        TCPConnLink tCPConnLink = null;
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            int n = this.inUse.size();
            for (int i = 0; i < n; ++i) {
                tCPConnLink = (TCPConnLink)this.inUse.removeFirst();
                tCPConnLink.close(tCPConnLink.getVirtualConnection(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnectionLink(TCPConnLink tCPConnLink) {
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            this.inUse.remove(tCPConnLink);
        }
    }

    protected VirtualConnectionFactory getVcFactory() {
        return this.vcFactory;
    }

    public WsByteBufferPoolManager getWsByteBufferManager() {
        return this.wsByteBufferManager;
    }

    public String getExternalName() {
        return this.externalName;
    }

    protected long getLastConnExceededTime() {
        return this.lastConnExceededTime;
    }

    protected long getLastThreadPoolErrorTime() {
        return this.lastThreadPoolErrorTime;
    }

    protected void setLastConnExceededTime(long l) {
        this.lastConnExceededTime = l;
    }

    protected void setLastThreadPoolErrorTime(long l) {
        this.lastThreadPoolErrorTime = l;
    }

    public ThreadPool getThreadPool() {
        return this.oThreadPool;
    }

    public boolean verifyConnection(Socket socket) {
        int n;
        if (this.alists != null && (n = (int)(this.alists.accessDenied(socket.getInetAddress()) ? 1 : 0)) != 0) {
            return false;
        }
        n = this.config.getMaxOpenConnections();
        if (this.getInboundConnectionCount() >= n) {
            long l = System.currentTimeMillis();
            if (l > this.getLastConnExceededTime() + 600000L) {
                Tr.warning(tc, "MAX_CONNS_EXCEEDED", new Object[]{this.getExternalName(), new Integer(n)});
                this.setLastConnExceededTime(l);
            }
            return false;
        }
        try {
            if (this.config.getTcpNoDelay() == 0) {
                socket.setTcpNoDelay(false);
            } else {
                socket.setTcpNoDelay(true);
            }
            if (this.config.getSoLinger() >= 0) {
                socket.setSoLinger(true, this.config.getSoLinger());
            } else {
                socket.setSoLinger(false, 0);
            }
            if (this.config.getKeepAlive() == 0) {
                socket.setKeepAlive(false);
            } else {
                socket.setKeepAlive(true);
            }
            if (this.config.getSendBufferSize() >= 4 && this.config.getSendBufferSize() <= 0x1000000) {
                socket.setSendBufferSize(this.config.getSendBufferSize());
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "IOException caught while configuring socket: " + iOException);
            }
            return false;
        }
        return true;
    }

    public abstract SocketIOChannel createOutboundSocketIOChannel() throws IOException;

    public abstract SocketIOChannel createInboundSocketIOChannel(SocketChannel var1) throws IOException;

    protected void createStatisticsThread() {
        this.statLogger = new StatisticsLogger(this);
        PrivilegedThreadStarter privilegedThreadStarter = new PrivilegedThreadStarter();
        AccessController.doPrivileged(privilegedThreadStarter);
    }

    public void dumpStatistics() {
        if (this.getConfig().isInbound()) {
            System.out.println("Statistics for TCP inbound channel " + this.externalName + " (port " + this.getConfig().getPort() + ")");
            System.out.println("   Total connections accepted: " + this.totalConnections);
        } else {
            System.out.println("Statistics for TCP outbound channel " + this.externalName);
            System.out.println("   Total connects processed: " + this.totalConnections);
        }
        System.out.println("   Maximum concurrent connections: " + this.maxConcurrentConnections);
        System.out.println("   Current connection count: " + this.connectionCount);
        System.out.println("   Total Async read requests: " + this.totalAsyncReads);
        System.out.println("   Total Async read retries: " + this.totalAsyncReadRetries);
        System.out.println("   Total Async read partial reads: " + this.totalPartialAsyncReads);
        System.out.println("   Total Sync read requests: " + this.totalSyncReads);
        System.out.println("   Total Sync read partial reads: " + this.totalPartialSyncReads);
        System.out.println("   Total Async write requests: " + this.totalAsyncWrites);
        System.out.println("   Total Async write retries: " + this.totalAsyncWriteRetries);
        System.out.println("   Total Async write partial writes: " + this.totalPartialAsyncWrites);
        System.out.println("   Total Sync write requests: " + this.totalSyncWrites);
        System.out.println("   Total Sync write partial writes: " + this.totalPartialSyncWrites);
    }

    class PrivilegedThreadStarter
    implements PrivilegedAction {
        public void setParms() {
        }

        public Object run() {
            String string = "Statistics Logging Thread for: " + TCPChannel.this.config.getChannelData().getExternalName();
            Thread thread = new Thread(TCPChannel.this.statLogger);
            thread.setName(string);
            thread.setDaemon(false);
            thread.start();
            return null;
        }
    }

    class StatisticsLogger
    implements Runnable {
        TCPChannel tcpChannel;

        public StatisticsLogger(TCPChannel tCPChannel2) {
            this.tcpChannel = tCPChannel2;
        }

        public void run() {
            boolean bl = false;
            if (this.tcpChannel.getConfig().isInbound()) {
                System.out.println("Statistics logging for TCP inbound channel " + this.tcpChannel.externalName + " (port " + this.tcpChannel.getConfig().getPort() + ") is now on");
            } else {
                System.out.println("Statistics logging for TCP outbound channel " + this.tcpChannel.externalName + " is now on");
            }
            while (!this.tcpChannel.getStopFlag() && !bl) {
                try {
                    Thread.sleep(this.tcpChannel.getConfig().getDumpStatsInterval() * 1000);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                this.tcpChannel.dumpStatistics();
            }
            System.out.println(" stat thread exiting");
        }
    }
}

