/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.text.PlainDocument;

public final class ConsoleWindow
extends JFrame {
    private final ConsoleController controller;
    private JTextArea textArea;
    private JScrollPane scroller;
    private JScrollBar sbHor;
    private JScrollBar sbVer;
    private static final int TEXT_LIMIT = 1048575;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleWindow create(ConsoleController consoleController) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            ConsoleWindow consoleWindow = new ConsoleWindow(consoleController);
            return consoleWindow;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public ConsoleWindow(final ConsoleController consoleController) {
        super(ResourceManager.getMessage("console.caption"));
        Object object;
        Object object2;
        this.controller = consoleController;
        this.setSize(450, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.getAccessibleContext().setAccessibleName("Console Window");
        this.textArea.getAccessibleContext().setAccessibleDescription("Console Window");
        this.textArea.setFont(ResourceManager.getUIFont());
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(0, 5, 0, 0));
        this.scroller = new JScrollPane(this.textArea);
        if (!System.getProperty("java.version").startsWith("1.2")) {
            object2 = this.scroller.getViewport();
            ((JViewport)object2).setScrollMode(1);
        }
        this.sbVer = this.scroller.getVerticalScrollBar();
        this.sbHor = this.scroller.getHorizontalScrollBar();
        this.getContentPane().add((Component)this.scroller, "Center");
        object2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ResourceManager.getMessage("console.dump.stack"));
                stringBuffer.append(ResourceManager.getMessage("console.menu.text.top"));
                stringBuffer.append(consoleController.dumpAllStacks());
                stringBuffer.append(ResourceManager.getMessage("console.menu.text.tail"));
                stringBuffer.append(ResourceManager.getMessage("console.done"));
                System.out.println(stringBuffer.toString());
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ResourceManager.getMessage("console.dump.thread"));
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = consoleController.getMainThreadGroup();
                ConsoleHelper.dumpThreadGroup(threadGroup, stringBuffer);
                stringBuffer.append(ResourceManager.getMessage("console.done"));
                System.out.println(stringBuffer.toString());
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print(ResourceManager.getMessage("console.reload.policy"));
                consoleController.reloadSecurityPolicy();
                System.out.println(ResourceManager.getMessage("console.completed"));
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(ResourceManager.getMessage("console.reload.proxy"));
                consoleController.reloadProxyConfig();
                System.out.println(ResourceManager.getMessage("console.done"));
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(ConsoleHelper.displaySystemProperties());
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConsoleHelper.displayHelp();
                System.out.print(string);
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(consoleController.dumpClassLoaders());
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                consoleController.clearClassLoaders();
                System.out.println(ResourceManager.getMessage("console.clear.classloader"));
            }
        };
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConsoleHelper.displayVersion();
                String string2 = ConsoleHelper.displayHelp();
                String string3 = string + "\n" + string2;
                PlainDocument plainDocument = new PlainDocument();
                ConsoleWindow.this.textArea.setDocument(plainDocument);
                ConsoleWindow.this.textArea.setText(string3);
                ConsoleWindow.this.textArea.revalidate();
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConsoleWindow.this.textArea.getSelectionStart();
                int n2 = ConsoleWindow.this.textArea.getSelectionEnd();
                if (n2 - n <= 0) {
                    ConsoleWindow.this.textArea.selectAll();
                }
                ConsoleWindow.this.textArea.copy();
            }
        };
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (consoleController.isIconifiedOnClose()) {
                    ConsoleWindow.this.setState(1);
                } else {
                    ConsoleWindow.this.setVisible(false);
                }
            }
        };
        final ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                long l3 = (long)(100.0 / ((double)l2 / (double)l));
                MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("console.memory"));
                Object[] objectArray = new Object[]{new Long(l2), new Long(l), new Long(l3)};
                System.out.print(messageFormat.format(objectArray));
                System.out.println(ResourceManager.getMessage("console.completed"));
            }
        };
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print(ResourceManager.getMessage("console.finalize"));
                System.runFinalization();
                System.out.println(ResourceManager.getMessage("console.completed"));
                actionListener11.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print(ResourceManager.getMessage("console.gc"));
                System.gc();
                System.out.println(ResourceManager.getMessage("console.completed"));
                actionListener11.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener14 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(false);
                Trace.setCacheTrace(false);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                Trace.setTempTrace(false);
                System.out.println(ResourceManager.getMessage("console.trace.level.0"));
            }
        };
        ActionListener actionListener15 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setCacheTrace(false);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                Trace.setTempTrace(false);
                System.out.println(ResourceManager.getMessage("console.trace.level.1"));
            }
        };
        ActionListener actionListener16 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setCacheTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                Trace.setTempTrace(false);
                System.out.println(ResourceManager.getMessage("console.trace.level.2"));
            }
        };
        ActionListener actionListener17 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setCacheTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                Trace.setTempTrace(false);
                System.out.println(ResourceManager.getMessage("console.trace.level.3"));
            }
        };
        ActionListener actionListener18 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setCacheTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(false);
                Trace.setTempTrace(false);
                System.out.println(ResourceManager.getMessage("console.trace.level.4"));
            }
        };
        ActionListener actionListener19 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setCacheTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(true);
                Trace.setTempTrace(true);
                System.out.println(ResourceManager.getMessage("console.trace.level.5"));
            }
        };
        ActionListener actionListener20 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(ResourceManager.getMessage("console.log") + consoleController.toggleLogging() + ResourceManager.getMessage("console.completed"));
            }
        };
        if (consoleController.isJCovSupported()) {
            object = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!consoleController.dumpJCovData()) {
                        System.out.println(ResourceManager.getMessage("console.jcov.error"));
                    } else {
                        System.out.println(ResourceManager.getMessage("console.jcov.info"));
                    }
                }
            };
            this.textArea.registerKeyboardAction((ActionListener)object, KeyStroke.getKeyStroke(74, 0), 2);
        }
        if (consoleController.isDumpStackSupported()) {
            this.textArea.registerKeyboardAction((ActionListener)object2, KeyStroke.getKeyStroke(86, 0), 2);
        }
        if (consoleController.isProxyConfigReloadSupported()) {
            this.textArea.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(80, 0), 2);
        }
        if (consoleController.isSecurityPolicyReloadSupported()) {
            this.textArea.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(82, 0), 2);
        }
        if (consoleController.isClearClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(actionListener7, KeyStroke.getKeyStroke(88, 0), 2);
        }
        if (consoleController.isDumpClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(actionListener6, KeyStroke.getKeyStroke(76, 0), 2);
        }
        if (consoleController.isLoggingSupported()) {
            this.textArea.registerKeyboardAction(actionListener20, KeyStroke.getKeyStroke(79, 0), 2);
        }
        this.textArea.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(84, 0), 2);
        this.textArea.registerKeyboardAction(actionListener4, KeyStroke.getKeyStroke(83, 0), 2);
        this.textArea.registerKeyboardAction(actionListener5, KeyStroke.getKeyStroke(72, 0), 2);
        this.textArea.registerKeyboardAction(actionListener11, KeyStroke.getKeyStroke(77, 0), 2);
        this.textArea.registerKeyboardAction(actionListener8, KeyStroke.getKeyStroke(67, 0), 2);
        this.textArea.registerKeyboardAction(actionListener13, KeyStroke.getKeyStroke(71, 0), 2);
        this.textArea.registerKeyboardAction(actionListener12, KeyStroke.getKeyStroke(70, 0), 2);
        this.textArea.registerKeyboardAction(actionListener10, KeyStroke.getKeyStroke(81, 0), 2);
        object = System.getProperty("user.language");
        if (((String)object).equals("cs") || ((String)object).equals("fr") || ((String)object).equals("sk")) {
            this.textArea.registerKeyboardAction(actionListener14, KeyStroke.getKeyStroke(48, 1), 2);
            this.textArea.registerKeyboardAction(actionListener15, KeyStroke.getKeyStroke(49, 1), 2);
            this.textArea.registerKeyboardAction(actionListener16, KeyStroke.getKeyStroke(50, 1), 2);
            this.textArea.registerKeyboardAction(actionListener17, KeyStroke.getKeyStroke(51, 1), 2);
            this.textArea.registerKeyboardAction(actionListener18, KeyStroke.getKeyStroke(52, 1), 2);
            this.textArea.registerKeyboardAction(actionListener19, KeyStroke.getKeyStroke(53, 1), 2);
        } else {
            this.textArea.registerKeyboardAction(actionListener14, KeyStroke.getKeyStroke(48, 0), 2);
            this.textArea.registerKeyboardAction(actionListener15, KeyStroke.getKeyStroke(49, 0), 2);
            this.textArea.registerKeyboardAction(actionListener16, KeyStroke.getKeyStroke(50, 0), 2);
            this.textArea.registerKeyboardAction(actionListener17, KeyStroke.getKeyStroke(51, 0), 2);
            this.textArea.registerKeyboardAction(actionListener18, KeyStroke.getKeyStroke(52, 0), 2);
            this.textArea.registerKeyboardAction(actionListener19, KeyStroke.getKeyStroke(53, 0), 2);
        }
        this.textArea.registerKeyboardAction(actionListener14, KeyStroke.getKeyStroke(96, 0), 2);
        this.textArea.registerKeyboardAction(actionListener15, KeyStroke.getKeyStroke(97, 0), 2);
        this.textArea.registerKeyboardAction(actionListener16, KeyStroke.getKeyStroke(98, 0), 2);
        this.textArea.registerKeyboardAction(actionListener17, KeyStroke.getKeyStroke(99, 0), 2);
        this.textArea.registerKeyboardAction(actionListener18, KeyStroke.getKeyStroke(100, 0), 2);
        this.textArea.registerKeyboardAction(actionListener19, KeyStroke.getKeyStroke(101, 0), 2);
        JButton jButton = new JButton(ResourceManager.getMessage("console.clear"));
        jButton.setMnemonic(ResourceManager.getAcceleratorKey("console.clear"));
        jButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("console.clear"));
        JButton jButton2 = new JButton(ResourceManager.getMessage("console.copy"));
        jButton2.setMnemonic(ResourceManager.getAcceleratorKey("console.copy"));
        jButton2.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("console.clear"));
        JButton jButton3 = new JButton(ResourceManager.getMessage("console.close"));
        jButton3.setMnemonic(ResourceManager.getAcceleratorKey("console.close"));
        jButton3.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("console.clear"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton2);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (consoleController.isIconifiedOnClose()) {
                    ConsoleWindow.this.setState(1);
                } else {
                    ConsoleWindow.this.setVisible(false);
                }
            }
        });
        jButton.addActionListener(actionListener8);
        jButton2.addActionListener(actionListener9);
        jButton3.addActionListener(actionListener10);
    }

    public void append(final String string) {
        this.controller.invokeLater(new Runnable(){

            public void run() {
                int n = ConsoleWindow.this.textArea.getText().length() + string.length() - 1048575;
                if (n > 0) {
                    ConsoleWindow.this.textArea.replaceRange("", 0, n);
                }
                ConsoleWindow.this.textArea.append(string);
                ConsoleWindow.this.textArea.revalidate();
                ConsoleWindow.this.setScrollPosition();
            }
        });
    }

    public void setScrollPosition() {
        this.scroller.validate();
        this.sbVer.setValue(this.sbVer.getMaximum());
        this.sbHor.setValue(this.sbHor.getMinimum());
    }

    public void showConsole(boolean bl) {
        if (this.controller.isIconifiedOnClose()) {
            if (bl) {
                this.setState(0);
            } else {
                this.setState(1);
            }
            this.setVisible(true);
        } else {
            if (this.isVisible() != bl) {
                this.setVisible(bl);
            }
            if (bl) {
                this.toFront();
            }
        }
    }

    public boolean isConsoleVisible() {
        if (this.controller.isIconifiedOnClose()) {
            return this.getState() == 0;
        }
        return this.isVisible();
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

