/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

class MoreInfoDialog
extends JDialog {
    private FancyButton details;
    private String[] alerts;
    private String[] infos;
    private int securityInfoCount;
    private Certificate[] certs;
    private int start;
    private int end;
    private final String WARNING_ICON = "com/sun/deploy/resources/image/icon-warning16.png";
    private final String INFO_ICON = "com/sun/deploy/resources/image/icon-info16.png";
    private final int VERTICAL_STRUT = 18;
    private final int HORIZONTAL_STRUT = 12;
    private final int TEXT_WIDTH = 326;

    MoreInfoDialog(JDialog jDialog, String[] stringArray, String[] stringArray2, int n, Certificate[] certificateArray, int n2, int n3) {
        super((Dialog)jDialog, true);
        this.alerts = stringArray;
        this.infos = stringArray2;
        this.securityInfoCount = n;
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.initComponents(null, null);
        this.setResizable(false);
    }

    MoreInfoDialog(JDialog jDialog, JPanel jPanel, Throwable throwable, Certificate[] certificateArray) {
        super((Dialog)jDialog, true);
        this.certs = certificateArray;
        this.start = 0;
        this.end = certificateArray == null ? 0 : certificateArray.length;
        this.initComponents(jPanel, throwable);
    }

    private void initComponents(JPanel jPanel, Throwable throwable) {
        this.setTitle(ResourceManager.getMessage("security.more.info.title"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(16, 16, 12, 16));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.0f);
        if (jPanel != null) {
            jPanel2.add(jPanel);
        } else if (throwable != null) {
            jPanel2.add(Box.createHorizontalStrut(440));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(ResourceManager.getString("exception.details.label"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            jPanel3.add((Component)jLabel, "West");
            jPanel2.add(jPanel3);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            JTextArea jTextArea = new JTextArea(stringWriter.toString(), 20, 60);
            jTextArea.setFont(ResourceManager.getUIFont());
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
            jPanel2.add(jScrollPane);
            if (this.certs != null) {
                jPanel2.add(Box.createVerticalStrut(18));
                jPanel2.add(this.getLinkPanel());
            }
        } else {
            jPanel2.add(this.getSecurityPanel());
            if (this.certs != null) {
                jPanel2.add(this.getLinkPanel());
            }
            jPanel2.add(Box.createVerticalStrut(18));
            jPanel2.add(this.getIntegrationPanel());
        }
        jPanel2.add(Box.createVerticalStrut(18));
        jPanel2.add(this.getBtnPanel());
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        UIFactory.placeWindow(this);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.dismissAction();
            }
        });
    }

    private JPanel getSecurityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        boolean bl = this.certs == null;
        int n = bl || this.alerts == null ? 0 : 1;
        int n2 = this.alerts == null ? 0 : this.alerts.length;
        jPanel.add(this.blockPanel("com/sun/deploy/resources/image/icon-warning16.png", this.alerts, n, n2));
        n = bl || this.alerts != null ? 0 : 1;
        n2 = this.securityInfoCount;
        jPanel.add(this.blockPanel("com/sun/deploy/resources/image/icon-info16.png", this.infos, n, n2));
        return jPanel;
    }

    private JPanel getLinkPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        this.details = new FancyButton("security.more.info.details", Color.blue);
        this.details.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("security.more.info.details"));
        this.details.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof FancyButton) {
                    MoreInfoDialog.this.showCertDetails();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.showCertDetails();
            }
        });
        jPanel.add(this.details);
        return jPanel;
    }

    private JPanel getIntegrationPanel() {
        int n = this.securityInfoCount;
        int n2 = this.infos == null ? 0 : this.infos.length;
        return this.blockPanel("com/sun/deploy/resources/image/icon-info16.png", this.infos, n, n2);
    }

    private JPanel getBtnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(ResourceManager.getMessage("common.close_btn"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoreInfoDialog.this.dismissAction();
            }
        });
        jButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("common.close_btn"));
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel blockPanel(String string, String[] stringArray, int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (stringArray != null) {
            for (int i = n; i < n2; ++i) {
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.setAlignmentX(0.0f);
                JLabel jLabel = new JLabel();
                jLabel.setIcon(new ImageIcon(ClassLoader.getSystemResource(string)));
                jLabel.setAlignmentY(0.0f);
                jLabel.setAlignmentX(0.0f);
                UITextArea uITextArea = new UITextArea(new JLabel().getFont().getSize(), 326, false);
                uITextArea.setText(stringArray[i]);
                Dimension dimension = uITextArea.getPreferredSize();
                uITextArea.setSize(dimension.width, dimension.height);
                uITextArea.setAlignmentY(0.0f);
                uITextArea.setAlignmentX(0.0f);
                jPanel2.add(jLabel);
                jPanel2.add(Box.createHorizontalStrut(12));
                jPanel2.add(uITextArea);
                jPanel2.add(Box.createHorizontalGlue());
                jPanel.add(jPanel2);
                jPanel.add(Box.createVerticalStrut(18));
            }
        }
        return jPanel;
    }

    private void showCertDetails() {
        new CertificateDialog(this, this.certs, this.start, this.end).DoModal();
    }

    private void dismissAction() {
        this.setVisible(false);
        this.dispose();
    }
}

