/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.util.DialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

final class ClientCertDialog
implements ActionListener {
    private HashMap clientAuthCertsMap = new HashMap();
    private Vector certs = new Vector();
    private JList certList;

    ClientCertDialog(HashMap hashMap, HashMap hashMap2) {
        this.clientAuthCertsMap = hashMap;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            MessageFormat messageFormat = null;
            String string = (String)iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])hashMap.get(string);
            Object v = hashMap2.get(string);
            String string2 = CertUtils.extractSubjectAliasName(x509CertificateArray[0]);
            messageFormat = v.equals(CertType.PLUGIN) ? new MessageFormat(ClientCertDialog.getMessage("clientauth.certlist.dialog.javaKS")) : new MessageFormat(ClientCertDialog.getMessage("clientauth.certlist.dialog.browserKS"));
            Object[] objectArray = new Object[]{string2};
            this.certs.add(messageFormat.format(objectArray));
        }
    }

    String DoModal() {
        String string = ClientCertDialog.getMessage("clientauth.certlist.dialog.text");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.certList = new JList();
        this.certList.setSelectionMode(0);
        this.certList.setListData(this.certs);
        if (this.certs.size() > 0) {
            this.certList.setSelectedIndex(0);
        }
        JButton jButton = new JButton(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonDetails"));
        jButton.getAccessibleContext().setAccessibleDescription(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonDetails"));
        jButton.setMnemonic(ClientCertDialog.getAcceleratorKey("clientauth.certlist.dialog.buttonDetails"));
        jButton.addActionListener(this);
        jPanel.add((Component)new JScrollPane(this.certList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.setLayout(new FlowLayout(2));
        Object[] objectArray = new Object[]{string.toString(), jPanel, jPanel2};
        JButton jButton2 = new JButton(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonOK"));
        JButton jButton3 = new JButton(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonCancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonOK"));
        jButton3.getAccessibleContext().setAccessibleDescription(ClientCertDialog.getMessage("clientauth.certlist.dialog.buttonCancel"));
        String string2 = ClientCertDialog.getMessage("clientauth.certlist.dialog.caption");
        Object[] objectArray2 = new Object[]{jButton2, jButton3};
        int n = DialogFactory.showOptionDialog(4, (Object)objectArray, string2, objectArray2, objectArray2[0]);
        String string3 = null;
        if (n == 0) {
            Iterator iterator = this.clientAuthCertsMap.keySet().iterator();
            for (int i = this.certList.getSelectedIndex(); i >= 0 && iterator.hasNext(); --i) {
                string3 = (String)iterator.next();
            }
        }
        return string3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Certificate[] certificateArray = null;
        Object object = this.clientAuthCertsMap.values().iterator();
        for (int i = this.certList.getSelectedIndex(); i >= 0 && object.hasNext(); --i) {
            certificateArray = (X509Certificate[])object.next();
        }
        if (certificateArray != null) {
            object = new CertificateDialog(certificateArray, 0, certificateArray.length);
            ((CertificateDialog)object).DoModal();
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }
}

