/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.ReportedSAXException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerProxyForErrorListener
implements ErrorHandler {
    private ErrorListener m_listener;
    private boolean m_reportAsConfigurationException;

    public ErrorHandlerProxyForErrorListener(ErrorListener listener, boolean resportAsConfigurationException) {
        this.m_listener = listener;
        this.m_reportAsConfigurationException = resportAsConfigurationException;
    }

    public void warning(SAXParseException se) throws SAXException {
        try {
            this.m_listener.warning(this.createWrapperException(se));
        }
        catch (TransformerException te) {
            throw new ReportedSAXException(te);
        }
    }

    public void error(SAXParseException se) throws SAXException {
        try {
            this.m_listener.error(this.createWrapperException(se));
        }
        catch (TransformerException te) {
            throw new ReportedSAXException(te);
        }
    }

    public void fatalError(SAXParseException se) throws SAXException {
        TransformerException wrappedException = this.createWrapperException(se);
        try {
            this.m_listener.fatalError(wrappedException);
        }
        catch (TransformerException te) {
            throw new ReportedSAXException(te);
        }
        throw new ReportedSAXException(wrappedException);
    }

    private TransformerException createWrapperException(SAXParseException se) {
        return this.m_reportAsConfigurationException ? new TransformerConfigurationException(se.getMessage(), se) : new TransformerException(se.getMessage(), se);
    }
}

