/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.XMLGregorianCalendar2;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.xerces.jaxp.datatype.DateTimeUtil;
import org.apache.xerces.jaxp.datatype.DurationImpl;
import org.apache.xerces.jaxp.datatype.SerializedXMLGregorianCalendar;
import org.apache.xerces.util.DatatypeMessageFormatter;
import org.apache.xerces.util.XMLStringBuffer;

final class XMLGregorianCalendarImpl
extends XMLGregorianCalendar2
implements Serializable {
    private static final long serialVersionUID = 3905403108073447394L;
    private static final int DIGITS_IN_ONE_BILLION = 10;
    private static final int MAX_INT_I = 1000000000;
    private static final BigInteger MAX_INT_B = BigInteger.valueOf(1000000000L);
    private static final BigInteger MAX_INT_B_NEGATIVE = BigInteger.valueOf(-1000000000L);
    private static final int NOT_REPRESENTABLE_IN_MILLISECONDS = -1;
    private static final Date PURE_GREGORIAN_CALENDAR_CHANGE = new Date(Long.MIN_VALUE);
    private BigInteger eon;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private int millisecond = Integer.MIN_VALUE;
    private BigDecimal fracSeconds;
    private int timezone = Integer.MIN_VALUE;
    private XMLGregorianCalendarSnapshot initialValues;
    private static final int YEAR = 2000;
    private static final int MONTH = 1;
    private static final int DAY = 1;
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private static final BigInteger I_ZERO = BigInteger.valueOf(0L);
    private static final BigDecimal ONE = BigDecimal.valueOf(1L);
    private static final BigInteger I_ONE = BigInteger.valueOf(1L);
    private static final BigInteger THIRTEEN = BigInteger.valueOf(13L);

    public XMLGregorianCalendarImpl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLGregorianCalendarImpl(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"String"}));
        }
        int n2 = string.length();
        if (n2 <= 3) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
        if (string.charAt(0) == '-' && string.charAt(1) == '-') {
            if (string.charAt(2) == '-') {
                if (n2 < 5) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gDay"}));
                this.setDay0(DateTimeUtil.parseInt(string, 3, 5));
                if (n2 > 5) {
                    this.parseTimeZone(string, 5, n2);
                }
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gDay"}));
            }
            this.setMonth0(DateTimeUtil.parseInt(string, 2, 4));
            if (n2 == 4) {
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
            }
            if (string.charAt(4) == '+' || string.charAt(4) == 'Z') {
                this.parseTimeZone(string, 4, n2);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
            }
            if (string.charAt(4) != '-' || n2 < 6) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth/gMonthDay"}));
            int n3 = 5;
            if (string.charAt(n3) == '-') {
                ++n3;
                if (n2 == 6) {
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
                }
                if (string.charAt(n3) == '-' || string.charAt(n3) == '+' || string.charAt(n3) == 'Z') {
                    this.parseTimeZone(string, n3, n2);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
                }
            }
            if (n3 + 2 > n2) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth/gMonthDay"}));
            int n4 = DateTimeUtil.parseInt(string, n3, n3 + 2);
            int n5 = n3 - 1;
            if (n3 + 2 == n2 || string.charAt(n3 + 2) != ':') {
                this.setDay0(n4);
                if (n3 + 2 == n2) {
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonthDay"}));
                }
                n5 = n3 + 2;
            }
            this.parseTimeZone(string, n5, n2);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
        }
        if (string.charAt(2) == ':') {
            this.parseTime(string, 0, n2);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "time"}));
        }
        int n6 = DateTimeUtil.indexOf(string, 1, n2, '-');
        if (n6 != -1) {
            this.setYearAfterCheck(string, n6);
            if (n6 + 2 >= n2) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear"}));
            n = DateTimeUtil.parseInt(string, ++n6, n6 + 2);
            if (n6 + 2 == n2) {
                this.setMonth0(n);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYearMonth"}));
            }
            if (string.charAt(n6 + 2) == ':') {
                this.parseTimeZone(string, n6 - 1, n2);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYearMonth"}));
            }
            if (string.charAt(n6 + 2) != '-' && string.charAt(n6 + 2) != '+' && string.charAt(n6 + 2) != 'Z') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear/gYearMonth/date/datetime"}));
            }
        } else {
            n6 = DateTimeUtil.indexOf(string, 1, n2, '+');
            if (n6 == -1) {
                n6 = DateTimeUtil.indexOf(string, 1, n2, 'Z');
            }
            this.setYearAfterCheck(string, n6 != -1 ? n6 : n2);
            if (n6 != -1) {
                this.parseTimeZone(string, n6, n2);
            }
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear"}));
        }
        this.setMonth0(n);
        if ((n6 += 2) >= n2) return;
        if (string.charAt(n6) == '-' && n6 + 2 < n2) {
            n = DateTimeUtil.parseInt(string, ++n6, n6 + 2);
            if (n6 + 2 < n2) {
                if (string.charAt(n6 + 2) == ':') {
                    this.parseTimeZone(string, n6 - 1, n2);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
                }
                if (string.charAt(n6 + 2) == 'T') {
                    this.setDay0(n);
                    this.parseTime(string, n6 + 3, n2);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "datetime"}));
                }
                if (string.charAt(n6 + 2) != '-' && string.charAt(n6 + 2) != '+' && string.charAt(n6 + 2) != 'Z') throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
                this.setDay0(n);
                this.parseTimeZone(string, n6 + 2, n2);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "datetime"}));
            }
            this.setDay0(n);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "date"}));
        }
        if ((string.charAt(n6) != '+' || n6 + 6 != n2) && (string.charAt(n6) != 'Z' || n6 + 1 != n2)) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
        this.parseTimeZone(string, n6, n2);
        if (this.isValid()) return;
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
    }

    private void setYearAfterCheck(String string, int n) {
        int n2 = string.charAt(0) == '-' ? 1 : 0;
        int n3 = n - n2;
        if (string.charAt(n2) == '0' && n3 > 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "NoLeadingZeros", new Object[]{string}));
        }
        if (n3 < 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearSyntax", new Object[]{string}));
        }
        if (n3 < 10) {
            int n4 = DateTimeUtil.parseInt(string, n2, n);
            this.setYear0(n2 == 0 ? n4 : -n4);
        } else {
            try {
                this.setYear0(new BigInteger(string.substring(0, n)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
        }
    }

    public XMLGregorianCalendarImpl(GregorianCalendar gregorianCalendar) {
        this.setYear0(gregorianCalendar.get(0) == 0 ? -gregorianCalendar.get(1) : gregorianCalendar.get(1));
        this.setMonth0(gregorianCalendar.get(2) + 1);
        this.setDay0(gregorianCalendar.get(5));
        this.setHour0(gregorianCalendar.get(9) == 0 ? gregorianCalendar.get(10) : 12 + gregorianCalendar.get(10));
        this.setMinute0(gregorianCalendar.get(12));
        this.setSecond0(gregorianCalendar.get(13));
        this.setMillisecond0(gregorianCalendar.get(14));
        this.setTimezone0((gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000);
    }

    public XMLGregorianCalendarImpl(BigInteger bigInteger, int n, int n2, int n3, int n4, int n5, BigDecimal bigDecimal, int n6) {
        this.setYear0(bigInteger);
        this.setMonth0(n);
        this.setDay0(n2);
        this.setHour0(n3);
        this.setMinute0(n4);
        this.setSecond0(n5);
        this.setFractionalSecond0(bigDecimal);
        this.setTimezone0(n6);
    }

    public XMLGregorianCalendarImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setYear0(n);
        this.setMonth0(n2);
        this.setDay0(n3);
        this.setHour0(n4);
        this.setMinute0(n5);
        this.setSecond0(n6);
        if (n7 == Integer.MIN_VALUE) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
        } else {
            if (n7 < 0 || n7 > 1000) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"millisecond", "0", "1000", String.valueOf(this.millisecond)}));
            }
            this.millisecond = n7 + 196608;
            this.fracSeconds = null;
        }
        this.setTimezone0(n8);
    }

    public XMLGregorianCalendarImpl(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7) {
        this.setYear0(n);
        this.setMonth0(n2);
        this.setDay0(n3);
        this.setHour0(n4);
        this.setMinute0(n5);
        this.setSecond0(n6);
        this.setFractionalSecond0(bigDecimal);
        this.setTimezone0(n7);
    }

    private void saveInitialValues() {
        if (this.initialValues == null) {
            this.initialValues = new XMLGregorianCalendarSnapshot(this);
        }
    }

    private void parseTime(String string, int n, int n2) throws RuntimeException {
        int n3 = n + 2;
        this.setHour0(DateTimeUtil.parseInt(string, n, n3));
        if (n3 >= n2) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
        }
        if (string.charAt(n3++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        n = n3;
        this.setMinute0(DateTimeUtil.parseInt(string, n, n3 += 2));
        if (n3 >= n2) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
        }
        if (string.charAt(n3++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        int n4 = this.findUTCSign(string, n, n2);
        n = n3;
        n3 = n4 < 0 ? n2 : n4;
        int n5 = DateTimeUtil.indexOf(string, n, n3, '.');
        this.setSecond0(DateTimeUtil.parseInt(string, n, n5 != -1 ? n5 : n3));
        if (n5 != -1) {
            try {
                int n6 = n3 - n5;
                if (n6 > 1 && n6 <= 4) {
                    int n7 = DateTimeUtil.parseInt(string, n5 + 1, n3);
                    if (n6 == 2) {
                        n7 *= 100;
                    } else if (n6 == 3) {
                        n7 = (n7 << 3) + (n7 << 1);
                    }
                    this.millisecond = n7 + (n6 - 1 << 16);
                } else {
                    this.millisecond = -1;
                    this.fracSeconds = new BigDecimal(string.substring(n5, n3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
            }
        }
        if (n4 > 0) {
            this.getTimeZone(string, n4, n2);
        }
    }

    private void parseTimeZone(String string, int n, int n2) throws RuntimeException {
        if (n < n2) {
            int n3 = this.findUTCSign(string, n, n2);
            if (n3 < 0) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            this.getTimeZone(string, n3, n2);
        }
    }

    private int findUTCSign(String string, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == 'Z' || c == '+' || c == '-') {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void getTimeZone(String string, int n, int n2) throws RuntimeException {
        int n3;
        int n4;
        if (string.charAt(n) == 'Z') {
            if (n2 > ++n) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            this.setTimezone0(0);
            return;
        }
        if (n <= n2 - 6) {
            int n5 = string.charAt(n) == '-' ? -1 : 1;
            int n6 = ++n + 2;
            n4 = n5 * DateTimeUtil.parseInt(string, n, n6);
            if (string.charAt(n6++) != ':') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            n3 = n5 * DateTimeUtil.parseInt(string, n6, n6 + 2);
            if (n6 + 2 != n2) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
        } else {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        this.setTimezone0(n4 * 60 + n3);
    }

    public void clear() {
        this.saveInitialValues();
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.millisecond = Integer.MIN_VALUE;
        this.fracSeconds = null;
        this.timezone = Integer.MIN_VALUE;
    }

    public void reset() {
        if (this.initialValues != null) {
            this.eon = this.initialValues.eon;
            this.year = this.initialValues.year;
            this.month = this.initialValues.month;
            this.day = this.initialValues.day;
            this.hour = this.initialValues.hour;
            this.minute = this.initialValues.minute;
            this.second = this.initialValues.second;
            this.millisecond = this.initialValues.millisecond;
            this.fracSeconds = this.initialValues.fracSeconds;
            this.timezone = this.initialValues.timezone;
        }
    }

    public void setYear(BigInteger bigInteger) {
        this.saveInitialValues();
        this.setYear0(bigInteger);
    }

    private void setYear0(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
            return;
        }
        if (bigInteger.compareTo(MAX_INT_B) >= 0 || bigInteger.compareTo(MAX_INT_B_NEGATIVE) <= 0) {
            BigInteger bigInteger2 = bigInteger.remainder(MAX_INT_B);
            this.eon = bigInteger.subtract(bigInteger2);
            this.year = bigInteger2.intValue();
        } else {
            this.eon = null;
            this.year = bigInteger.intValue();
        }
    }

    public void setYear(int n) {
        this.saveInitialValues();
        this.setYear0(n);
    }

    private void setYear0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.year = n;
            this.eon = null;
            return;
        }
        if (n < 1000000000 && n > -1000000000) {
            this.eon = null;
            this.year = n;
        } else {
            this.setYear0(BigInteger.valueOf(n));
        }
    }

    private int maxDaysInMonthFor(BigInteger bigInteger, int n) {
        if (n == 4 || n == 6 || n == 9 || n == 11) {
            return 30;
        }
        if (n == 2) {
            if (XMLGregorianCalendarImpl.isLeapYear(bigInteger)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(BigInteger bigInteger) {
        return bigInteger.mod(BigInteger.valueOf(4L)).equals(BigInteger.ZERO) && (!bigInteger.mod(BigInteger.valueOf(100L)).equals(BigInteger.ZERO) || bigInteger.mod(BigInteger.valueOf(400L)).equals(BigInteger.ZERO));
    }

    private int maxDaysInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (XMLGregorianCalendarImpl.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public void setMonth(int n) {
        this.saveInitialValues();
        this.setMonth0(n);
    }

    private void setMonth0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.month = n;
            return;
        }
        if (n <= 0 || n > 12) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"month", "1", "12", String.valueOf(n)}));
        }
        this.month = n;
    }

    public void setDay(int n) {
        this.saveInitialValues();
        this.setDay0(n);
    }

    private void setDay0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.day = n;
            return;
        }
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"day", "1", "31", String.valueOf(n)}));
        }
        this.day = n;
    }

    public void setTimezone(int n) {
        this.saveInitialValues();
        this.setTimezone0(n);
    }

    private void setTimezone0(int n) {
        if (n < -840 && n != Integer.MIN_VALUE || n > 840) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"offset", "-840", "840", String.valueOf(n)}));
        }
        this.timezone = n;
    }

    public void setHour(int n) {
        this.saveInitialValues();
        this.setHour0(n);
    }

    private void setHour0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.hour = n;
            return;
        }
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"hour", "0", "24", String.valueOf(n)}));
        }
        this.hour = n;
    }

    public void setMinute(int n) {
        this.saveInitialValues();
        this.setMinute0(n);
    }

    private void setMinute0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.minute = n;
            return;
        }
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"minute", "0", "59", String.valueOf(n)}));
        }
        this.minute = n;
    }

    public void setSecond(int n) {
        this.saveInitialValues();
        this.setSecond0(n);
    }

    private void setSecond0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.second = n;
            return;
        }
        if (n < 0 || n > 60) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"second", "0", "60", String.valueOf(n)}));
        }
        this.second = n;
    }

    public void setMillisecond(int n) {
        this.saveInitialValues();
        this.setMillisecond0(n);
    }

    private void setMillisecond0(int n) {
        if (n == Integer.MIN_VALUE) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
            return;
        }
        if (n < 0 || n > 999) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"millisecond", "0", "1000", String.valueOf(n)}));
        }
        this.millisecond = n + 196608;
        this.fracSeconds = null;
    }

    public void setFractionalSecond(BigDecimal bigDecimal) {
        this.saveInitialValues();
        this.setFractionalSecond0(bigDecimal);
    }

    private void setFractionalSecond0(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
            return;
        }
        if (bigDecimal.compareTo(ZERO) < 0 || bigDecimal.compareTo(ONE) > 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"fractional", "0.0", "1.0", bigDecimal}));
        }
        int n = bigDecimal.scale();
        if (n > 0 && n <= 3) {
            int n2 = bigDecimal.unscaledValue().intValue();
            if (n == 1) {
                n2 *= 100;
            } else if (n == 2) {
                n2 = (n2 << 3) + (n2 << 1);
            }
            this.millisecond = n2 + (n << 16);
        } else {
            this.millisecond = -1;
        }
        this.fracSeconds = bigDecimal;
    }

    public BigInteger getEon() {
        return this.eon;
    }

    public int getYear() {
        return this.year;
    }

    public BigInteger getEonAndYear() {
        if (this.year != Integer.MIN_VALUE) {
            if (this.eon != null) {
                if (this.year != 0) {
                    return this.eon.add(BigInteger.valueOf(this.year));
                }
                return this.eon;
            }
            return BigInteger.valueOf(this.year);
        }
        return null;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        if (this.millisecond != Integer.MIN_VALUE) {
            if (this.millisecond != -1) {
                return this.millisecond & 0xFFFF;
            }
            return super.getMillisecond();
        }
        return Integer.MIN_VALUE;
    }

    public BigDecimal getFractionalSecond() {
        if (this.fracSeconds != null) {
            return this.fracSeconds;
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            int n = this.millisecond >> 16;
            int n2 = this.millisecond & 0xFFFF;
            if (n == 1) {
                n2 /= 100;
            } else if (n == 2) {
                n2 /= 10;
            }
            this.fracSeconds = BigDecimal.valueOf(n2, n);
        }
        return this.fracSeconds;
    }

    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        QName qName = null;
        QName qName2 = null;
        try {
            qName = xMLGregorianCalendar.getXMLSchemaType();
            qName2 = this.getXMLSchemaType();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!(qName == qName2 || qName != null && qName2 != null && qName.equals(qName2))) {
            return 2;
        }
        XMLGregorianCalendar xMLGregorianCalendar2 = this.normalize();
        XMLGregorianCalendar xMLGregorianCalendar3 = xMLGregorianCalendar.normalize();
        if (xMLGregorianCalendar2.getTimezone() == xMLGregorianCalendar3.getTimezone()) {
            return this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar3);
        }
        if (xMLGregorianCalendar2.getTimezone() == 0) {
            XMLGregorianCalendar xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(840);
            int n = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n == -1) {
                return n;
            }
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(-840);
            int n2 = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n2 == 1) {
                return n2;
            }
            return 2;
        }
        if (xMLGregorianCalendar3.getTimezone() == 0) {
            XMLGregorianCalendar xMLGregorianCalendar5 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar5.setTimezone(-840);
            int n = this.compareOrder(xMLGregorianCalendar5.normalize(), xMLGregorianCalendar3);
            if (n == -1) {
                return n;
            }
            xMLGregorianCalendar5 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar5.setTimezone(840);
            int n3 = this.compareOrder(xMLGregorianCalendar5.normalize(), xMLGregorianCalendar3);
            if (n3 == 1) {
                return n3;
            }
            return 2;
        }
        return 2;
    }

    private int compareOrder(XMLGregorianCalendar xMLGregorianCalendar, XMLGregorianCalendar xMLGregorianCalendar2) {
        BigDecimal bigDecimal;
        int n;
        BigInteger bigInteger;
        BigInteger bigInteger2 = xMLGregorianCalendar.getEonAndYear();
        if (bigInteger2 != (bigInteger = xMLGregorianCalendar2.getEonAndYear())) {
            if (bigInteger2 == null || bigInteger == null) {
                return 2;
            }
            n = bigInteger2.compareTo(bigInteger);
            if (n != 0) {
                if (n == 1) {
                    return 1;
                }
                return -1;
            }
        }
        if ((n = this.checkValue(xMLGregorianCalendar.getMonth(), xMLGregorianCalendar2.getMonth())) != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getDay());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getHour(), xMLGregorianCalendar2.getHour());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getMinute(), xMLGregorianCalendar2.getMinute());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getSecond(), xMLGregorianCalendar2.getSecond());
        if (n != 0) {
            return n;
        }
        BigDecimal bigDecimal2 = xMLGregorianCalendar.getFractionalSecond();
        if (bigDecimal2 == (bigDecimal = xMLGregorianCalendar2.getFractionalSecond())) {
            return 0;
        }
        n = (bigDecimal2 == null ? ZERO : bigDecimal2).compareTo(bigDecimal == null ? ZERO : bigDecimal);
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return -1;
    }

    private int checkValue(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
            return 2;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public XMLGregorianCalendar normalize() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = this;
        if (this.timezone != Integer.MIN_VALUE && this.timezone != 0) {
            xMLGregorianCalendarImpl = (XMLGregorianCalendarImpl)this.clone();
            xMLGregorianCalendarImpl.add(new DurationImpl(this.timezone > 0 ? -1 : 1, I_ZERO, I_ZERO, I_ZERO, I_ZERO, this.timezone > 0 ? BigInteger.valueOf(this.timezone) : BigInteger.valueOf(-this.timezone), ZERO));
            xMLGregorianCalendarImpl.timezone = 0;
            xMLGregorianCalendarImpl.initialValues = null;
        }
        return xMLGregorianCalendarImpl;
    }

    public String toXMLFormat() {
        QName qName = this.getXMLSchemaType();
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        if (qName == DatatypeConstants.DATETIME) {
            this.writeYear(xMLStringBuffer);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
            xMLStringBuffer.append('T');
            this.writeIntTwoDigits(xMLStringBuffer, this.hour);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.minute);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeMilliseconds(xMLStringBuffer);
                } else {
                    xMLStringBuffer.append(this.toString(this.fracSeconds).substring(1));
                }
            }
        } else if (qName == DatatypeConstants.DATE) {
            this.writeYear(xMLStringBuffer);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        } else if (qName == DatatypeConstants.TIME) {
            this.writeIntTwoDigits(xMLStringBuffer, this.hour);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.minute);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeMilliseconds(xMLStringBuffer);
                } else {
                    xMLStringBuffer.append(this.toString(this.fracSeconds).substring(1));
                }
            }
        } else if (qName == DatatypeConstants.GYEAR) {
            this.writeYear(xMLStringBuffer);
        } else if (qName == DatatypeConstants.GMONTH) {
            xMLStringBuffer.append("--");
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append("--");
        } else if (qName == DatatypeConstants.GDAY) {
            xMLStringBuffer.append("---");
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            this.writeYear(xMLStringBuffer);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            xMLStringBuffer.append("--");
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        }
        return this.getTimezoneString(xMLStringBuffer);
    }

    private void writeYear(XMLStringBuffer xMLStringBuffer) {
        if (this.eon == null) {
            int n = this.year;
            if (n < 0) {
                xMLStringBuffer.append('-');
                n = -this.year;
            }
            if (n < 10000) {
                this.writeIntFourDigits(xMLStringBuffer, n);
            } else {
                xMLStringBuffer.append(Integer.toString(n));
            }
        } else {
            xMLStringBuffer.append(this.getEonAndYear().toString());
        }
    }

    private void writeIntTwoDigits(XMLStringBuffer xMLStringBuffer, int n) {
        int n2 = n / 10;
        int n3 = n - (n2 << 3) - (n2 << 1);
        xMLStringBuffer.append((char)(n2 + 48));
        xMLStringBuffer.append((char)(n3 + 48));
    }

    private void writeIntFourDigits(XMLStringBuffer xMLStringBuffer, int n) {
        int n2 = n / 10;
        int n3 = n - (n2 << 3) - (n2 << 1);
        n = n2;
        n2 = n / 10;
        int n4 = n - (n2 << 3) - (n2 << 1);
        n = n2;
        n2 = n / 10;
        int n5 = n - (n2 << 3) - (n2 << 1);
        xMLStringBuffer.append((char)(n2 + 48));
        xMLStringBuffer.append((char)(n5 + 48));
        xMLStringBuffer.append((char)(n4 + 48));
        xMLStringBuffer.append((char)(n3 + 48));
    }

    private void writeMilliseconds(XMLStringBuffer xMLStringBuffer) {
        int n = this.millisecond >> 16;
        int n2 = this.millisecond & 0xFFFF;
        xMLStringBuffer.append('.');
        int n3 = n2 / 10;
        int n4 = n2 - (n3 << 3) - (n3 << 1);
        n2 = n3;
        n3 = n2 / 10;
        int n5 = n2 - (n3 << 3) - (n3 << 1);
        xMLStringBuffer.append((char)(n3 + 48));
        if (n > 1) {
            xMLStringBuffer.append((char)(n5 + 48));
            if (n > 2) {
                xMLStringBuffer.append((char)(n4 + 48));
            }
        }
    }

    private String getTimezoneString(XMLStringBuffer xMLStringBuffer) {
        if (this.timezone != Integer.MIN_VALUE) {
            if (this.timezone != 0) {
                int n = this.timezone < 0 ? -1 : 1;
                int n2 = this.timezone / 60 * n;
                int n3 = this.timezone % 60 * n;
                xMLStringBuffer.append(n == -1 ? (char)'-' : '+');
                this.writeIntTwoDigits(xMLStringBuffer, n2);
                xMLStringBuffer.append(':');
                this.writeIntTwoDigits(xMLStringBuffer, n3);
                return xMLStringBuffer.toString();
            }
            xMLStringBuffer.append('Z');
            return xMLStringBuffer.toString();
        }
        return xMLStringBuffer.toString();
    }

    public QName getXMLSchemaType() {
        boolean bl;
        boolean bl2 = this.hour != Integer.MIN_VALUE;
        boolean bl3 = this.minute != Integer.MIN_VALUE;
        boolean bl4 = bl = this.second != Integer.MIN_VALUE;
        if (bl2 && bl3 && bl) {
            if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE) {
                return DatatypeConstants.DATETIME;
            }
            if (this.year == Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day == Integer.MIN_VALUE) {
                return DatatypeConstants.TIME;
            }
        } else if (!(bl2 || bl3 || bl)) {
            boolean bl5;
            boolean bl6 = this.year != Integer.MIN_VALUE;
            boolean bl7 = this.month != Integer.MIN_VALUE;
            boolean bl8 = bl5 = this.day != Integer.MIN_VALUE;
            if (bl6) {
                if (bl7 && bl5) {
                    return DatatypeConstants.DATE;
                }
                if (bl7 && !bl5) {
                    return DatatypeConstants.GYEARMONTH;
                }
                if (!bl7 && !bl5) {
                    return DatatypeConstants.GYEAR;
                }
            } else {
                if (bl7) {
                    if (bl5) {
                        return DatatypeConstants.GMONTHDAY;
                    }
                    return DatatypeConstants.GMONTH;
                }
                if (bl5) {
                    return DatatypeConstants.GDAY;
                }
            }
        }
        throw new IllegalStateException(DatatypeMessageFormatter.formatMessage(null, "InvalidFieldsSet", new Object[]{this.year != Integer.MIN_VALUE ? String.valueOf(this.year) : "FIELD_UNDEFINED", this.month != Integer.MIN_VALUE ? String.valueOf(this.month) : "FIELD_UNDEFINED", this.day != Integer.MIN_VALUE ? String.valueOf(this.day) : "FIELD_UNDEFINED", this.hour != Integer.MIN_VALUE ? String.valueOf(this.hour) : "FIELD_UNDEFINED", this.minute != Integer.MIN_VALUE ? String.valueOf(this.minute) : "FIELD_UNDEFINED", this.second != Integer.MIN_VALUE ? String.valueOf(this.second) : "FIELD_UNDEFINED", this.millisecond != Integer.MIN_VALUE ? this.getFractionalSecond().toString() : "FIELD_UNDEFINED", this.timezone != Integer.MIN_VALUE ? String.valueOf(this.timezone) : "FIELD_UNDEFINED"}));
    }

    public boolean isValid() {
        if (this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && (this.year != Integer.MIN_VALUE ? this.day > this.maxDaysInMonthFor(this.year, this.month) : this.day > this.maxDaysInMonthFor(2000, this.month))) {
            return false;
        }
        if (this.hour == 24 && (this.minute != 0 || this.second != 0)) {
            return false;
        }
        if (this.eon == null && this.year == 0) {
            return false;
        }
        return this.millisecond == Integer.MIN_VALUE || this.second != Integer.MIN_VALUE;
    }

    public void add(Duration duration) {
        this.saveInitialValues();
        boolean[] blArray = new boolean[]{this.eon == null, this.year == Integer.MIN_VALUE, this.month == Integer.MIN_VALUE, this.day == Integer.MIN_VALUE, this.hour == Integer.MIN_VALUE, this.minute == Integer.MIN_VALUE, this.second == Integer.MIN_VALUE, this.millisecond == Integer.MIN_VALUE};
        int n = duration.getSign();
        BigInteger bigInteger = (BigInteger)duration.getField(DatatypeConstants.MONTHS);
        BigInteger bigInteger2 = BigInteger.valueOf(this.month != Integer.MIN_VALUE ? (long)this.month : 1L).add(bigInteger != null ? (n == -1 ? bigInteger.negate() : bigInteger) : I_ZERO);
        this.month = DateTimeUtil.modulo(bigInteger2, I_ONE, THIRTEEN).intValue();
        BigInteger bigInteger3 = DateTimeUtil.fQuotient(bigInteger2, I_ONE, THIRTEEN);
        BigInteger bigInteger4 = this.getEonAndYear();
        BigInteger bigInteger5 = (BigInteger)duration.getField(DatatypeConstants.YEARS);
        this.setYear0((bigInteger4 != null ? bigInteger4 : I_ZERO).add(bigInteger5 != null ? (n == -1 ? bigInteger5.negate() : bigInteger5) : I_ZERO).add(bigInteger3));
        BigDecimal bigDecimal = duration.isSet(DatatypeConstants.SECONDS) ? (n == -1 ? ((BigDecimal)duration.getField(DatatypeConstants.SECONDS)).negate() : (BigDecimal)duration.getField(DatatypeConstants.SECONDS)) : ZERO;
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, 2);
        int n2 = (this.second != Integer.MIN_VALUE ? this.second : 0) + bigDecimal2.intValue();
        if (this.getFractionalSecond() != null) {
            this.millisecond = -1;
        }
        BigDecimal bigDecimal3 = this.fracSeconds != null ? (n > 0 ? this.fracSeconds.subtract(bigDecimal.subtract(bigDecimal2)) : this.fracSeconds.add(bigDecimal.subtract(bigDecimal2))) : (this.fracSeconds = bigDecimal.subtract(bigDecimal2));
        if (this.fracSeconds != null) {
            this.millisecond = -1;
        }
        int n3 = DateTimeUtil.fQuotient(n2, 60);
        this.second = DateTimeUtil.mod(n2, 60, n3);
        n2 = (this.minute != Integer.MIN_VALUE ? this.minute : 0) + n * duration.getMinutes() + n3;
        n3 = DateTimeUtil.fQuotient(n2, 60);
        this.minute = DateTimeUtil.mod(n2, 60, n3);
        n2 = (this.hour != Integer.MIN_VALUE ? this.hour : 0) + n * duration.getHours() + n3;
        n3 = DateTimeUtil.fQuotient(n2, 24);
        this.hour = DateTimeUtil.mod(n2, 24, n3);
        this.day = (this.day != Integer.MIN_VALUE ? this.day : 1) + n * duration.getDays() + n3;
        while (true) {
            int n4 = this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), this.month != Integer.MIN_VALUE ? this.month : 1) : (n2 = DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, this.month != Integer.MIN_VALUE ? this.month : 1));
            if (this.month < 1) {
                this.month += 12;
                BigInteger bigInteger6 = this.getEonAndYear();
                if (bigInteger6 != null) {
                    this.setYear0(bigInteger6.subtract(I_ONE));
                    continue;
                }
                this.setYear0(-1);
                continue;
            }
            if (this.month > 12) {
                this.month -= 12;
                BigInteger bigInteger7 = this.getEonAndYear();
                if (bigInteger7 != null) {
                    this.setYear0(bigInteger7.add(I_ONE));
                    continue;
                }
                this.setYear0(1);
                continue;
            }
            if (this.day < 1) {
                this.day += this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), (this.month != Integer.MIN_VALUE ? this.month : 1) - 1) : DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, (this.month != Integer.MIN_VALUE ? this.month : 1) - 1);
                n3 = -1;
            } else if (this.day > n2) {
                this.day -= n2;
                n3 = 1;
            } else {
                if (this.hour < 0) {
                    this.hour += 24;
                    --this.day;
                    continue;
                }
                if (this.hour > 24) {
                    this.hour -= 24;
                    ++this.day;
                    continue;
                }
                if (this.minute < 0) {
                    this.minute += 60;
                    --this.hour;
                    continue;
                }
                if (this.minute > 60) {
                    this.minute -= 60;
                    ++this.hour;
                    continue;
                }
                if (this.second < 0) {
                    this.second += 60;
                    --this.minute;
                    continue;
                }
                if (this.second > 60) {
                    this.second -= 60;
                    ++this.minute;
                    continue;
                }
                if (this.fracSeconds.compareTo(ZERO) == -1) {
                    this.fracSeconds = this.fracSeconds.add(ONE);
                    --this.second;
                    continue;
                }
                if (this.fracSeconds.compareTo(ONE) != 1) break;
                this.fracSeconds = this.fracSeconds.subtract(ONE);
                ++this.second;
                continue;
            }
            n2 = this.month + n3;
            this.month = DateTimeUtil.modulo(n2, 1, 13);
            int n5 = DateTimeUtil.fQuotient(n2, 1, 13);
            this.setYear0(this.year + n5);
        }
        if (blArray[0] && blArray[1]) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        }
        if (blArray[2]) {
            this.month = Integer.MIN_VALUE;
        }
        if (blArray[3]) {
            this.day = Integer.MIN_VALUE;
        }
        if (blArray[4]) {
            this.hour = Integer.MIN_VALUE;
        }
        if (blArray[5]) {
            this.minute = Integer.MIN_VALUE;
        }
        if (blArray[6] && blArray[7]) {
            this.second = Integer.MIN_VALUE;
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
        }
    }

    public GregorianCalendar toGregorianCalendar() {
        return this.toGregorianCalendar(null, null, null);
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timeZone, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl;
        boolean bl2 = bl = xMLGregorianCalendar != null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone != null ? timeZone : this.getTimeZone(bl ? xMLGregorianCalendar.getTimezone() : Integer.MIN_VALUE), locale != null ? locale : Locale.getDefault());
        gregorianCalendar.clear();
        gregorianCalendar.setGregorianChange(PURE_GREGORIAN_CALENDAR_CHANGE);
        if (this.year != Integer.MIN_VALUE) {
            if (this.eon == null) {
                gregorianCalendar.set(0, this.year < 0 ? 0 : 1);
                gregorianCalendar.set(1, Math.abs(this.year));
            } else {
                BigInteger bigInteger = this.getEonAndYear();
                gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
                gregorianCalendar.set(1, bigInteger.abs().intValue());
            }
        } else if (bl && (n7 = xMLGregorianCalendar.getYear()) != Integer.MIN_VALUE) {
            if (xMLGregorianCalendar.getEon() == null) {
                gregorianCalendar.set(0, n7 < 0 ? 0 : 1);
                gregorianCalendar.set(1, Math.abs(n7));
            } else {
                BigInteger bigInteger = xMLGregorianCalendar.getEonAndYear();
                gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
                gregorianCalendar.set(1, bigInteger.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, this.month - 1);
        } else if (bl && (n6 = xMLGregorianCalendar.getMonth()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, n6 - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, this.day);
        } else if (bl && (n5 = xMLGregorianCalendar.getDay()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, n5);
        }
        if (this.hour != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, this.hour);
        } else if (bl && (n4 = xMLGregorianCalendar.getHour()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, n4);
        }
        if (this.minute != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, this.minute);
        } else if (bl && (n3 = xMLGregorianCalendar.getMinute()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, n3);
        }
        if (this.second != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, this.second);
        } else if (bl && (n2 = xMLGregorianCalendar.getSecond()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, n2);
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            gregorianCalendar.set(14, this.getMillisecond());
        } else if (bl && (n = xMLGregorianCalendar.getMillisecond()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(14, n);
        }
        return gregorianCalendar;
    }

    public TimeZone getTimeZone(int n) {
        int n2;
        int n3 = n2 = this.timezone != Integer.MIN_VALUE ? this.timezone : n;
        if (n2 == Integer.MIN_VALUE) {
            return TimeZone.getDefault();
        }
        int n4 = n2 >= 0 ? n2 : -n2;
        int n5 = n4 / 60;
        int n6 = n4 % 60;
        StringBuffer stringBuffer = new StringBuffer(9);
        stringBuffer.append("GMT");
        stringBuffer.append(n2 >= 0 ? (char)'+' : '-');
        if (n5 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5);
        stringBuffer.append(':');
        if (n6 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n6);
        return TimeZone.getTimeZone(stringBuffer.toString());
    }

    public Object clone() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = new XMLGregorianCalendarImpl();
        xMLGregorianCalendarImpl.eon = this.eon;
        xMLGregorianCalendarImpl.year = this.year;
        xMLGregorianCalendarImpl.month = this.month;
        xMLGregorianCalendarImpl.day = this.day;
        xMLGregorianCalendarImpl.hour = this.hour;
        xMLGregorianCalendarImpl.minute = this.minute;
        xMLGregorianCalendarImpl.second = this.second;
        xMLGregorianCalendarImpl.millisecond = this.millisecond;
        xMLGregorianCalendarImpl.fracSeconds = this.fracSeconds;
        xMLGregorianCalendarImpl.timezone = this.timezone;
        xMLGregorianCalendarImpl.initialValues = this.initialValues;
        return xMLGregorianCalendarImpl;
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuffer stringBuffer;
        String string = bigDecimal.unscaledValue().toString();
        int n = bigDecimal.scale();
        if (n == 0) {
            return string;
        }
        int n2 = string.length() - n;
        if (n2 == 0) {
            return "0." + string;
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n2, '.');
        } else {
            stringBuffer = new StringBuffer(3 - n2 + string.length());
            stringBuffer.append("0.");
            int n3 = 0;
            while (n3 < -n2) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private Object writeReplace() throws IOException {
        return new SerializedXMLGregorianCalendar(this.toXMLFormat());
    }

    public boolean isFractionalSecondInMilliseconds() {
        return this.millisecond != Integer.MIN_VALUE && this.millisecond != -1;
    }

    public int getFractionalSecondScale() {
        if (this.fracSeconds != null) {
            return this.fracSeconds.scale();
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            return this.millisecond >> 16;
        }
        return Integer.MIN_VALUE;
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarDateTime(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setTime(0, 0, 0);
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarDate(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarTime(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.TIME) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarGYear(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GYEAR) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarGMonth(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GMONTH) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarGDay(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GDAY) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarGYearMonth(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GYEARMONTH) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public XMLGregorianCalendar2 asXMLGregorianCalendarGMonthDay(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GMONTHDAY) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    public String toFOFormat() {
        QName qName = this.getXMLSchemaType();
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        if (qName == DatatypeConstants.DATETIME) {
            if (this.hour != 24) {
                this.writeYear(xMLStringBuffer);
                xMLStringBuffer.append('-');
                this.writeIntTwoDigits(xMLStringBuffer, this.month);
                xMLStringBuffer.append('-');
                this.writeIntTwoDigits(xMLStringBuffer, this.day);
                xMLStringBuffer.append('T');
                this.writeIntTwoDigits(xMLStringBuffer, this.hour);
                xMLStringBuffer.append(':');
            } else {
                this.writeDateOfFollowingDay(xMLStringBuffer);
                xMLStringBuffer.append('T');
                xMLStringBuffer.append("00:");
            }
            this.writeIntTwoDigits(xMLStringBuffer, this.minute);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeFOMilliseconds(xMLStringBuffer);
                } else {
                    this.writeFOFractionalSeconds(xMLStringBuffer);
                }
            }
        } else if (qName == DatatypeConstants.DATE) {
            this.writeYear(xMLStringBuffer);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        } else if (qName == DatatypeConstants.TIME) {
            if (this.hour != 24) {
                this.writeIntTwoDigits(xMLStringBuffer, this.hour != 24 ? this.hour : 0);
                xMLStringBuffer.append(':');
            } else {
                xMLStringBuffer.append("00:");
            }
            this.writeIntTwoDigits(xMLStringBuffer, this.minute);
            xMLStringBuffer.append(':');
            this.writeIntTwoDigits(xMLStringBuffer, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeFOMilliseconds(xMLStringBuffer);
                } else {
                    this.writeFOFractionalSeconds(xMLStringBuffer);
                }
            }
        } else if (qName == DatatypeConstants.GYEAR) {
            this.writeYear(xMLStringBuffer);
        } else if (qName == DatatypeConstants.GMONTH) {
            xMLStringBuffer.append("--");
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
        } else if (qName == DatatypeConstants.GDAY) {
            xMLStringBuffer.append("---");
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            this.writeYear(xMLStringBuffer);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            xMLStringBuffer.append("--");
            this.writeIntTwoDigits(xMLStringBuffer, this.month);
            xMLStringBuffer.append('-');
            this.writeIntTwoDigits(xMLStringBuffer, this.day);
        }
        return this.getTimezoneString(xMLStringBuffer);
    }

    private void writeDateOfFollowingDay(XMLStringBuffer xMLStringBuffer) {
        BigInteger bigInteger = this.eon;
        int n = this.year;
        int n2 = this.month;
        int n3 = this.day;
        if (++n3 > this.maxDaysInMonthFor(n, n2)) {
            n3 = 1;
            if (++n2 > 12) {
                n2 = 1;
                if (++n == 0 && bigInteger == null) {
                    n = 1;
                }
            }
        }
        if (bigInteger == null) {
            int n4 = n;
            if (n4 < 0) {
                xMLStringBuffer.append('-');
                n4 = -n;
            }
            if (n4 < 10000) {
                this.writeIntFourDigits(xMLStringBuffer, n4);
            } else {
                xMLStringBuffer.append(Integer.toString(n4));
            }
        } else {
            BigInteger bigInteger2 = n != 0 ? bigInteger.add(BigInteger.valueOf(n)) : bigInteger;
            xMLStringBuffer.append(bigInteger2.toString());
        }
        xMLStringBuffer.append('-');
        this.writeIntTwoDigits(xMLStringBuffer, n2);
        xMLStringBuffer.append('-');
        this.writeIntTwoDigits(xMLStringBuffer, n3);
    }

    private void writeFOMilliseconds(XMLStringBuffer xMLStringBuffer) {
        int n = this.millisecond & 0xFFFF;
        if (n != 0) {
            xMLStringBuffer.append('.');
            int n2 = n / 10;
            int n3 = n - (n2 << 3) - (n2 << 1);
            n = n2;
            n2 = n / 10;
            int n4 = n - (n2 << 3) - (n2 << 1);
            xMLStringBuffer.append((char)(n2 + 48));
            if (n4 != 0 || n3 != 0) {
                xMLStringBuffer.append((char)(n4 + 48));
                if (n3 != 0) {
                    xMLStringBuffer.append((char)(n3 + 48));
                }
            }
        }
    }

    private void writeFOFractionalSeconds(XMLStringBuffer xMLStringBuffer) {
        if (ZERO.compareTo(this.fracSeconds) != 0) {
            xMLStringBuffer.append(DateTimeUtil.stripTrailingZeros(this.toString(this.fracSeconds).substring(1)));
        }
    }

    private static final class XMLGregorianCalendarSnapshot {
        public final BigInteger eon;
        public final int year;
        public final int month;
        public final int day;
        public final int hour;
        public final int minute;
        public final int second;
        public final int millisecond;
        public final BigDecimal fracSeconds;
        public final int timezone;

        public XMLGregorianCalendarSnapshot(XMLGregorianCalendarImpl xMLGregorianCalendarImpl) {
            this.eon = xMLGregorianCalendarImpl.eon;
            this.year = xMLGregorianCalendarImpl.year;
            this.month = xMLGregorianCalendarImpl.month;
            this.day = xMLGregorianCalendarImpl.day;
            this.hour = xMLGregorianCalendarImpl.hour;
            this.minute = xMLGregorianCalendarImpl.minute;
            this.second = xMLGregorianCalendarImpl.second;
            this.millisecond = xMLGregorianCalendarImpl.millisecond;
            this.fracSeconds = xMLGregorianCalendarImpl.fracSeconds;
            this.timezone = xMLGregorianCalendarImpl.timezone;
        }
    }
}

