/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class ExternalSchemaValidator
implements XMLDocumentFilter,
XMLComponent {
    private ValidatorHandler fValidatorHandler;
    private XMLDocumentHandler fHandler;
    private XMLDocumentSource fDocumentSource;
    private XMLEntityResolver fEntityResolver;
    private XMLErrorHandler fErrorHandler;
    private SymbolTable fSymbolTable;
    private AugsHandler fAugsHandler = new AugsHandler();
    private Augmentations fSavedAugs;
    private NamespaceContext fNamespaceContext;
    private AttributesProxy fAttributesProxy = new AttributesProxy();
    private XMLAttributes fSavedAttributes;
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/symbol-table"};

    public ExternalSchemaValidator(Schema schema, XMLComponentManager xMLComponentManager) {
        this.fValidatorHandler = schema.newValidatorHandler();
        this.fValidatorHandler.setResourceResolver(new LSResourceResolverProxy());
        this.fValidatorHandler.setErrorHandler(new ErrorHandlerProxy());
        this.fValidatorHandler.setContentHandler(this.fAugsHandler);
        this.reset(xMLComponentManager);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fErrorHandler = (XMLErrorHandler)xMLComponentManager.getProperty(ERROR_HANDLER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fErrorHandler = null;
        }
        try {
            this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return this.RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(ERROR_HANDLER)) {
            this.fErrorHandler = (XMLErrorHandler)object;
        } else if (string.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)object;
        } else if (string.equals(SYMBOL_TABLE)) {
            this.fSymbolTable = (SymbolTable)object;
        }
    }

    public Boolean getFeatureDefault(String string) {
        return null;
    }

    public Object getPropertyDefault(String string) {
        return null;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fValidatorHandler.setDocumentLocator(new LocatorProxy(xMLLocator));
        try {
            this.fValidatorHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fHandler != null) {
            this.fHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSavedAugs = augmentations;
        try {
            this.fValidatorHandler.processingInstruction(string, xMLString != null ? xMLString.toString() : null);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSavedAugs = augmentations;
        this.fSavedAttributes = xMLAttributes;
        this.fAttributesProxy.setAttributes(xMLAttributes);
        try {
            this.startNamespaceMapping();
            String string = qName.uri != null ? qName.uri : "";
            String string2 = qName.localpart != null ? qName.localpart : "";
            String string3 = qName.rawname != null ? qName.rawname : "";
            this.fValidatorHandler.startElement(string, string2, string3, this.fAttributesProxy);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            this.fValidatorHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            this.fValidatorHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        try {
            String string = qName.uri != null ? qName.uri : XMLSymbols.EMPTY_STRING;
            String string2 = qName.localpart != null ? qName.localpart : XMLSymbols.EMPTY_STRING;
            String string3 = qName.rawname != null ? qName.rawname : XMLSymbols.EMPTY_STRING;
            this.fValidatorHandler.endElement(string, string2, string3);
            this.endNamespaceMapping();
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fHandler != null) {
            this.fHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        try {
            this.fValidatorHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fHandler != null) {
            this.fHandler.endDocument(augmentations);
        }
    }

    private final void startNamespaceMapping() throws SAXException {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            String string = null;
            String string2 = null;
            int n2 = 0;
            while (n2 < n) {
                string2 = this.fNamespaceContext.getURI(string = this.fNamespaceContext.getDeclaredPrefixAt(n2));
                this.fValidatorHandler.startPrefixMapping(string, string2 == null ? XMLSymbols.EMPTY_STRING : string2);
                ++n2;
            }
        }
    }

    private final void endNamespaceMapping() throws SAXException {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.fValidatorHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(n2));
                ++n2;
            }
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fHandler;
    }

    final class AugsHandler
    extends DefaultHandler {
        private Augmentations fAugs = new AugmentationsImpl();
        private QName fQName = new QName();
        private XMLString fString = new XMLString();

        AugsHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.compareAttrList(attributes);
            if (ExternalSchemaValidator.this.fHandler != null) {
                ExternalSchemaValidator.this.fHandler.startElement(this.getQName(string, string2, string3), ExternalSchemaValidator.this.fSavedAttributes, this.getAugs());
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (ExternalSchemaValidator.this.fHandler != null) {
                ExternalSchemaValidator.this.fHandler.characters(this.getXMLString(cArray, n, n2), this.getAugs());
            }
        }

        private XMLString getXMLString(char[] cArray, int n, int n2) {
            this.fString.setValues(cArray, n, n2);
            return this.fString;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (ExternalSchemaValidator.this.fHandler != null) {
                ExternalSchemaValidator.this.fHandler.endElement(this.getQName(string, string2, string3), this.getAugs());
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (ExternalSchemaValidator.this.fHandler != null) {
                ExternalSchemaValidator.this.fHandler.ignorableWhitespace(this.getXMLString(cArray, n, n2), this.getAugs());
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            if (ExternalSchemaValidator.this.fHandler != null) {
                ExternalSchemaValidator.this.fHandler.processingInstruction(string, this.getXMLString(string2.toCharArray(), 0, string2.length()), this.getAugs());
            }
        }

        private void compareAttrList(Attributes attributes) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getQName(n);
                int n2 = ExternalSchemaValidator.this.fSavedAttributes.getIndex(string);
                if (n2 != -1) {
                    String string2 = attributes.getValue(n);
                    if (!string2.equals(ExternalSchemaValidator.this.fSavedAttributes.getValue(n2))) {
                        ExternalSchemaValidator.this.fSavedAttributes.setValue(n2, string2);
                    }
                } else {
                    ExternalSchemaValidator.this.fSavedAttributes.addAttribute(this.getQName(attributes.getURI(n), attributes.getLocalName(n), string), attributes.getType(n), attributes.getValue(n));
                }
                ++n;
            }
        }

        private Augmentations getAugs() {
            if (ExternalSchemaValidator.this.fSavedAugs != null) {
                Augmentations augmentations = ExternalSchemaValidator.this.fSavedAugs;
                ExternalSchemaValidator.this.fSavedAugs = null;
                return augmentations;
            }
            this.fAugs.removeAllItems();
            return this.fAugs;
        }

        private QName getQName(String string, String string2, String string3) {
            string = string != null && string.length() > 0 ? ExternalSchemaValidator.this.fSymbolTable.addSymbol(string) : null;
            string2 = string2 != null ? ExternalSchemaValidator.this.fSymbolTable.addSymbol(string2) : XMLSymbols.EMPTY_STRING;
            string3 = string3 != null ? ExternalSchemaValidator.this.fSymbolTable.addSymbol(string3) : XMLSymbols.EMPTY_STRING;
            String string4 = XMLSymbols.EMPTY_STRING;
            int n = string3.indexOf(58);
            if (n != -1) {
                string4 = ExternalSchemaValidator.this.fSymbolTable.addSymbol(string3.substring(0, n));
            }
            this.fQName.setValues(string4, string2, string3, string);
            return this.fQName;
        }
    }

    final class ErrorHandlerProxy
    implements ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (ExternalSchemaValidator.this.fErrorHandler != null) {
                ExternalSchemaValidator.this.fErrorHandler.warning(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, ErrorHandlerWrapper.createXMLParseException(sAXParseException));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (ExternalSchemaValidator.this.fErrorHandler == null) {
                throw sAXParseException;
            }
            ExternalSchemaValidator.this.fErrorHandler.error(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, ErrorHandlerWrapper.createXMLParseException(sAXParseException));
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (ExternalSchemaValidator.this.fErrorHandler == null) {
                throw sAXParseException;
            }
            ExternalSchemaValidator.this.fErrorHandler.fatalError(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, ErrorHandlerWrapper.createXMLParseException(sAXParseException));
        }
    }

    final class LSResourceResolverProxy
    implements LSResourceResolver {
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            XMLInputSource xMLInputSource;
            if (ExternalSchemaValidator.this.fEntityResolver == null) {
                return null;
            }
            try {
                xMLInputSource = ExternalSchemaValidator.this.fEntityResolver.resolveEntity(new XMLResourceIdentifierImpl(string3, string4, string5, string4));
            }
            catch (XNIException xNIException) {
                throw xNIException;
            }
            catch (IOException iOException) {
                throw new XNIException(iOException);
            }
            DOMInputImpl dOMInputImpl = new DOMInputImpl(xMLInputSource.getPublicId(), xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId());
            dOMInputImpl.setByteStream(xMLInputSource.getByteStream());
            dOMInputImpl.setCharacterStream(xMLInputSource.getCharacterStream());
            dOMInputImpl.setEncoding(xMLInputSource.getEncoding());
            return dOMInputImpl;
        }
    }

    final class LocatorProxy
    implements Locator {
        private XMLLocator fLocator;

        public LocatorProxy(XMLLocator xMLLocator) {
            this.fLocator = xMLLocator;
        }

        public String getPublicId() {
            return this.fLocator.getPublicId();
        }

        public String getSystemId() {
            return this.fLocator.getExpandedSystemId();
        }

        public int getLineNumber() {
            return this.fLocator.getLineNumber();
        }

        public int getColumnNumber() {
            return this.fLocator.getColumnNumber();
        }
    }

    final class AttributesProxy
    implements Attributes {
        private XMLAttributes fAttributes;

        public void setAttributes(XMLAttributes xMLAttributes) {
            this.fAttributes = xMLAttributes;
        }

        public int getLength() {
            return this.fAttributes.getLength();
        }

        public String getURI(int n) {
            return this.fAttributes.getURI(n);
        }

        public String getLocalName(int n) {
            return this.fAttributes.getLocalName(n);
        }

        public String getQName(int n) {
            return this.fAttributes.getQName(n);
        }

        public String getType(int n) {
            return this.fAttributes.getType(n);
        }

        public String getValue(int n) {
            return this.fAttributes.getValue(n);
        }

        public int getIndex(String string, String string2) {
            return this.fAttributes.getIndex(string, string2);
        }

        public int getIndex(String string) {
            return this.fAttributes.getIndex(string);
        }

        public String getType(String string, String string2) {
            return this.fAttributes.getType(string, string2);
        }

        public String getType(String string) {
            return this.fAttributes.getType(string);
        }

        public String getValue(String string, String string2) {
            return this.fAttributes.getValue(string, string2);
        }

        public String getValue(String string) {
            return this.fAttributes.getValue(string);
        }

        public XMLAttributes getXMLAttributes() {
            return this.fAttributes;
        }
    }
}

