/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.b2b2dtm;

import com.ibm.xml.b2b.util.IOExceptionWrapper;
import com.ibm.xml.b2b.util.RewindableInputStream;
import com.ibm.xml.b2b.util.URI;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.utils.SystemIDResolver;

final class SimpleXMLDeclChecker {
    private static final int CODEPOINT_ILLEGAL = 0;
    private static final int CODEPOINT_WHITESPACE = 1;
    private static final int CODEPOINT_EQUALSIGN = 2;
    private static final int CODEPOINT_SINGLEQUOTE = 3;
    private static final int CODEPOINT_DOUBLEQUOTE = 4;
    private static final int CODEPOINT_LETTER = 5;
    private static final int CODEPOINT_DIGIT = 6;
    private static final int CODEPOINT_HYPHEN = 7;
    private static final int CODEPOINT_UNDERSCORE = 8;
    private static final int CODEPOINT_PERIOD = 9;
    private static final int CODEPOINT_LESSTHAN = 10;
    private static final int CODEPOINT_GREATERTHAN = 11;
    private static final int CODEPOINT_QUESTIONMARK = 12;
    private static final int LITERAL_STARTPIXML = 0;
    private static final int LITERAL_VERSION = 1;
    private static final int LITERAL_VERSION10 = 2;
    private static final int LITERAL_ENCODING = 3;
    private static final int LITERAL_STANDALONE = 4;
    private static final int LITERAL_YES = 5;
    private static final int LITERAL_NO = 6;
    private static final int LITERAL_ENDPI = 7;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte ___ = 0;
    private static final byte WSP = 1;
    private static final byte PER = 9;
    private static final byte LSS = 10;
    private static final byte HYP = 7;
    private static final byte USC = 8;
    private static final byte GTR = 11;
    private static final byte QST = 12;
    private static final byte SQT = 3;
    private static final byte EQL = 2;
    private static final byte DQT = 4;
    private static final byte LTR = 5;
    private static final byte DIG = 6;
    private static final int[] STARTPIXML_Latin = new int[]{60, 63, 120, 109, 108};
    private static final int[] VERSION_Latin = new int[]{118, 101, 114, 115, 105, 111, 110};
    private static final int[] VERSION10_Latin = new int[]{49, 46, 48};
    private static final int[] ENCODING_Latin = new int[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final int[] STANDALONE_Latin = new int[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final int[] YES_Latin = new int[]{121, 101, 115};
    private static final int[] NO_Latin = new int[]{110, 111};
    private static final int[] ENDPI_Latin = new int[]{63, 62};
    private static final byte[] encNameCharMapLatin = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int AUTO_DETECT_ENCODING_UNKNOWN = 0;
    private static final int AUTO_DETECT_ENCODING_UTF8N = 1;
    private static final int AUTO_DETECT_ENCODING_UTF16BE = 2;
    private static final int AUTO_DETECT_ENCODING_UTF16LE = 3;
    private static final int AUTO_DETECT_ENCODING_UTF32BE = 4;
    private static final int AUTO_DETECT_ENCODING_UTF32LE = 5;
    private static final int AUTO_DETECT_ENCODING_LATIN = 6;
    private static final int AUTO_DETECT_ENCODING_EBCDIC = 7;
    private static final int AUTO_DETECT_ENCODING_UCS2BE = 8;
    private static final int AUTO_DETECT_ENCODING_UCS2LE = 9;
    private static final int AUTO_DETECT_ENCODING_UCS4BE = 10;
    private static final int AUTO_DETECT_ENCODING_UCS4LE = 11;
    private RewindableReader fReader;
    private RewindableInputStream fStream;
    private int fBytesPerChar;
    private boolean fIsBigEndian;

    SimpleXMLDeclChecker() {
    }

    public boolean checkXMLDecl(StreamSource source) throws IOException {
        Reader rdr = source.getReader();
        if (rdr != null) {
            RewindableReader rr = this.fReader;
            if (rr == null) {
                rr = this.fReader = new RewindableReader();
            }
            rr.setReader(rdr);
            source.setReader(rr);
            boolean result = this.checkXMLDeclReader(source, rr);
            rr.rewind();
            return result;
        }
        InputStream stream = source.getInputStream();
        RewindableInputStream is = this.fStream;
        if (is == null) {
            is = this.fStream = new RewindableInputStream();
        }
        if (stream == null) {
            String uri = source.getSystemId();
            uri = SystemIDResolver.getAbsoluteURI(uri);
            stream = URI.openStream(uri);
        }
        is.setStream(stream);
        source.setInputStream(is);
        return this.checkXMLDeclStream(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkXMLDeclReader(StreamSource source, Reader rdr) throws IOException {
        int state = 0;
        int ch = this.readChar();
        if (!this.skipReaderLiteral(ch, 0)) {
            return true;
        }
        ch = this.skipReaderSpaces();
        do {
            boolean dquote;
            if (state == 0) {
                if (!this.skipReaderLiteral(ch, 1)) return false;
                state = 1;
            } else if (state == 1 && ch == 101) {
                if (!this.skipReaderLiteral(ch, 3)) return false;
                state = 2;
            } else {
                if (ch != 115) return ch == 63 && this.readChar() == 62;
                if (!this.skipReaderLiteral(ch, 4)) return false;
                state = 3;
            }
            ch = this.skipReaderSpaces();
            if (ch != 61) {
                return false;
            }
            ch = this.skipReaderSpaces();
            boolean bl = dquote = ch == 34;
            if (!dquote && ch != 39) {
                return false;
            }
            int qchar = ch;
            ch = this.readChar();
            switch (state) {
                case 1: {
                    if (!this.skipReaderLiteral(ch, 2) || this.readChar() != qchar) {
                        return false;
                    }
                    ch = this.readChar();
                    if (ch == 32 || ch == 10 || ch == 9 || ch == 13) {
                        ch = this.skipReaderSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanReaderEncodingName(ch, qchar)) {
                        return false;
                    }
                    ch = this.readChar();
                    if (ch == 32 || ch == 10 || ch == 9 || ch == 13) {
                        ch = this.skipReaderSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    if (ch == 121 ? !this.skipReaderLiteral(ch, 5) || this.readChar() != qchar : !this.skipReaderLiteral(ch, 6) || this.readChar() != qchar) {
                        return false;
                    }
                    ch = this.skipReaderSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        return ch == 63 && this.readChar() == 62;
    }

    private int readChar() throws IOException {
        return this.fReader.read();
    }

    private boolean skipReaderLiteral(int firstChar, int literal) throws IOException {
        int b;
        int litLength;
        int[] litData;
        switch (literal) {
            case 0: {
                litData = STARTPIXML_Latin;
                litLength = 5;
                break;
            }
            case 1: {
                litData = VERSION_Latin;
                litLength = 7;
                break;
            }
            case 2: {
                litData = VERSION10_Latin;
                litLength = 3;
                break;
            }
            case 3: {
                litData = ENCODING_Latin;
                litLength = 8;
                break;
            }
            case 4: {
                litData = STANDALONE_Latin;
                litLength = 10;
                break;
            }
            case 5: {
                litData = YES_Latin;
                litLength = 3;
                break;
            }
            case 6: {
                litData = NO_Latin;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (firstChar != litData[0]) {
            return false;
        }
        int i = 1;
        while (i < litLength) {
            b = this.readChar();
            if (b != litData[i]) {
                return false;
            }
            ++i;
        }
        return literal != 0 || (b = this.readChar()) == 32 || b == 10 || b == 9 || b == 13;
    }

    private int skipReaderSpaces() throws IOException {
        int b;
        while ((b = this.readChar()) == 32 || b == 10 || b == 9 || b == 13) {
        }
        return b;
    }

    private boolean scanReaderEncodingName(int firstChar, int qchar) throws IOException {
        int b = firstChar;
        if (b == -1) {
            return false;
        }
        if (b >= 128 || encNameCharMapLatin[b] != 1) {
            return false;
        }
        while ((b = this.readChar()) != qchar) {
            if (b == -1) {
                return false;
            }
            if (b < 128 && encNameCharMapLatin[b] != 0) continue;
            return false;
        }
        return true;
    }

    public boolean checkXMLDeclStream(StreamSource source) throws IOException {
        boolean result;
        switch (SimpleXMLDeclChecker.autoDetectEncoding(this.fStream)) {
            default: {
                result = true;
                break;
            }
            case 1: {
                result = this.checkXMLDeclLatin();
                break;
            }
            case 2: {
                result = this.checkXMLDeclUCS(true, 2, true);
                break;
            }
            case 3: {
                result = this.checkXMLDeclUCS(true, 2, false);
                break;
            }
            case 4: {
                result = this.checkXMLDeclUCS(true, 4, true);
                break;
            }
            case 5: {
                result = this.checkXMLDeclUCS(true, 4, false);
                break;
            }
            case 6: {
                result = this.checkXMLDeclLatin();
                break;
            }
            case 7: {
                result = false;
                break;
            }
            case 8: {
                result = this.checkXMLDeclUCS(false, 2, true);
                break;
            }
            case 9: {
                result = this.checkXMLDeclUCS(false, 2, false);
                break;
            }
            case 10: {
                result = this.checkXMLDeclUCS(false, 4, true);
                break;
            }
            case 11: {
                result = this.checkXMLDeclUCS(false, 4, false);
            }
        }
        this.fStream.rewind();
        return result;
    }

    private static final int autoDetectEncoding(RewindableInputStream stream) {
        try {
            int b0 = stream.read();
            switch (b0) {
                case 239: {
                    int b222;
                    int b1 = stream.read();
                    if (b1 != 187 || (b222 = stream.read()) != 191) break;
                    return 1;
                }
                case 60: {
                    int b32222;
                    int b222;
                    int b1 = stream.read();
                    if (b1 == 0) {
                        int b32222;
                        int b222 = stream.read();
                        if (b222 == 0) {
                            int b32222 = stream.read();
                            if (b32222 != 0) break;
                            stream.rewind();
                            return 11;
                        }
                        if (b222 != 63 || (b32222 = stream.read()) != 0) break;
                        stream.rewind();
                        return 9;
                    }
                    if (b1 != 63 || (b222 = stream.read()) != 120 || (b32222 = stream.read()) != 109) break;
                    stream.rewind();
                    return 6;
                }
                case 76: {
                    int b32222;
                    int b222;
                    int b1 = stream.read();
                    if (b1 != 111 || (b222 = stream.read()) != 167 || (b32222 = stream.read()) != 148) break;
                    stream.rewind();
                    return 7;
                }
                case 0: {
                    int b32222;
                    int b222;
                    int b1 = stream.read();
                    if (b1 == 0) {
                        int b32222;
                        int b222 = stream.read();
                        if (b222 == 0) {
                            int b32222 = stream.read();
                            if (b32222 != 60) break;
                            stream.rewind();
                            return 10;
                        }
                        if (b222 != 254 || (b32222 = stream.read()) != 255) break;
                        return 4;
                    }
                    if (b1 != 60 || (b222 = stream.read()) != 0 || (b32222 = stream.read()) != 63) break;
                    stream.rewind();
                    return 8;
                }
                case 254: {
                    int b1 = stream.read();
                    if (b1 != 255) break;
                    return 2;
                }
                case 255: {
                    int b32222;
                    int b1 = stream.read();
                    if (b1 != 254) break;
                    stream.mark(2);
                    int b222 = stream.read();
                    if (b222 == 0 && (b32222 = stream.read()) == 0) {
                        return 5;
                    }
                    stream.reset();
                    return 3;
                }
            }
        }
        catch (IOException ex) {
            throw new IOExceptionWrapper(ex);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkXMLDeclLatin() throws IOException {
        int state = 0;
        int b = this.readByte();
        if (!this.skipLatinLiteral(b, 0)) {
            return true;
        }
        b = this.skipLatinSpaces();
        do {
            boolean dquote;
            if (state == 0) {
                if (!this.skipLatinLiteral(b, 1)) return false;
                state = 1;
            } else if (state == 1 && b == 101) {
                if (!this.skipLatinLiteral(b, 3)) return false;
                state = 2;
            } else {
                if (b != 115) return b == 63 && this.readByte() == 62;
                if (!this.skipLatinLiteral(b, 4)) return false;
                state = 3;
            }
            b = this.skipLatinSpaces();
            if (b != 61) {
                return false;
            }
            b = this.skipLatinSpaces();
            boolean bl = dquote = b == 34;
            if (!dquote && b != 39) {
                return false;
            }
            int qchar = b;
            b = this.readByte();
            switch (state) {
                case 1: {
                    if (!this.skipLatinLiteral(b, 2) || this.readByte() != qchar) {
                        return false;
                    }
                    b = this.readByte();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipLatinSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanLatinEncodingName(b, qchar)) {
                        return false;
                    }
                    b = this.readByte();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipLatinSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    if (b == 121 ? !this.skipLatinLiteral(b, 5) || this.readByte() != qchar : !this.skipLatinLiteral(b, 6) || this.readByte() != qchar) {
                        return false;
                    }
                    b = this.skipLatinSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        return b == 63 && this.readByte() == 62;
    }

    private int readByte() throws IOException {
        return this.fStream.read();
    }

    private boolean skipLatinLiteral(int firstByte, int literal) throws IOException {
        int b;
        int litLength;
        int[] litData;
        switch (literal) {
            case 0: {
                litData = STARTPIXML_Latin;
                litLength = 5;
                break;
            }
            case 1: {
                litData = VERSION_Latin;
                litLength = 7;
                break;
            }
            case 2: {
                litData = VERSION10_Latin;
                litLength = 3;
                break;
            }
            case 3: {
                litData = ENCODING_Latin;
                litLength = 8;
                break;
            }
            case 4: {
                litData = STANDALONE_Latin;
                litLength = 10;
                break;
            }
            case 5: {
                litData = YES_Latin;
                litLength = 3;
                break;
            }
            case 6: {
                litData = NO_Latin;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (firstByte != litData[0]) {
            return false;
        }
        int i = 1;
        while (i < litLength) {
            b = this.readByte();
            if (b != litData[i]) {
                return false;
            }
            ++i;
        }
        return literal != 0 || (b = this.readByte()) == 32 || b == 10 || b == 9 || b == 13;
    }

    private int skipLatinSpaces() throws IOException {
        int b;
        while ((b = this.readByte()) == 32 || b == 10 || b == 9 || b == 13) {
        }
        return b;
    }

    private boolean scanLatinEncodingName(int firstByte, int qchar) throws IOException {
        int b = firstByte;
        if (b == -1) {
            return false;
        }
        if (b >= 128 || encNameCharMapLatin[b] != 1) {
            return false;
        }
        while ((b = this.readByte()) != qchar) {
            if (b == -1) {
                return false;
            }
            if (b < 128 && encNameCharMapLatin[b] != 0) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkXMLDeclUCS(boolean withBOM, int bytesPerChar, boolean isBigEndian) throws IOException {
        int state = 0;
        this.fBytesPerChar = bytesPerChar;
        this.fIsBigEndian = isBigEndian;
        int b = this.readUCSChar();
        if (!this.skipUCSLiteral(b, 0)) {
            return true;
        }
        b = this.skipUCSSpaces();
        do {
            boolean dquote;
            if (state == 0) {
                if (!this.skipUCSLiteral(b, 1)) return false;
                state = 1;
            } else if (state == 1 && b == 101) {
                if (!this.skipUCSLiteral(b, 3)) return false;
                state = 2;
            } else {
                if (b != 115) return b == 63 && this.readUCSChar() == 62;
                if (!this.skipUCSLiteral(b, 4)) return false;
                state = 3;
            }
            b = this.skipUCSSpaces();
            if (b != 61) {
                return false;
            }
            b = this.skipUCSSpaces();
            boolean bl = dquote = b == 34;
            if (!dquote && b != 39) {
                return false;
            }
            int qchar = b;
            b = this.readUCSChar();
            switch (state) {
                case 1: {
                    if (!this.skipUCSLiteral(b, 2) || this.readUCSChar() != qchar) {
                        return false;
                    }
                    b = this.readUCSChar();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipUCSSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanUCSEncodingName(b, qchar)) {
                        return false;
                    }
                    b = this.readUCSChar();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipUCSSpaces();
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    if (b == 121 ? !this.skipUCSLiteral(b, 5) || this.readUCSChar() != qchar : !this.skipUCSLiteral(b, 6) || this.readUCSChar() != qchar) {
                        return false;
                    }
                    b = this.skipUCSSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        return b == 63 && this.readUCSChar() == 62;
    }

    private int readUCSChar() throws IOException {
        int b0 = this.fStream.read();
        if (b0 == -1) {
            return -1;
        }
        int b1 = this.fStream.read();
        if (b1 == -1) {
            return -1;
        }
        if (this.fBytesPerChar == 2) {
            if (this.fIsBigEndian) {
                return (b0 << 8) + b1;
            }
            return (b1 << 8) + b0;
        }
        int b2 = this.fStream.read();
        if (b2 == -1) {
            return -1;
        }
        int b3 = this.fStream.read();
        if (b3 == -1) {
            return -1;
        }
        if (this.fIsBigEndian) {
            return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
        }
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
    }

    private boolean skipUCSLiteral(int firstByte, int literal) throws IOException {
        int b;
        int litLength;
        int[] litData;
        switch (literal) {
            case 0: {
                litData = STARTPIXML_Latin;
                litLength = 5;
                break;
            }
            case 1: {
                litData = VERSION_Latin;
                litLength = 7;
                break;
            }
            case 2: {
                litData = VERSION10_Latin;
                litLength = 3;
                break;
            }
            case 3: {
                litData = ENCODING_Latin;
                litLength = 8;
                break;
            }
            case 4: {
                litData = STANDALONE_Latin;
                litLength = 10;
                break;
            }
            case 5: {
                litData = YES_Latin;
                litLength = 3;
                break;
            }
            case 6: {
                litData = NO_Latin;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (firstByte != litData[0]) {
            return false;
        }
        int i = 1;
        while (i < litLength) {
            b = this.readUCSChar();
            if (b != litData[i]) {
                return false;
            }
            ++i;
        }
        return literal != 0 || (b = this.readUCSChar()) == 32 || b == 10 || b == 9 || b == 13;
    }

    private int skipUCSSpaces() throws IOException {
        int b;
        while ((b = this.readUCSChar()) == 32 || b == 10 || b == 9 || b == 13) {
        }
        return b;
    }

    private boolean scanUCSEncodingName(int firstChar, int qchar) throws IOException {
        int b = firstChar;
        if (b == -1) {
            return false;
        }
        if (b >= 128 || encNameCharMapLatin[b] != 1) {
            return false;
        }
        while ((b = this.readUCSChar()) != qchar) {
            if (b == -1) {
                return false;
            }
            if (b < 128 && encNameCharMapLatin[b] != 0) continue;
            return false;
        }
        return true;
    }

    final class RewindableReader
    extends Reader {
        private Reader fReader;
        private char[] fData = new char[4096];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public void setReader(Reader rdr) {
            this.fReader = rdr;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int offset) {
            this.fStartOffset = offset;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int count;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                char[] newData = new char[this.fOffset << 1];
                System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
                this.fData = newData;
            }
            if ((count = this.fReader.read(this.fData, this.fOffset, this.fData.length - this.fOffset)) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fLength += count;
            return this.fData[this.fOffset++] & 0xFF;
        }

        public int read(char[] b, int off, int len) throws IOException {
            int count;
            int charsLeft = this.fLength - this.fOffset;
            if (charsLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fReader.read(b, off, len);
            }
            if (len < charsLeft) {
                if (len <= 0) {
                    return 0;
                }
                count = len;
            } else {
                count = charsLeft;
            }
            if (b != null) {
                System.arraycopy(this.fData, this.fOffset, b, off, count);
            }
            this.fOffset += count;
            if (count == len || this.fOffset == this.fEndOffset) {
                return count;
            }
            int result = this.fReader.read(b, off += count, len -= count);
            if (result == -1) {
                this.fEndOffset = this.fOffset;
                return count;
            }
            return count + result;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int charsLeft = this.fLength - this.fOffset;
            if (charsLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fReader.skip(n);
            }
            if (n <= (long)charsLeft) {
                this.fOffset = (int)((long)this.fOffset + n);
                return n;
            }
            this.fOffset += charsLeft;
            if (this.fOffset == this.fEndOffset) {
                return charsLeft;
            }
            return this.fReader.skip(n -= (long)charsLeft) + (long)charsLeft;
        }

        public void mark(int howmuch) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fReader != null) {
                this.fReader.close();
                this.fReader = null;
            }
        }
    }
}

