/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DumpFileProtocolListener
implements DumpFile {
    private final PrintWriter _log;
    private final DumpFile _delegate;

    public DumpFileProtocolListener(DumpFile dumpFile) throws IOException {
        this._log = new PrintWriter(new FileWriter(dumpFile.getDumpName() + ".transcript." + System.currentTimeMillis()));
        this._delegate = dumpFile;
    }

    public void close() throws IOException {
        this._delegate.close();
        this._log.close();
    }

    public String getDumpName() {
        return this._delegate.getDumpName();
    }

    public long getFilePointer() throws IOException {
        this._log.print("getFilePointer()");
        try {
            long l = this._delegate.getFilePointer();
            this._log.print(Long.toHexString(l));
            long l2 = l;
            return l2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public long length() throws IOException {
        this._log.print("length()");
        try {
            long l = this._delegate.length();
            this._log.print(l);
            long l2 = l;
            return l2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public int read() throws IOException {
        this._log.print("read()");
        try {
            int n = this._delegate.read();
            this._log.print(Integer.toHexString(n));
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public int read(byte[] byArray) throws IOException {
        this._log.print("read(buf)");
        try {
            int n = this._delegate.read(byArray);
            this._log.print(" read=" + n + ", buf =");
            this.printBuf(byArray, 0, n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    private void printBuf(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            this._log.print(" " + Integer.toHexString(byArray[i]));
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this._log.print("read(buf,offset,length)");
        try {
            int n3 = this._delegate.read(byArray, n, n2);
            this._log.print("read(buf,offset,length) - read=" + n3 + ", buf =");
            this.printBuf(byArray, n, n3);
            int n4 = n3;
            return n4;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public byte readByte() throws IOException {
        this._log.print("readByte()");
        try {
            byte by = this._delegate.readByte();
            this._log.print("readByte() - " + Integer.toHexString(by));
            byte by2 = by;
            return by2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this._log.print("readFully(b,off,len) ");
        try {
            this._delegate.readFully(byArray, n, n2);
            this._log.print("buf =");
            this.printBuf(byArray, 0, n2);
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this._log.print("readFully(b) ");
        try {
            this._delegate.readFully(byArray);
            this._log.print("buf =");
            this.printBuf(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public int readInt() throws IOException {
        this._log.print("readInt() ");
        try {
            int n = this._delegate.readInt();
            this._log.print(n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public long readLong() throws IOException {
        this._log.print("readLong() ");
        try {
            long l = this._delegate.readLong();
            this._log.print(l);
            long l2 = l;
            return l2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public short readShort() throws IOException {
        this._log.print("readShort() ");
        try {
            short s = this._delegate.readShort();
            this._log.print(s);
            short s2 = s;
            return s2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public int readUnsignedByte() throws IOException {
        this._log.print("readUnsignedByte() ");
        try {
            int n = this._delegate.readUnsignedByte();
            this._log.print(Integer.toHexString(n));
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }

    public void seek(long l) throws IOException {
        try {
            this._log.print("seek " + l);
            this._delegate.seek(l);
        }
        catch (IOException iOException) {
            this._log.print("x");
            throw iOException;
        }
        finally {
            this._log.println();
        }
    }
}

