/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpStats;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;

public class HeapDumpNetCommand
extends HeapDumpAbstractCommand {
    public static final String PORT_PROPERTY = "HD_PORT";
    public static final String HOST_PROPERTY = "HD_HOST";
    public static final int DEFAULT_PORT = 21179;
    public static final String DEFAULT_HOST = "localhost";
    private static final String DESC = "Writes a portable heapdump file to a host/port";
    public static final String NOUN = "N";

    public HeapDumpNetCommand(HeapDumpBaseCmds heapDumpBaseCmds, Observable observable) {
        super(NOUN, heapDumpBaseCmds, observable, DESC);
        HeapDumpConsole.setProperty(PORT_PROPERTY, "21179");
        HeapDumpConsole.setProperty(HOST_PROPERTY, DEFAULT_HOST);
    }

    public boolean checkUserInput(CommandDetails commandDetails) {
        return commandDetails.getNoun().equals(NOUN);
    }

    public String getHost() {
        return HeapDumpConsole.getProperty(HOST_PROPERTY);
    }

    public int getPort() {
        int n = 0;
        try {
            n = Integer.parseInt(HeapDumpConsole.getProperty(PORT_PROPERTY));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Network port is not set correctly");
        }
        return n;
    }

    public String action(CommandDetails commandDetails, Observable observable) {
        HeapDumpStats heapDumpStats;
        observable.notifyObservers("Now dumping heapdump to host:" + this.getHost() + " port:" + this.getPort());
        observable.notifyObservers("\n");
        try {
            if (HeapDumpUtil.isPortableDump()) {
                observable.notifyObservers("Writing HeapDump in Portable Format");
                heapDumpStats = HeapDumpUtil.doPortableHeapDump(this.getNetworkOutputStream(this.getHost(), this.getPort()));
            } else {
                observable.notifyObservers("Writing HeapDump in Classic Format");
                heapDumpStats = HeapDumpUtil.doClassicHeapDump(this.getNetworkPrintWriter(this.getHost(), this.getPort()));
            }
        }
        catch (Exception exception) {
            observable.notifyObservers("Error writing heap dump: ");
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            observable.notifyObservers(stringWriter.toString());
            return "Heapdump failed";
        }
        if (heapDumpStats.errorsOccurred()) {
            return "Number of Object processed = " + heapDumpStats.getNumberOfObjects() + ", Number of Errors: " + heapDumpStats.getNumberOfErrors() + "\n Heapdump Complete with Errors";
        }
        return "Number of Object processed = " + heapDumpStats.getNumberOfObjects() + "\n Heapdump Successful";
    }

    private OutputStream getNetworkOutputStream(String string, int n) throws IOException {
        return new Socket(string, n).getOutputStream();
    }

    private PrintWriter getNetworkPrintWriter(String string, int n) throws IOException {
        OutputStream outputStream = this.getNetworkOutputStream(string, n);
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("// FORMAT=.txt.gz");
        printWriter.flush();
        PrintWriter printWriter2 = new PrintWriter(new BufferedOutputStream(new GZIPOutputStream(outputStream)));
        return printWriter2;
    }
}

