/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpStats;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;

public class HeapDumpFileCommand
extends HeapDumpAbstractCommand {
    public static final String FILE_PROPERTY = "HEAPDUMPFILE";
    public static final String GZIP_EXTENSION = ".gz";
    public static final String NOUN = "F";
    private static final String DESC = "Writes a portable heapdump file to disk";

    public HeapDumpFileCommand(HeapDumpBaseCmds heapDumpBaseCmds, Observable observable) {
        super(NOUN, heapDumpBaseCmds, observable, DESC);
    }

    public boolean checkUserInput(CommandDetails commandDetails) {
        return commandDetails.getNoun().equals(NOUN);
    }

    public String action(CommandDetails commandDetails, Observable observable) {
        String string = HeapDumpConsole.getProperty(FILE_PROPERTY);
        if (string == null || string.equals("")) {
            string = HeapDumpUtil.getDefaultFileName();
        }
        File file = new File(string);
        observable.notifyObservers("Now dumping heapdump file " + file.getAbsolutePath());
        observable.notifyObservers("\n");
        HeapDumpStats heapDumpStats = null;
        try {
            OutputStream outputStream = new FileOutputStream(string);
            if (string.endsWith(GZIP_EXTENSION)) {
                observable.notifyObservers("Writing Compressed Heapdump\n");
                outputStream = new GZIPOutputStream(outputStream);
            }
            if (HeapDumpUtil.isPortableDump()) {
                observable.notifyObservers("Writing Heapdump in Portable Format");
                heapDumpStats = HeapDumpUtil.doPortableHeapDump(outputStream);
            } else {
                observable.notifyObservers("Writing Heapdump in Classic Format");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                heapDumpStats = HeapDumpUtil.doClassicHeapDump(outputStreamWriter);
            }
            if (heapDumpStats.errorsOccurred()) {
                observable.notifyObservers("Heapdump complete with errors, number of objects processed = " + heapDumpStats.getNumberOfObjects() + ", number of errors: " + heapDumpStats.getNumberOfErrors());
            } else {
                observable.notifyObservers("Heapdump complete, number of objects processed = " + heapDumpStats.getNumberOfObjects());
            }
        }
        catch (Exception exception) {
            observable.notifyObservers("Error writing Heapdump: ");
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            observable.notifyObservers(stringWriter.toString());
            return "Heapdump failed";
        }
        if (heapDumpStats != null) {
            if (heapDumpStats.errorsOccurred()) {
                return "Heapdump complete with errors";
            }
            return "Heapdump successful";
        }
        return "Heapdump failed";
    }
}

