/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.ibm.misc.BASE64Encoder;
import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Timestamp;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.security.tools.SignatureFile;
import sun.security.tools.TimestampedSigner;
import sun.security.util.ManifestDigester;
import sun.security.util.Password;
import sun.security.util.SignatureFileVerifier;

public class JarSigner {
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.JarSignerResources");
    private static final Collator collator = Collator.getInstance();
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final Class[] PARAM_STRING;
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final long SIX_MONTHS = 15552000000L;
    static final String VERSION = "1.0";
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store = null;
    IdentityScope scope;
    String keystore;
    boolean nullStream = false;
    boolean token = false;
    String jarfile;
    String alias;
    char[] storepass;
    boolean protectedPath;
    String storetype;
    String providerName;
    Vector providers = null;
    HashMap providerArgs = new HashMap();
    char[] keypass;
    String sigfile;
    String signedjar;
    String tsaUrl;
    String tsaAlias;
    boolean verify = false;
    boolean verbose = false;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private byte[] buffer = new byte[8192];
    private ContentSigner signingMechanism = null;
    private String altSignerClass = null;
    private String altSignerClasspath = null;
    private ZipFile zipFile = null;
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean notYetValidCert = false;
    private static MessageFormat validityTimeForm;
    private static MessageFormat notYetTimeForm;
    private static MessageFormat expiredTimeForm;
    private static MessageFormat expiringTimeForm;
    private static MessageFormat signTimeForm;
    Hashtable storeHash = new Hashtable();

    public static void main(String[] stringArray) throws Exception {
        JarSigner jarSigner = new JarSigner();
        jarSigner.run(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] stringArray) {
        block18: {
            try {
                this.parseArgs(stringArray);
                if (this.providers != null) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Enumeration enumeration = this.providers.elements();
                    while (enumeration.hasMoreElements()) {
                        Object object;
                        Object obj;
                        String string = (String)enumeration.nextElement();
                        Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                        String string2 = (String)this.providerArgs.get(string);
                        if (string2 == null) {
                            obj = clazz.newInstance();
                        } else {
                            object = clazz.getConstructor(PARAM_STRING);
                            obj = ((Constructor)object).newInstance(string2);
                        }
                        if (!(obj instanceof Provider)) {
                            object = new MessageFormat(rb.getString("provName not a provider"));
                            Object[] objectArray = new Object[]{string};
                            throw new Exception(((Format)object).format(objectArray));
                        }
                        Security.addProvider((Provider)obj);
                    }
                }
                this.hasExpiredCert = false;
                this.hasExpiringCert = false;
                this.notYetValidCert = false;
                if (this.verify) {
                    block17: {
                        try {
                            this.loadKeyStore(this.keystore, false);
                            this.scope = IdentityScope.getSystemScope();
                        }
                        catch (Exception exception) {
                            if (this.keystore == null && this.storepass == null) break block17;
                            System.out.println(rb.getString("jarsigner error: ") + exception.getMessage());
                            System.exit(1);
                        }
                    }
                    this.verifyJar(this.jarfile);
                    break block18;
                }
                this.loadKeyStore(this.keystore, true);
                this.getAliasInfo(this.alias);
                if (this.altSignerClass != null) {
                    this.signingMechanism = this.loadSigningMechanism(this.altSignerClass, this.altSignerClasspath);
                }
                this.signJar(this.jarfile, this.alias, stringArray);
            }
            catch (Exception exception) {
                System.out.println(rb.getString("jarsigner error: ") + exception);
                if (this.debug) {
                    exception.printStackTrace();
                }
                System.exit(1);
            }
            finally {
                if (this.keypass != null) {
                    Arrays.fill(this.keypass, ' ');
                    this.keypass = null;
                }
                if (this.storepass != null) {
                    Arrays.fill(this.storepass, ' ');
                    this.storepass = null;
                }
            }
        }
    }

    void parseArgs(String[] stringArray) {
        int n = 0;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string = stringArray[n];
            if (collator.compare(string, "-keystore") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.keystore = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-storepass") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.storepass = stringArray[n].toCharArray();
                continue;
            }
            if (collator.compare(string, "-storetype") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.storetype = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-providerName") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.providerName = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-provider") == 0 || collator.compare(string, "-providerClass") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(stringArray[n]);
                if (stringArray.length <= n + 1 || collator.compare(string = stringArray[n + 1], "-providerArg") != 0) continue;
                if (stringArray.length == n + 2) {
                    this.usage();
                }
                this.providerArgs.put(stringArray[n], stringArray[n + 2]);
                n += 2;
                continue;
            }
            if (collator.compare(string, "-protected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(string, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(string, "-keypass") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.keypass = stringArray[n].toCharArray();
                continue;
            }
            if (collator.compare(string, "-sigfile") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.sigfile = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-signedjar") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.signedjar = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-tsa") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.tsaUrl = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-tsacert") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.tsaAlias = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-altsigner") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.altSignerClass = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-altsignerpath") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.altSignerClasspath = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-sectionsonly") == 0) {
                this.signManifest = false;
                continue;
            }
            if (collator.compare(string, "-internalsf") == 0) {
                this.externalSF = false;
                continue;
            }
            if (collator.compare(string, "-verify") == 0) {
                this.verify = true;
                continue;
            }
            if (collator.compare(string, "-verbose") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(string, "-certs") == 0) {
                this.showcerts = true;
                continue;
            }
            if (collator.compare(string, "-h") == 0 || collator.compare(string, "-help") == 0) {
                this.usage();
                continue;
            }
            System.err.println(rb.getString("Illegal option: ") + string);
            this.usage();
        }
        if (n == stringArray.length) {
            this.usage();
        }
        this.jarfile = stringArray[n++];
        if (!this.verify) {
            if (n == stringArray.length) {
                this.usage();
            }
            this.alias = stringArray[n++];
        }
        if (NONE.equals(this.keystore)) {
            this.nullStream = true;
        }
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        if (P11KEYSTORE.equalsIgnoreCase(this.storetype)) {
            this.token = true;
        }
        if (this.token && !this.nullStream) {
            System.err.println(rb.getString("-keystore must be NONE if -storetype is PKCS11"));
            System.err.println();
            this.usage();
        }
        if (this.token && this.keypass != null) {
            System.err.println(rb.getString("-keypass can not be specified if -storetype is PKCS11"));
            System.err.println();
            this.usage();
        }
        if (this.protectedPath && (this.storepass != null || this.keypass != null)) {
            System.err.println(rb.getString("If -protected is specified, then -storepass and -keypass must not be specified"));
            System.err.println();
            this.usage();
        }
    }

    void usage() {
        System.out.println(rb.getString("Usage: jarsigner [options] jar-file alias"));
        System.out.println(rb.getString("       jarsigner -verify [options] jar-file"));
        System.out.println();
        System.out.println(rb.getString("[-keystore <url>]           keystore location"));
        System.out.println();
        System.out.println(rb.getString("[-storepass <password>]     password for keystore integrity"));
        System.out.println();
        System.out.println(rb.getString("[-storetype <type>]         keystore type"));
        System.out.println();
        System.out.println(rb.getString("[-keypass <password>]       password for private key (if different)"));
        System.out.println();
        System.out.println(rb.getString("[-sigfile <file>]           name of .SF/.DSA file"));
        System.out.println();
        System.out.println(rb.getString("[-signedjar <file>]         name of signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("[-verify]                   verify a signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("[-verbose]                  verbose output when signing/verifying"));
        System.out.println();
        System.out.println(rb.getString("[-certs]                    display certificates when verbose and verifying"));
        System.out.println();
        System.out.println(rb.getString("[-tsa <url>]                location of the Timestamping Authority"));
        System.out.println();
        System.out.println(rb.getString("[-tsacert <alias>]          public key certificate for Timestamping Authority"));
        System.out.println();
        System.out.println(rb.getString("[-altsigner <class>]        class name of an alternative signing mechanism"));
        System.out.println();
        System.out.println(rb.getString("[-altsignerpath <pathlist>] location of an alternative signing mechanism"));
        System.out.println();
        System.out.println(rb.getString("[-internalsf]               include the .SF file inside the signature block"));
        System.out.println();
        System.out.println(rb.getString("[-sectionsonly]             don't compute hash of entire manifest"));
        System.out.println();
        System.out.println(rb.getString("[-protected]                keystore has protected authentication path"));
        System.out.println();
        System.out.println(rb.getString("[-providerName <name>]      provider name"));
        System.out.println();
        System.out.println(rb.getString("[-providerClass <class>     name of cryptographic service provider's"));
        System.out.println(rb.getString("  [-providerArg <arg>]] ... master class file and constructor argument"));
        System.out.println();
        System.exit(1);
    }

    void verifyJar(String string) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            Cloneable cloneable;
            JarFile jarFile = new JarFile(string, true);
            Vector<Cloneable> vector = new Vector<Cloneable>();
            byte[] byArray = new byte[8192];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                cloneable = enumeration.nextElement();
                vector.addElement(cloneable);
                object = jarFile.getInputStream((ZipEntry)cloneable);
                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                }
                ((InputStream)object).close();
            }
            cloneable = jarFile.getManifest();
            jarFile.close();
            if (cloneable != null) {
                if (this.verbose) {
                    System.out.println();
                }
                object = vector.elements();
                long l = System.currentTimeMillis();
                while (object.hasMoreElements()) {
                    int n;
                    JarEntry jarEntry = (JarEntry)object.nextElement();
                    String string2 = jarEntry.getName();
                    CodeSigner[] codeSignerArray = jarEntry.getCodeSigners();
                    boolean bl3 = codeSignerArray != null;
                    bl |= bl3;
                    bl2 |= !jarEntry.isDirectory() && !bl3 && !this.signatureRelated(string2);
                    if (this.verbose) {
                        n = this.inKeyStore(codeSignerArray);
                        boolean bl4 = (n & 1) != 0;
                        boolean bl5 = (n & 2) != 0;
                        boolean bl6 = ((Manifest)cloneable).getAttributes(string2) != null || ((Manifest)cloneable).getAttributes("./" + string2) != null || ((Manifest)cloneable).getAttributes("/" + string2) != null;
                        System.out.print((bl3 ? rb.getString("s") : rb.getString(" ")) + (bl6 ? rb.getString("m") : rb.getString(" ")) + (bl4 ? rb.getString("k") : rb.getString(" ")) + (bl5 ? rb.getString("i") : rb.getString(" ")) + rb.getString("  "));
                        StringBuffer stringBuffer = new StringBuffer();
                        String string3 = Long.toString(jarEntry.getSize());
                        for (int i = 6 - string3.length(); i > 0; --i) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(string3).append(' ').append(DateFormat.getDateTimeInstance().format(new Date(jarEntry.getTime())));
                        stringBuffer.append(' ').append(jarEntry.getName());
                        System.out.println(stringBuffer.toString());
                        if (codeSignerArray != null && this.showcerts) {
                            String string4 = rb.getString("      ");
                            for (int i = 0; i < codeSignerArray.length; ++i) {
                                System.out.println();
                                List<? extends Certificate> list = codeSignerArray[i].getSignerCertPath().getCertificates();
                                Timestamp timestamp = codeSignerArray[i].getTimestamp();
                                if (timestamp != null) {
                                    System.out.println(this.printTimestamp(string4, timestamp));
                                }
                                for (Certificate certificate : list) {
                                    System.out.println(this.printCert(string4, certificate, true, l));
                                }
                            }
                            System.out.println();
                        }
                    }
                    if (!bl3 || this.showcerts) continue;
                    for (n = 0; n < codeSignerArray.length; ++n) {
                        Certificate certificate = codeSignerArray[n].getSignerCertPath().getCertificates().get(0);
                        if (!(certificate instanceof X509Certificate)) continue;
                        long l2 = ((X509Certificate)certificate).getNotAfter().getTime();
                        if (l2 < l) {
                            this.hasExpiredCert = true;
                            continue;
                        }
                        if (l2 >= l + 15552000000L) continue;
                        this.hasExpiringCert = true;
                    }
                }
            }
            if (this.verbose) {
                System.out.println();
                System.out.println(rb.getString("  s = signature was verified "));
                System.out.println(rb.getString("  m = entry is listed in manifest"));
                System.out.println(rb.getString("  k = at least one certificate was found in keystore"));
                System.out.println(rb.getString("  i = at least one certificate was found in identity scope"));
                System.out.println();
            }
            if (cloneable == null) {
                System.out.println(rb.getString("no manifest."));
            }
            if (!bl) {
                System.out.println(rb.getString("jar is unsigned. (signatures missing or not parsable)"));
            } else {
                System.out.println(rb.getString("jar verified."));
                if (bl2 || this.hasExpiredCert || this.hasExpiringCert || this.notYetValidCert) {
                    System.out.println();
                    System.out.print(rb.getString("Warning: "));
                    if (bl2) {
                        System.out.print(rb.getString("This jar contains unsigned entries which have not been integrity-checked. "));
                        if (!this.verbose) {
                            System.out.println(rb.getString("Re-run with the -verbose option for more details."));
                        } else {
                            System.out.println();
                        }
                    }
                    if (this.hasExpiredCert) {
                        System.out.print(rb.getString("This jar contains entries whose signer certificate has expired. "));
                        if (!this.verbose || !this.showcerts) {
                            System.out.println(rb.getString("Re-run with the -verbose and -certs options for more details."));
                        } else {
                            System.out.println();
                        }
                    }
                    if (this.hasExpiringCert) {
                        System.out.print(rb.getString("This jar contains entries whose signer certificate will expire within six months. "));
                        if (!this.verbose || !this.showcerts) {
                            System.out.println(rb.getString("Re-run with the -verbose and -certs options for more details."));
                        } else {
                            System.out.println();
                        }
                    }
                    if (this.notYetValidCert) {
                        System.out.print(rb.getString("This jar contains entries whose signer certificate is not yet valid. "));
                        if (!this.verbose || !this.showcerts) {
                            System.out.println(rb.getString("Re-run with the -verbose and -certs options for more details."));
                        } else {
                            System.out.println();
                        }
                    }
                }
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(rb.getString("jarsigner: ") + exception);
            if (this.debug) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
        System.exit(1);
    }

    String printCert(Certificate certificate) {
        return this.printCert("", certificate, false, 0L);
    }

    String printCert(String string, Certificate certificate, boolean bl, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rb.getString(" ");
        X509Certificate x509Certificate = null;
        if (certificate instanceof X509Certificate) {
            x509Certificate = (X509Certificate)certificate;
            stringBuilder.append(string).append(x509Certificate.getType()).append(rb.getString(", ")).append(x509Certificate.getSubjectDN().getName());
        } else {
            stringBuilder.append(string).append(certificate.getType());
        }
        String string3 = (String)this.storeHash.get(certificate);
        if (string3 != null) {
            stringBuilder.append(string2).append(string3);
        }
        if (bl && x509Certificate != null) {
            stringBuilder.append("\n").append(string).append("[");
            Date date = x509Certificate.getNotAfter();
            try {
                x509Certificate.checkValidity();
                if (l == 0L) {
                    l = System.currentTimeMillis();
                }
                if (date.getTime() < l + 15552000000L) {
                    this.hasExpiringCert = true;
                    if (expiringTimeForm == null) {
                        expiringTimeForm = new MessageFormat(rb.getString("certificate will expire on"));
                    }
                    Object[] objectArray = new Object[]{date};
                    stringBuilder.append(expiringTimeForm.format(objectArray));
                } else {
                    if (validityTimeForm == null) {
                        validityTimeForm = new MessageFormat(rb.getString("certificate is valid from"));
                    }
                    Object[] objectArray = new Object[]{x509Certificate.getNotBefore(), date};
                    stringBuilder.append(validityTimeForm.format(objectArray));
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                this.hasExpiredCert = true;
                if (expiredTimeForm == null) {
                    expiredTimeForm = new MessageFormat(rb.getString("certificate expired on"));
                }
                Object[] objectArray = new Object[]{date};
                stringBuilder.append(expiredTimeForm.format(objectArray));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                this.notYetValidCert = true;
                if (notYetTimeForm == null) {
                    notYetTimeForm = new MessageFormat(rb.getString("certificate is not valid until"));
                }
                Object[] objectArray = new Object[]{x509Certificate.getNotBefore()};
                stringBuilder.append(notYetTimeForm.format(objectArray));
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private String printTimestamp(String string, Timestamp timestamp) {
        if (signTimeForm == null) {
            signTimeForm = new MessageFormat(rb.getString("entry was signed on"));
        }
        Object[] objectArray = new Object[]{timestamp.getTimestamp()};
        return string + "[" + signTimeForm.format(objectArray) + "]";
    }

    int inKeyStore(CodeSigner[] codeSignerArray) {
        int n = 0;
        if (codeSignerArray == null) {
            return 0;
        }
        boolean bl = false;
        for (int i = 0; i < codeSignerArray.length; ++i) {
            bl = false;
            List<? extends Certificate> list = codeSignerArray[i].getSignerCertPath().getCertificates();
            for (Certificate certificate : list) {
                Identity identity;
                String string = (String)this.storeHash.get(certificate);
                if (string != null) {
                    if (string.startsWith("(")) {
                        n |= 1;
                        continue;
                    }
                    if (!string.startsWith("[")) continue;
                    n |= 2;
                    continue;
                }
                if (this.store != null) {
                    try {
                        string = this.store.getCertificateAlias(certificate);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    if (string != null) {
                        this.storeHash.put(certificate, "(" + string + ")");
                        bl = true;
                        n |= 1;
                    }
                }
                if (bl || this.scope == null || (identity = this.scope.getIdentity(certificate.getPublicKey())) == null) continue;
                n |= 2;
                this.storeHash.put(certificate, "[" + identity.getName() + "]");
            }
        }
        return n;
    }

    void signJar(String string, String string2, String[] stringArray) throws Exception {
        boolean bl = false;
        X509Certificate x509Certificate = null;
        if (this.sigfile == null) {
            this.sigfile = string2;
            bl = true;
        }
        this.sigfile = this.sigfile.length() > 8 ? this.sigfile.substring(0, 8).toUpperCase() : this.sigfile.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer(this.sigfile.length());
        for (int i = 0; i < this.sigfile.length(); ++i) {
            int n = this.sigfile.charAt(i);
            if (!(n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95)) {
                if (bl) {
                    n = 95;
                } else {
                    throw new RuntimeException(rb.getString("signature filename must consist of the following characters: A-Z, 0-9, _ or -"));
                }
            }
            stringBuffer.append((char)n);
        }
        this.sigfile = stringBuffer.toString();
        String string3 = this.signedjar == null ? string + ".sig" : this.signedjar;
        File file = new File(string);
        File file2 = new File(string3);
        try {
            this.zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to open jar file: ") + string, iOException);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to create: ") + string3, iOException);
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(printStream);
        String string4 = (META_INF + this.sigfile + ".SF").toUpperCase();
        String string5 = (META_INF + this.sigfile + ".DSA").toUpperCase();
        Manifest manifest = new Manifest();
        Map<String, Attributes> map = manifest.getEntries();
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray = null;
        try {
            Cloneable cloneable;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Attributes attributes;
            MessageDigest[] messageDigestArray = new MessageDigest[]{MessageDigest.getInstance("SHA1")};
            ZipEntry zipEntry = this.getManifestFile(this.zipFile);
            if (zipEntry != null) {
                byArray = this.getBytes(this.zipFile, zipEntry);
                manifest.read(new ByteArrayInputStream(byArray));
            } else {
                attributes = manifest.getMainAttributes();
                attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), VERSION);
                object4 = System.getProperty("java.vendor");
                object3 = System.getProperty("java.version");
                attributes.putValue("Created-By", (String)object3 + " (" + (String)object4 + ")");
                zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
                bl3 = true;
            }
            attributes = new BASE64Encoder();
            object4 = new Vector();
            object3 = this.zipFile.entries();
            while (object3.hasMoreElements()) {
                object2 = (ZipEntry)object3.nextElement();
                if (((ZipEntry)object2).getName().startsWith(META_INF)) {
                    ((Vector)object4).addElement(object2);
                    if (this.signatureRelated(((ZipEntry)object2).getName())) continue;
                }
                if (manifest.getAttributes(((ZipEntry)object2).getName()) != null) {
                    if (!this.updateDigests((ZipEntry)object2, this.zipFile, messageDigestArray, (BASE64Encoder)attributes, manifest)) continue;
                    bl2 = true;
                    continue;
                }
                if (((ZipEntry)object2).isDirectory()) continue;
                object = this.getDigestAttributes((ZipEntry)object2, this.zipFile, messageDigestArray, (BASE64Encoder)attributes);
                map.put(((ZipEntry)object2).getName(), (Attributes)object);
                bl2 = true;
            }
            if (bl2) {
                object3 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object3);
                byArray = ((ByteArrayOutputStream)object3).toByteArray();
            }
            if (bl2) {
                zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            }
            if (this.verbose) {
                if (bl3) {
                    System.out.println(rb.getString("   adding: ") + zipEntry.getName());
                } else if (bl2) {
                    System.out.println(rb.getString(" updating: ") + zipEntry.getName());
                }
            }
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            object3 = new ManifestDigester(byArray);
            object2 = new SignatureFile(messageDigestArray, manifest, (ManifestDigester)object3, this.sigfile, this.signManifest);
            if (this.tsaAlias != null) {
                x509Certificate = this.getTsaCert(this.tsaAlias);
            }
            object = null;
            try {
                object = ((SignatureFile)object2).generateBlock(this.privateKey, this.certChain, this.externalSF, this.tsaUrl, x509Certificate, this.signingMechanism, stringArray, this.zipFile);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.error(rb.getString("unable to sign jar: ") + rb.getString("no response from the Timestamping Authority. ") + rb.getString("When connecting from behind a firewall then an HTTP proxy may need to be specified. ") + rb.getString("Supply the following options to jarsigner: ") + "\n  -J-Dhttp.proxyHost=<hostname> " + "\n  -J-Dhttp.proxyPort=<portnumber> ", socketTimeoutException);
            }
            string4 = ((SignatureFile)object2).getMetaName();
            string5 = ((SignatureFile.Block)object).getMetaName();
            ZipEntry zipEntry2 = new ZipEntry(string4);
            ZipEntry zipEntry3 = new ZipEntry(string5);
            long l = System.currentTimeMillis();
            zipEntry2.setTime(l);
            zipEntry3.setTime(l);
            zipOutputStream.putNextEntry(zipEntry2);
            ((SignatureFile)object2).write(zipOutputStream);
            if (this.verbose) {
                if (this.zipFile.getEntry(string4) != null) {
                    System.out.println(rb.getString(" updating: ") + string4);
                } else {
                    System.out.println(rb.getString("   adding: ") + string4);
                }
            }
            if (this.verbose) {
                if (this.tsaUrl != null || x509Certificate != null) {
                    System.out.println(rb.getString("requesting a signature timestamp"));
                }
                if (this.tsaUrl != null) {
                    System.out.println(rb.getString("TSA location: ") + this.tsaUrl);
                }
                if (x509Certificate != null) {
                    String string6 = TimestampedSigner.getTimestampingUrl(x509Certificate);
                    if (string6 != null) {
                        System.out.println(rb.getString("TSA location: ") + string6);
                    }
                    System.out.println(rb.getString("TSA certificate: ") + this.printCert(x509Certificate));
                }
                if (this.signingMechanism != null) {
                    System.out.println(rb.getString("using an alternative signing mechanism"));
                }
            }
            zipOutputStream.putNextEntry(zipEntry3);
            ((SignatureFile.Block)object).write(zipOutputStream);
            if (this.verbose) {
                if (this.zipFile.getEntry(string5) != null) {
                    System.out.println(rb.getString(" updating: ") + string5);
                } else {
                    System.out.println(rb.getString("   adding: ") + string5);
                }
            }
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                cloneable = (ZipEntry)((Vector)object4).elementAt(i);
                if (((ZipEntry)cloneable).getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || ((ZipEntry)cloneable).getName().equalsIgnoreCase(string4) || ((ZipEntry)cloneable).getName().equalsIgnoreCase(string5)) continue;
                this.writeEntry(this.zipFile, zipOutputStream, (ZipEntry)cloneable);
            }
            Object object5 = this.zipFile.entries();
            while (object5.hasMoreElements()) {
                cloneable = object5.nextElement();
                if (((ZipEntry)cloneable).getName().startsWith(META_INF)) continue;
                if (this.verbose) {
                    if (manifest.getAttributes(((ZipEntry)cloneable).getName()) != null) {
                        System.out.println(rb.getString("  signing: ") + ((ZipEntry)cloneable).getName());
                    } else {
                        System.out.println(rb.getString("   adding: ") + ((ZipEntry)cloneable).getName());
                    }
                }
                this.writeEntry(this.zipFile, zipOutputStream, (ZipEntry)cloneable);
            }
            this.zipFile.close();
            zipOutputStream.close();
            if (this.signedjar == null && !file2.renameTo(file)) {
                object5 = new File(string + ".orig");
                if (file.renameTo((File)object5)) {
                    if (file2.renameTo(file)) {
                        ((File)object5).delete();
                    } else {
                        cloneable = new MessageFormat(rb.getString("attempt to rename signedJarFile to jarFile failed"));
                        Object[] objectArray = new Object[]{file2, file};
                        this.error(((Format)cloneable).format(objectArray));
                    }
                } else {
                    cloneable = new MessageFormat(rb.getString("attempt to rename jarFile to origJar failed"));
                    Object[] objectArray = new Object[]{file, object5};
                    this.error(((Format)cloneable).format(objectArray));
                }
            }
            if (this.hasExpiredCert || this.hasExpiringCert || this.notYetValidCert) {
                System.out.println();
                System.out.print(rb.getString("Warning: "));
                if (this.hasExpiredCert) {
                    System.out.println(rb.getString("The signer certificate has expired."));
                } else if (this.hasExpiringCert) {
                    System.out.println(rb.getString("The signer certificate will expire within six months."));
                } else if (this.notYetValidCert) {
                    System.out.println(rb.getString("The signer certificate is not yet valid."));
                }
            }
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to sign jar: ") + iOException, iOException);
        }
    }

    private boolean signatureRelated(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("META-INF/MANIFEST.MF") || string2.equals(META_INF) || string2.startsWith(SIG_PREFIX) && string2.indexOf("/") == string2.lastIndexOf("/")) {
            return true;
        }
        if (string2.startsWith(META_INF) && SignatureFileVerifier.isBlockOrSF(string2)) {
            return string2.indexOf("/") == string2.lastIndexOf("/");
        }
        return false;
    }

    private void writeEntry(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        byte[] byArray = this.getBytes(zipFile, zipEntry);
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setMethod(zipEntry.getMethod());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setExtra(zipEntry.getExtra());
        if (zipEntry.getMethod() == 0) {
            zipEntry2.setSize(zipEntry.getSize());
            zipEntry2.setCrc(zipEntry.getCrc());
        }
        zipOutputStream.putNextEntry(zipEntry2);
        if (byArray.length > 0) {
            zipOutputStream.write(byArray);
        }
    }

    void loadKeyStore(String string, boolean bl) {
        block13: {
            if (!this.nullStream && string == null) {
                string = System.getProperty("user.home") + File.separator + ".keystore";
            }
            try {
                this.store = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
                if (this.token && this.storepass == null && !this.protectedPath) {
                    this.storepass = this.getPass(rb.getString("Enter Passphrase for keystore: "));
                } else if (!this.token && this.storepass == null && bl) {
                    this.storepass = this.getPass(rb.getString("Enter Passphrase for keystore: "));
                }
                if (this.nullStream) {
                    this.store.load(null, this.storepass);
                    break block13;
                }
                string = string.replace(File.separatorChar, '/');
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    uRL = new URL("file:" + file.getCanonicalPath());
                }
                InputStream inputStream = uRL.openStream();
                this.store.load(inputStream, this.storepass);
                inputStream.close();
            }
            catch (IOException iOException) {
                this.store = null;
                throw new RuntimeException(rb.getString("keystore load: ") + iOException.getMessage());
            }
            catch (CertificateException certificateException) {
                this.store = null;
                throw new RuntimeException(rb.getString("certificate exception: ") + certificateException.getMessage());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                this.store = null;
                throw new RuntimeException(rb.getString("keystore load: ") + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.store = null;
                throw new RuntimeException(rb.getString("keystore load: ") + noSuchAlgorithmException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                this.store = null;
                throw new RuntimeException(rb.getString("unable to instantiate keystore class: ") + keyStoreException.getMessage());
            }
        }
    }

    X509Certificate getTsaCert(String string) {
        Certificate certificate = null;
        try {
            certificate = this.store.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate not found for: alias.  alias must reference a valid KeyStore entry containing an X.509 public key certificate for the Timestamping Authority."));
            Object[] objectArray = new Object[]{string, string};
            this.error(messageFormat.format(objectArray));
        }
        return (X509Certificate)certificate;
    }

    void getAliasInfo(String string) {
        Object object;
        Object object2;
        Key key;
        block23: {
            key = null;
            try {
                Object object3;
                Object[] objectArray;
                object2 = null;
                try {
                    object2 = this.store.getCertificateChain(string);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (object2 == null) {
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate chain not found for: alias.  alias must reference a valid KeyStore key entry containing a private key and corresponding public key certificate chain."));
                    objectArray = new Object[]{string, string};
                    this.error(messageFormat.format(objectArray));
                }
                this.certChain = new X509Certificate[((Certificate[])object2).length];
                for (int i = 0; i < ((Certificate[])object2).length; ++i) {
                    if (!(object2[i] instanceof X509Certificate)) {
                        this.error(rb.getString("found non-X.509 certificate in signer's chain"));
                    }
                    this.certChain[i] = (X509Certificate)object2[i];
                }
                object = (X509Certificate)this.store.getCertificate(string);
                try {
                    ((X509Certificate)object).checkValidity();
                    if (((X509Certificate)object).getNotAfter().getTime() < System.currentTimeMillis() + 15552000000L) {
                        this.hasExpiringCert = true;
                    }
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    this.hasExpiredCert = true;
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    this.notYetValidCert = true;
                }
                if (!((Certificate)object).equals(this.certChain[0])) {
                    objectArray = new X509Certificate[this.certChain.length];
                    objectArray[0] = object;
                    object3 = ((X509Certificate)object).getIssuerDN();
                    for (int i = 1; i < this.certChain.length; ++i) {
                        int n;
                        for (n = 0; n < objectArray.length; ++n) {
                            Principal principal;
                            if (objectArray[n] == null || !object3.equals(principal = ((X509Certificate)objectArray[n]).getSubjectDN())) continue;
                            this.certChain[i] = objectArray[n];
                            object3 = ((X509Certificate)objectArray[n]).getIssuerDN();
                            objectArray[n] = null;
                            break;
                        }
                        if (n != objectArray.length) continue;
                        this.error(rb.getString("incomplete certificate chain"));
                    }
                    this.certChain = objectArray;
                }
                try {
                    if (!this.token && this.keypass == null) {
                        key = this.store.getKey(string, this.storepass);
                        break block23;
                    }
                    key = this.store.getKey(string, this.keypass);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    if (this.token) {
                        throw unrecoverableKeyException;
                    }
                    if (this.keypass == null) {
                        object3 = new MessageFormat(rb.getString("Enter key password for alias: "));
                        Object[] objectArray2 = new Object[]{string};
                        this.keypass = this.getPass(((Format)object3).format(objectArray2));
                        key = this.store.getKey(string, this.keypass);
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.error(noSuchAlgorithmException.getMessage());
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.error(rb.getString("unable to recover key from keystore"));
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        if (!(key instanceof PrivateKey)) {
            object2 = new MessageFormat(rb.getString("key associated with alias not a private key"));
            object = new Object[]{string};
            this.error(((Format)object2).format(object));
        } else {
            this.privateKey = (PrivateKey)key;
        }
    }

    void error(String string) {
        System.out.println(rb.getString("jarsigner: ") + string);
        System.exit(1);
    }

    void error(String string, Exception exception) {
        System.out.println(rb.getString("jarsigner: ") + string);
        if (this.debug) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    char[] getPass(String string) {
        System.err.print(string);
        System.err.flush();
        try {
            char[] cArray = Password.readPassword(System.in);
            if (cArray != null) {
                return cArray;
            }
            this.error(rb.getString("you must enter key password"));
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to read password: ") + iOException.getMessage());
        }
        return null;
    }

    private synchronized byte[] getBytes(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        int n;
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        this.baos.reset();
        for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n) {
            this.baos.write(this.buffer, 0, n);
        }
        inputStream.close();
        return this.baos.toByteArray();
    }

    private ZipEntry getManifestFile(ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements() && zipEntry == null) {
                zipEntry = enumeration.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(zipEntry.getName())) continue;
                zipEntry = null;
            }
        }
        return zipEntry;
    }

    private synchronized String[] getDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        int n;
        int n2;
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        for (long i = zipEntry.getSize(); i > 0L && (n2 = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n2) {
            for (n = 0; n < messageDigestArray.length; ++n) {
                messageDigestArray[n].update(this.buffer, 0, n2);
            }
        }
        inputStream.close();
        String[] stringArray = new String[messageDigestArray.length];
        for (n = 0; n < messageDigestArray.length; ++n) {
            stringArray[n] = bASE64Encoder.encode(messageDigestArray[n].digest());
        }
        return stringArray;
    }

    private Attributes getDigestAttributes(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        Attributes attributes = new Attributes();
        for (int i = 0; i < messageDigestArray.length; ++i) {
            attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", stringArray[i]);
        }
        return attributes;
    }

    private boolean updateDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder, Manifest manifest) throws IOException {
        boolean bl = false;
        Attributes attributes = manifest.getAttributes(zipEntry.getName());
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        for (int i = 0; i < messageDigestArray.length; ++i) {
            String string = messageDigestArray[i].getAlgorithm() + "-Digest";
            String string2 = attributes.getValue(string);
            if (string2 == null && messageDigestArray[i].getAlgorithm().equalsIgnoreCase("SHA")) {
                string2 = attributes.getValue("SHA-Digest");
            }
            if (string2 == null) {
                attributes.putValue(string, stringArray[i]);
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase(stringArray[i])) continue;
            attributes.putValue(string, stringArray[i]);
            bl = true;
        }
        return bl;
    }

    private ContentSigner loadSigningMechanism(String string, String string2) throws Exception {
        String string3 = null;
        string3 = JarSigner.appendPath(System.getProperty("env.class.path"), string3);
        string3 = JarSigner.appendPath(System.getProperty("java.class.path"), string3);
        URL[] uRLArray = JarSigner.pathToURLs(string3 = JarSigner.appendPath(string2, string3));
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Class<?> clazz = uRLClassLoader.loadClass(string);
        Object obj = clazz.newInstance();
        if (!(obj instanceof ContentSigner)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("signerClass is not a signing mechanism"));
            Object[] objectArray = new Object[]{clazz.getName()};
            throw new IllegalArgumentException(messageFormat.format(objectArray));
        }
        return (ContentSigner)obj;
    }

    private static String appendPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null ? "." : string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    private static URL[] pathToURLs(String string) {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = JarSigner.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRLArray == null) continue;
            uRLArray2[n++] = uRLArray;
        }
        if (uRLArray2.length != n) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    static {
        collator.setStrength(0);
        PARAM_STRING = new Class[]{String.class};
        validityTimeForm = null;
        notYetTimeForm = null;
        expiredTimeForm = null;
        expiringTimeForm = null;
        signTimeForm = null;
    }
}

