/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import sun.security.jca.ProviderList;

public class Providers {
    private static final ThreadLocal<ProviderList> threadLists = new InheritableThreadLocal<ProviderList>();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static final String[] jarClassNames;
    private static final Object ALL_PROVIDERS_LOADED;

    private Providers() {
    }

    public static Object startJarVerification() {
        ProviderList providerList = Providers.getProviderList();
        ProviderList providerList2 = providerList.getJarList(jarClassNames);
        if (providerList2 == null) {
            return ALL_PROVIDERS_LOADED;
        }
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + providerList2);
        }
        ProviderList providerList3 = Providers.getThreadProviderList();
        ++threadListsUsed;
        Providers.setThreadProviderList(providerList2);
        return providerList3;
    }

    public static void stopJarVerification(Object object) {
        if (object == ALL_PROVIDERS_LOADED) {
            return;
        }
        if (ProviderList.debug != null) {
            ProviderList.debug.println("Disabling ThreadLocal providers");
        }
        ProviderList providerList = (ProviderList)object;
        Providers.setThreadProviderList(providerList);
        --threadListsUsed;
    }

    public static Object startLoadProvider() {
        ProviderList providerList = Providers.getProviderList();
        ProviderList providerList2 = providerList.addBootStrap();
        if (ProviderList.debug != null) {
            ProviderList.debug.println("Added bootstrap to ThreadLocal providers ");
        }
        ProviderList providerList3 = Providers.getThreadProviderList();
        ++threadListsUsed;
        Providers.setThreadProviderList(providerList2);
        return providerList3;
    }

    public static void stopLoadProvider(Object object) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("Disabling ThreadLocal providers which includes bootstrap ");
        }
        ProviderList providerList = (ProviderList)object;
        Providers.setThreadProviderList(providerList);
        --threadListsUsed;
    }

    public static ProviderList getProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList == null) {
            providerList = Providers.getSystemProviderList();
        }
        return providerList;
    }

    public static void setProviderList(ProviderList providerList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(providerList);
        } else {
            Providers.setThreadProviderList(providerList);
        }
    }

    public static synchronized ProviderList getFullProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList != null) {
            ProviderList providerList2 = providerList.removeInvalid();
            if (providerList2 != providerList) {
                Providers.setThreadProviderList(providerList2);
                providerList = providerList2;
            }
            return providerList;
        }
        providerList = Providers.getSystemProviderList();
        ProviderList providerList3 = providerList.removeInvalid();
        if (providerList3 != providerList) {
            Providers.setSystemProviderList(providerList3);
            providerList = providerList3;
        }
        return providerList;
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList providerList) {
        Providers.providerList = providerList;
    }

    private static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return threadLists.get();
    }

    private static void setThreadProviderList(ProviderList providerList) {
        if (providerList == null) {
            threadLists.remove();
        } else {
            threadLists.set(providerList);
        }
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        jarClassNames = new String[]{"com.ibm.security.bootstrap.BootstrapProvider"};
        ALL_PROVIDERS_LOADED = new Object();
    }
}

