/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.BadPaddingException;
import java.math.BigInteger;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.WeakHashMap;

public final class RSACore {
    private static final boolean ENABLE_BLINDING = true;
    private static final int BLINDING_MAX_REUSE = 50;
    private static final Map blindingCache = new WeakHashMap();

    private RSACore() {
    }

    public static int getByteLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n + 7 >> 3;
    }

    public static int getByteLength(RSAKey rSAKey) {
        return RSACore.getByteLength(rSAKey.getModulus());
    }

    public static byte[] convert(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] rsa(byte[] byArray, RSAPublicKey rSAPublicKey) throws BadPaddingException {
        return RSACore.crypt(byArray, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    public static byte[] rsa(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws BadPaddingException {
        throw new BadPaddingException("Bootstrap provider does not support Private Keys.");
    }

    private static byte[] crypt(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) throws BadPaddingException {
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return RSACore.toByteArray(bigInteger4, RSACore.getByteLength(bigInteger));
    }

    private static byte[] crtCrypt(byte[] byArray, RSAPrivateCrtKey rSAPrivateCrtKey) throws BadPaddingException {
        throw new BadPaddingException("Bootstrap provider does not support Private Keys.");
    }

    private static BigInteger parseMsg(byte[] byArray, BigInteger bigInteger) throws BadPaddingException {
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new BadPaddingException("Message is larger than modulus");
        }
        return bigInteger2;
    }

    private static byte[] toByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        if (n2 == n) {
            return byArray;
        }
        if (n2 == n + 1 && byArray[0] == 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            return byArray2;
        }
        assert (n2 < n);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, n - n2, n2);
        return byArray3;
    }

    private static BlindingParameters getBlindingParameters(RSAPrivateCrtKey rSAPrivateCrtKey) {
        return null;
    }

    private static final class BlindingParameters {
        final BigInteger e;
        final BigInteger re;
        final BigInteger rInv;
        private volatile int remainingUses;

        BlindingParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.e = bigInteger;
            this.re = bigInteger2;
            this.rInv = bigInteger3;
            this.remainingUses = 49;
        }

        boolean valid(BigInteger bigInteger) {
            int n;
            return (n = this.remainingUses--) > 0 && this.e.equals(bigInteger);
        }
    }
}

