/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.nc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 192;
    SecureRandom b = null;
    ECParameterSpec c;
    private static String[] z;

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[1]);
        }
        this.a = n2;
        this.b = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ECNamedCurve eCNamedCurve = new ECNamedCurve(((ECGenParameterSpec)algorithmParameterSpec).getName());
                this.c = eCNamedCurve.getECParameterSpec();
                this.b = secureRandom;
                this.a = this.c.getCurve().getField().getFieldSize();
                return;
            }
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.c = (ECParameterSpec)algorithmParameterSpec;
        this.initialize(this.c.getCurve().getField().getFieldSize(), secureRandom);
    }

    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            System.err.println(bigInteger);
            System.err.println(this.c.getOrder());
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c);
            ECPublicKey eCPublicKey = new ECPublicKey(ECUtils.b(bigInteger, this.c.getGenerator(), this.c.getCurve()), this.c);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                ECFieldFp eCFieldFp = new ECFieldFp(nc.a);
                byte[] byArray = new byte[24];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, nc.E.mod(nc.a), nc.c, byArray);
                this.c = new ECParameterSpec(ellipticCurve, nc.f, nc.b, 1);
                break;
            }
            case 224: {
                ECFieldFp eCFieldFp = new ECFieldFp(nc.g);
                byte[] byArray = new byte[28];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, nc.E.mod(nc.g), nc.i, byArray);
                this.c = new ECParameterSpec(ellipticCurve, nc.l, nc.h, 1);
                break;
            }
            case 256: {
                ECFieldFp eCFieldFp = new ECFieldFp(nc.m);
                byte[] byArray = new byte[32];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, nc.E.mod(nc.m), nc.o, byArray);
                this.c = new ECParameterSpec(ellipticCurve, nc.r, nc.n, 1);
                break;
            }
            case 384: {
                ECFieldFp eCFieldFp = new ECFieldFp(nc.s);
                byte[] byArray = new byte[48];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, nc.E.mod(nc.s), nc.u, byArray);
                this.c = new ECParameterSpec(ellipticCurve, nc.x, nc.t, 1);
                break;
            }
            case 521: {
                ECFieldFp eCFieldFp = new ECFieldFp(nc.y);
                byte[] byArray = new byte[65];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, nc.E.mod(nc.y), nc.A, byArray);
                this.c = new ECParameterSpec(ellipticCurve, nc.D, nc.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n2;
            int n3;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n4;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n5;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "R\u0000uHWx7J~`z,\\t_".toCharArray();
                                cArray3 = cArray4;
                                n5 = cArray4.length;
                                n3 = 0;
                                if (!true) break block24;
                                n5 = n5;
                                if (n5 <= n3) break block25;
                            }
                            do {
                                int n6;
                                cArray3 = cArray3;
                                int n7 = n3;
                                char c2 = cArray3[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n6 = 27;
                                        break;
                                    }
                                    case 1: {
                                        n6 = 66;
                                        break;
                                    }
                                    case 2: {
                                        n6 = 56;
                                        break;
                                    }
                                    case 3: {
                                        n6 = 27;
                                        break;
                                    }
                                    default: {
                                        n6 = 50;
                                    }
                                }
                                cArray3[n7] = (char)(c2 ^ n6);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "K0QvW;1QaW;/MhF; ];]u'\u0018tT!b\t\"\u00007b\n)\u00067b\n.\u00047b\u000b#\u00067b\r)\u0003".toCharArray();
                        cArray2 = cArray5;
                        n4 = cArray5.length;
                        n3 = 0;
                        if (!true) break block26;
                        n4 = n4;
                        if (n4 <= n3) break block27;
                    }
                    do {
                        int n8;
                        cArray2 = cArray2;
                        int n9 = n3;
                        char c3 = cArray2[n9];
                        switch (n3 % 5) {
                            case 0: {
                                n8 = 27;
                                break;
                            }
                            case 1: {
                                n8 = 66;
                                break;
                            }
                            case 2: {
                                n8 = 56;
                                break;
                            }
                            case 3: {
                                n8 = 27;
                                break;
                            }
                            default: {
                                n8 = 50;
                            }
                        }
                        cArray2[n9] = (char)(c3 ^ n8);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "K#Jz_hbUnAobZ~\u0012r,KoSu!];]}b}Xbz0YvWo'JHB~!\u0018t@;\u0007{\\Wu\u0012YiSv'L~@H2]x".toCharArray();
                cArray = cArray6;
                n2 = cArray6.length;
                n3 = 0;
                if (!true) break block28;
                n2 = n2;
                if (n2 <= n3) break block29;
            }
            do {
                int n10;
                cArray = cArray;
                int n11 = n3;
                char c4 = cArray[n11];
                switch (n3 % 5) {
                    case 0: {
                        n10 = 27;
                        break;
                    }
                    case 1: {
                        n10 = 66;
                        break;
                    }
                    case 2: {
                        n10 = 56;
                        break;
                    }
                    case 3: {
                        n10 = 27;
                        break;
                    }
                    default: {
                        n10 = 50;
                    }
                }
                cArray[n11] = (char)(c4 ^ n10);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

