/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.GroupIDPrincipal;
import com.ibm.security.auth.PrimaryGroupIDPrincipal;
import com.ibm.security.auth.UserIDPrincipal;
import com.ibm.security.auth.UsernamePrincipal;
import com.ibm.security.auth.module.LinuxSystem;
import java.security.Principal;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxLoginModule2000
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = true;
    private LinuxSystem system;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UsernamePrincipal userPrincipal;
    private UserIDPrincipal uidPrincipal;
    private PrimaryGroupIDPrincipal gidPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        int n;
        long[] lArray = null;
        this.succeeded = false;
        this.system = new LinuxSystem();
        if (this.system == null) {
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule2000] Failed in Linux login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying Linux system identity information");
        }
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule2000]: succeeded importing info: ");
            System.out.println("\t\t\tuser     = " + this.system.getUsername());
            System.out.println("\t\t\tuser id  = " + this.system.getUid());
            System.out.println("\t\t\tgroup id = " + this.system.getGid());
            lArray = this.system.getGroups();
            for (n = 0; n < lArray.length; ++n) {
                System.out.println("\t\t\tsupp gid = " + lArray[n]);
            }
        }
        this.userPrincipal = new UsernamePrincipal(this.system.getUsername());
        this.uidPrincipal = new UserIDPrincipal(this.system.getUid());
        this.gidPrincipal = new PrimaryGroupIDPrincipal(this.system.getGid());
        if (this.system.getGroups() != null && this.system.getGroups().length > 0) {
            lArray = this.system.getGroups();
        }
        for (n = 0; n < lArray.length; ++n) {
            GroupIDPrincipal groupIDPrincipal = new GroupIDPrincipal(lArray[n]);
            if (groupIDPrincipal.getName().equals(this.gidPrincipal.getName())) continue;
            this.supplementaryGroups.add(groupIDPrincipal);
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule2000]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.userPrincipal)) {
            set.add((Principal)this.userPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule2000]: added UsernamePrincipal");
            }
        }
        if (!set.contains(this.uidPrincipal)) {
            set.add((Principal)this.uidPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule2000]: added UserIDPrincipal");
            }
        }
        if (!set.contains(this.gidPrincipal)) {
            set.add((Principal)this.gidPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule2000]: added PrimaryGroupIDPrincipal");
            }
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (set.contains((GroupIDPrincipal)this.supplementaryGroups.get(i))) continue;
            set.add((Principal)((GroupIDPrincipal)this.supplementaryGroups.get(i)));
            if (!this.debug) continue;
            System.out.println("\t\t[LinuxLoginModule2000]: added GroupIDPrincipal");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule2000]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.system = null;
            this.succeeded = false;
            this.userPrincipal = null;
            this.uidPrincipal = null;
            this.gidPrincipal = null;
            this.supplementaryGroups = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        set.remove(this.userPrincipal);
        set.remove(this.uidPrincipal);
        set.remove(this.gidPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            set.remove((GroupIDPrincipal)this.supplementaryGroups.get(i));
        }
        this.system = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.uidPrincipal = null;
        this.gidPrincipal = null;
        this.supplementaryGroups = null;
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule2000]: logged out Subject");
        }
        return true;
    }
}

